/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.commonNativeInstallAdapter;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.PerformChildInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.LogOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.Messages;
import com.ibm.cic.common.commonNativeAdapterData.AbstractExecCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ArgCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.LogCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.MsgCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractExecInstallOperation
extends PerformChildInstallOperation {
    private static final Logger log = Logger.getLogger(AbstractExecInstallOperation.class);
    private final AbstractExecCommonNativeData data;
    protected final ICommonNativeInstallAdapter.SupplementaryLogWriter writer;

    public AbstractExecInstallOperation(int phase, IInstallableUnit unit, InstallContext context, AbstractExecCommonNativeData data, PerformCommonNativeData performData, ICommonNativeInstallAdapter.SupplementaryLogWriter writer) {
        super(phase, unit, context, performData);
        this.data = data;
        this.writer = writer;
    }

    protected CommonAdapterData getData() {
        return this.data;
    }

    protected String[] getArguments() {
        ArgCommonNativeData[] argsData = this.data.getArguments();
        String[] result = new String[argsData.length];
        int i = 0;
        while (i < argsData.length) {
            ArgCommonNativeData argData = argsData[i];
            result[i] = this.getArgument(argData);
            ++i;
        }
        return result;
    }

    private String getArgument(ArgCommonNativeData argData) {
        MsgCommonNativeData[] msgs;
        LogCommonNativeData[] logs = argData.getLogs();
        if (logs.length > 0 && (msgs = logs[0].getMessages()).length > 0) {
            try {
                String href = this.performVariableSubstitutions(msgs[0].getHref(), AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
                msgs[0].setHref(href);
                return href;
            }
            catch (AbstractVariableSubstitution.VariableSubstitutionException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
            }
        }
        String argText = argData.getArgText();
        try {
            return this.performVariableSubstitutions(argText, AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {
            return argText;
        }
    }

    protected void performLogOperations(IProgressMonitor monitor) {
        ArgCommonNativeData[] argsData;
        ArgCommonNativeData[] argCommonNativeDataArray = argsData = this.data.getArguments();
        int n = argsData.length;
        int n2 = 0;
        while (n2 < n) {
            ArgCommonNativeData element = argCommonNativeDataArray[n2];
            LogCommonNativeData[] logs = element.getLogs();
            this.performLogOperations(monitor, logs);
            ++n2;
        }
        this.performLogOperations(monitor, this.data.getLogs());
    }

    private void performLogOperations(IProgressMonitor monitor, LogCommonNativeData[] logs) {
        LogCommonNativeData[] logCommonNativeDataArray = logs;
        int n = logs.length;
        int n2 = 0;
        while (n2 < n) {
            LogCommonNativeData log2 = logCommonNativeDataArray[n2];
            LogOperation op = new LogOperation(this.getPhase(), this.getUnit(), this.getInstallContext(), log2, log);
            IStatus status = op.perform(InstallTransaction.NULL, monitor);
            log.statusNotOK(status);
            ++n2;
        }
    }

    protected void logCompletion() {
        String description = this.data.getDescription();
        try {
            description = this.performVariableSubstitutions(description);
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {}
        File logFile = this.writer.getFile();
        IIdentity iu = this.getUnit().getIdentity();
        if (logFile != null && logFile.length() > 0L) {
            log.log(Level.INFO, logFile.getPath(), Messages.AbstractExecInstallOperation_Custom_Operation_Completed_Log, new Object[]{description, iu, logFile.getName()});
        } else {
            log.info(Messages.AbstractExecInstallOperation_Custom_Operation_Completed, new Object[]{description, iu});
        }
    }
}

