/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.server.jetty;

import com.ibm.cic.agent.server.jetty.Messages;
import com.ibm.cic.common.core.utils.ApplicationArguments;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.InternetUtils;
import com.ibm.cic.common.core.utils.JettyDataKeeper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Dictionary;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.osgi.util.NLS;

public class AgentJettyCustomizer
extends JettyCustomizer {
    private static final String SECURE = "-secure";
    private static final String URL_CONTEXT_PATH = "ibmim";
    private Integer port;
    private String host;

    private static void customizeSessionManager(Object context) {
        SessionManager sessionManager;
        ServletContextHandler jettyContext;
        SessionHandler sessionHandler;
        if (context instanceof ServletContextHandler && (sessionHandler = (jettyContext = (ServletContextHandler)context).getSessionHandler()) != null && (sessionManager = sessionHandler.getSessionManager()) instanceof AbstractSessionManager) {
            ((AbstractSessionManager)sessionManager).setUsingCookies(false);
        }
    }

    public Object customizeContext(Object context, Dictionary<String, ?> settings) {
        boolean isSecureMode = ApplicationArguments.getInstance().contains(SECURE);
        JettyDataKeeper.INSTANCE.load();
        if (isSecureMode && JettyDataKeeper.INSTANCE.getPasscode() == null) {
            JettyDataKeeper.INSTANCE.setPasscode(this.promptUserForServerPassword());
        }
        StringBuffer url = new StringBuffer();
        this.port = 80;
        if (isSecureMode) {
            url.append("https://");
            this.port = (Integer)settings.get("https.port");
        } else {
            url.append("http://");
            this.port = (Integer)settings.get("http.port");
        }
        this.host = InternetUtils.getCurrentHostIp();
        url.append(this.host);
        url.append(":");
        url.append(this.port);
        url.append("/");
        url.append(URL_CONTEXT_PATH);
        if (this.checkUrlAvailability()) {
            String message = NLS.bind((String)Messages.AgentJettyCustomizer_ProcessConflictMessage, (Object)url);
            System.out.println(message);
            throw new RuntimeException(message);
        }
        System.out.println(NLS.bind((String)Messages.AgentJettyCustomizer_StartMessage, (Object)url));
        Object result = super.customizeContext(context, settings);
        AgentJettyCustomizer.customizeSessionManager(result);
        return context;
    }

    private boolean checkUrlAvailability() {
        int ATTEMPTS_UNTIL_ADDRESS_IS_AVAILABLE = 15;
        int ATTEMPT_DELAY = 1000;
        boolean connected = false;
        try {
            InetSocketAddress address = new InetSocketAddress(this.host, (int)this.port);
            int attemptsCount = JettyDataKeeper.INSTANCE.isRestarting() ? ATTEMPTS_UNTIL_ADDRESS_IS_AVAILABLE : 1;
            int i = 0;
            while (i < attemptsCount) {
                Socket socket = new Socket();
                socket.connect(address, 1000);
                connected = socket.isConnected();
                socket.close();
                if (connected && JettyDataKeeper.INSTANCE.isRestarting()) {
                    Thread.sleep(ATTEMPT_DELAY);
                }
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException e) {
            boolean cfr_ignored_0 = e instanceof SocketTimeoutException;
        }
        catch (InterruptedException interruptedException) {}
        return connected;
    }

    private String promptUserForServerPassword() {
        String password;
        while (true) {
            boolean validEntry;
            password = FileUtil.readPasswordFromStdIn((String)Messages.AgentServerManager_PasswordPrompt);
            String passwordConf = FileUtil.readPasswordFromStdIn((String)Messages.AgentServerManager_PasswordPromptConfirmation);
            boolean bl = validEntry = password != null && !password.isEmpty();
            if (!validEntry) {
                System.out.println(Messages.AgentJettyCustomizer_EmptyPasswordError);
                continue;
            }
            if (password.contentEquals(passwordConf)) break;
            System.out.println(Messages.AgentJettyCustomizer_NonMatchingEntries);
        }
        return password;
    }

    public Object customizeHttpConnector(Object connector, Dictionary<String, ?> settings) {
        boolean isSecureMode = ApplicationArguments.getInstance().contains(SECURE);
        if (isSecureMode) {
            return null;
        }
        return super.customizeHttpConnector(connector, settings);
    }

    public Object customizeHttpsConnector(Object connector, Dictionary<String, ?> settings) {
        boolean isSecureMode = ApplicationArguments.getInstance().contains(SECURE);
        if (!isSecureMode) {
            return null;
        }
        return super.customizeHttpsConnector(connector, settings);
    }
}

