/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.AbstractLicPlatformPolicyFactory;
import com.ibm.cic.licensing.common.util.LicPlatformUtils;
import com.ibm.cic.licensing.common.util.Logger;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

class PPLicUserUtils
extends AbstractLicPlatformPolicyFactory {
    static PPLicUserUtils m_factory = new PPLicUserUtils();

    PPLicUserUtils() {
    }

    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        protected static final String USERHOME = "user.home";
        protected static final String PRODUCT = "Installation Manager";
        protected static final String APPDATA = "Application Data";
        protected static final String IBM_UPPERCASE = "IBM";
        protected static final String DOT_IBM = ".ibm";
        protected static final String PRODUCT_NO_SPACE = "InstallationManager";
        protected static final String IBM_LOWERCASE = "ibm";

        PPCommon() {
        }

        abstract IPath getUserHomeDirectory();

        abstract IPath getCommChannelDir();

        abstract IPath getUserLicenseLocation();

        abstract IPath getAllUserProductLocation();

        abstract IPath getAllUserDirectory();
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        IPath getUserHomeDirectory() {
            String userHome = System.getProperty("user.home");
            if (userHome == null || userHome.length() == 0) {
                userHome = LicPlatformUtils.getEnvironmentVariable("HOME");
            }
            return new Path(userHome);
        }

        IPath getUserLicenseLocation() {
            IPath return_value = this.getUserHomeDirectory();
            return_value = return_value.append(".ibm").append("InstallationManager").append("license");
            return return_value;
        }

        IPath getAllUserProductLocation() {
            IPath return_value = this.getAllUserDirectory();
            return_value = return_value.append("ibm").append("InstallationManager");
            return return_value;
        }

        IPath getAllUserDirectory() {
            IPath userhome = PPLicUserUtils.getPolicy().getUserHomeDirectory();
            try {
                return new Path("/var");
            }
            catch (Exception e) {
                Logger.logNtrace("Error getting to all users directory", e);
                return userhome;
            }
        }

        IPath getCommChannelDir() {
            return this.getAllUserProductLocation();
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        IPath getUserHomeDirectory() {
            String userHome = System.getProperty("user.home");
            if (userHome == null || userHome.length() == 0) {
                userHome = LicPlatformUtils.getEnvironmentVariable("USERPROFILE");
            }
            return new Path(userHome);
        }

        IPath getUserLicenseLocation() {
            IPath return_value = this.getUserHomeDirectory();
            return_value = return_value.append("Application Data").append("IBM").append("Installation Manager").append("license");
            return return_value;
        }

        IPath getAllUserProductLocation() {
            IPath return_value = this.getAllUserDirectory();
            return_value = return_value.append("Application Data").append("IBM").append("Installation Manager");
            return return_value;
        }

        IPath getAllUserDirectory() {
            IPath userhome = PPLicUserUtils.getPolicy().getUserHomeDirectory();
            try {
                String allUsersDir = LicPlatformUtils.getEnvironmentVariable("ALLUSERSPROFILE");
                if (allUsersDir != null) {
                    return new Path(allUsersDir);
                }
                File userparent = userhome.toFile().getParentFile();
                IPath allUserPath = new Path(userparent.getCanonicalPath()).append("All Users");
                if (!allUserPath.toFile().exists()) {
                    allUserPath.toFile().mkdirs();
                }
                return allUserPath;
            }
            catch (Exception e) {
                Logger.logNtrace("Error getting to all users directory", e);
                return userhome;
            }
        }

        IPath getCommChannelDir() {
            return this.getAllUserDirectory();
        }
    }
}

