/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.gc.GCJNIGlobalReferenceIterator;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckJNIGlobalReferences
extends Check {
    CheckJNIGlobalReferences() {
    }

    public void check() {
        try {
            VoidPointer globalRefs = VoidPointer.cast(this.getJavaVM().jniGlobalReferences());
            GCJNIGlobalReferenceIterator jniGlobalReferenceIterator = GCJNIGlobalReferenceIterator.from();
            while (jniGlobalReferenceIterator.hasNext()) {
                PointerPointer slot = PointerPointer.cast(jniGlobalReferenceIterator.nextAddress());
                if (!slot.notNull() || this._engine.checkSlotPool(slot, globalRefs) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    public String getCheckName() {
        return "JNI GLOBAL REFS";
    }

    public void print() {
        try {
            VoidPointer globalRefs = VoidPointer.cast(this.getJavaVM().jniGlobalReferences());
            GCJNIGlobalReferenceIterator jniGlobalReferenceIterator = GCJNIGlobalReferenceIterator.from();
            ScanFormatter formatter = new ScanFormatter(this, "jniGlobalReferences", globalRefs);
            while (jniGlobalReferenceIterator.hasNext()) {
                J9ObjectPointer slot = jniGlobalReferenceIterator.next();
                if (!slot.notNull()) continue;
                formatter.entry(slot);
            }
            formatter.end("jniGlobalReferences", globalRefs);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

