/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.JITLook;
import com.ibm.j9ddr.vm26.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.io.PrintStream;

public class JitMetadataFromPcCommand
extends Command {
    public JitMetadataFromPcCommand() {
        this.addCommand("jitmetadatafrompc", "<pc>", "Show jit method metadata for PC");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            UDATA searchValue = new UDATA(Long.decode(args[0]));
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9JITExceptionTablePointer metaData = JITLook.jit_artifact_search(vm.jitConfig().translationArtifacts(), searchValue);
            if (!metaData.isNull()) {
                this.dbgext_j9jitexceptiontable(out, metaData);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    void dbgext_j9jitexceptiontable(PrintStream out, J9JITExceptionTablePointer parm) throws CorruptDataException {
        CommandUtils.dbgPrint(out, "J9JITExceptionTable at %s {\n", parm.getHexAddress());
        CommandUtils.dbgPrint(out, "    struct J9UTF8* className = !j9utf8 %s   // %s\n", parm.className().getHexAddress(), parm.className().isNull() ? "NULL" : J9UTF8Helper.stringValue(parm.className()));
        CommandUtils.dbgPrint(out, "    struct J9UTF8* methodName = !j9utf8 %s   // %s\n", parm.methodName().getHexAddress(), parm.methodName().isNull() ? "NULL" : J9UTF8Helper.stringValue(parm.methodName()));
        CommandUtils.dbgPrint(out, "    struct J9UTF8* methodSignature = !j9utf8 %s   // %s\n", parm.methodSignature().getHexAddress(), parm.methodSignature().isNull() ? "NULL" : J9UTF8Helper.stringValue(parm.methodSignature()));
        CommandUtils.dbgPrint(out, "    struct J9ConstantPool* constantPool = !j9constantpool %s \n", parm.constantPool().getHexAddress());
        CommandUtils.dbgPrint(out, "    struct J9Method* ramMethod = !j9method %s   // %s\n", parm.ramMethod().getHexAddress(), J9MethodHelper.getName(parm.ramMethod()));
        CommandUtils.dbgPrint(out, "    UDATA parm.startPC = %s;\n", parm.startPC().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.endWarmPC = %s;\n", parm.endWarmPC().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.startColdPC = %s;\n", parm.startColdPC().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.endPC = %s;\n", parm.endPC().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.totalFrameSize = %s;\n", parm.totalFrameSize().getHexValue());
        CommandUtils.dbgPrint(out, "    I_16 parm.slots = %s;\n", parm.slots().getHexValue());
        CommandUtils.dbgPrint(out, "    I_16 parm.scalarTempSlots = %s;\n", parm.scalarTempSlots().getHexValue());
        CommandUtils.dbgPrint(out, "    I_16 parm.objectTempSlots = %s;\n", parm.objectTempSlots().getHexValue());
        CommandUtils.dbgPrint(out, "    U_16 parm.prologuePushes = %s;\n", parm.prologuePushes().getHexValue());
        CommandUtils.dbgPrint(out, "    I_16 parm.tempOffset = %s;\n", parm.tempOffset().getHexValue());
        CommandUtils.dbgPrint(out, "    U_16 parm.numExcptionRanges = %s;\n", parm.numExcptionRanges().getHexValue());
        CommandUtils.dbgPrint(out, "    I_32 parm.size = %s;\n", parm.size().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.assumptionFlags = %s;\n", parm.assumptionFlags().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.registerSaveDescription = %s;\n", parm.registerSaveDescription().getHexValue());
        CommandUtils.dbgPrint(out, "    void* relocationData = !void %s \n", parm.relocationData().getHexAddress());
        CommandUtils.dbgPrint(out, "    void* gcStackAtlas = !void %s \n", parm.gcStackAtlas().getHexAddress());
        CommandUtils.dbgPrint(out, "    void* inlinedCalls = !void %s \n", parm.inlinedCalls().getHexAddress());
        CommandUtils.dbgPrint(out, "    void* bodyInfo = !void %s \n", parm.bodyInfo().getHexAddress());
        CommandUtils.dbgPrint(out, "    struct J9JITExceptionTable* nextMethod = !j9jitexceptiontable %s \n", parm.nextMethod().getHexAddress());
        CommandUtils.dbgPrint(out, "    UDATA parm.compileMethodCodeStartPC = %s;\n", parm.compileMethodCodeStartPC().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.compileMethodCodeSize = %s;\n", parm.compileMethodCodeSize().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.compileMethodDataStartPC = %s;\n", parm.compileMethodDataStartPC().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.compileMethodDataSize = %s;\n", parm.compileMethodDataSize().getHexValue());
        CommandUtils.dbgPrint(out, "    UDATA parm.compileFirstClassLocation = %s;\n", parm.compileFirstClassLocation().getHexValue());
        CommandUtils.dbgPrint(out, "}\n");
    }
}

