/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import java.io.PrintStream;

public class FindMethodFromPcCommand
extends Command {
    public FindMethodFromPcCommand() {
        this.addCommand("findmethodfrompc", "<pc>", "find the method corresponding to pc");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            U8Pointer pc = U8Pointer.cast(address);
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (pc.isNull()) {
                CommandUtils.dbgPrint(out, "bad or missing PC\n");
                return;
            }
            CommandUtils.dbgPrint(out, "Searching for PC=%s in VM=%s...\n", pc.getHexAddress(), vm.getHexAddress());
            J9MethodPointer result = J9JavaVMHelper.getMethodFromPC(vm, pc);
            if (!result.isNull()) {
                CommandUtils.dbgPrint(out, "!j9method %s %s\n", result.getHexAddress(), J9MethodHelper.getName(result));
                CommandUtils.dbgPrint(out, "Bytecode PC offset = %s\n", pc.sub(result.bytecodes()).getHexValue());
            } else {
                CommandUtils.dbgPrint(out, "Not found\n");
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

