/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.RamClassWalker;
import java.io.PrintStream;

public class DumpRamClassLinearCommand
extends Command {
    public DumpRamClassLinearCommand() {
        this.addCommand("dumpramclasslinear", "<addr>[,n]", "cfdump the specified J9RAMClass using Linear RAM Class Dumper");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            throw new DDRInteractiveCommandException("This debug extension needs an address argument !dumpramclasslinear <addr>[,n]");
        }
        String[] arguments = args[0].split(",");
        long addr = Long.decode(arguments[0]);
        long nestingThreshold = arguments.length > 1 ? Long.decode(arguments[1]) : 1L;
        J9ClassPointer clazz = J9ClassPointer.cast(addr);
        try {
            out.println(String.format("RAM Class '%s' at %s", J9UTF8Helper.stringValue(clazz.romClass().className()), clazz.getHexAddress()));
            RamClassWalker classWalker = new RamClassWalker(clazz, context);
            new LinearDumper().gatherLayoutInfo(out, classWalker, nestingThreshold);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

