/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.MonitorTable;
import com.ibm.j9ddr.vm26.j9.MonitorTableList;
import com.ibm.j9ddr.vm26.j9.MonitorTableListIterator;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.commands.StackWalkCommand;
import com.ibm.j9ddr.vm26.types.U8;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.io.PrintStream;

public class ThreadsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public ThreadsCommand() {
        this.addCommand("threads", "cmd|help", "Lists VM threads");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            this.displayThreads(out);
        } else {
            String argument = args[0];
            if (argument.equalsIgnoreCase("help")) {
                this.help(out);
            } else {
                out.append("Attached Threads List. For more options, run !threads help\n");
                out.append(nl);
                if (argument.equalsIgnoreCase("stack")) {
                    this.stack(out, context, "");
                } else if (argument.equalsIgnoreCase("stackslots")) {
                    this.stack(out, context, "!stackslots");
                } else if (argument.equalsIgnoreCase("flags")) {
                    this.flags(out);
                } else if (argument.equalsIgnoreCase("debugEventData")) {
                    if (J9BuildFlags.interp_debugSupport) {
                        this.debugEventData(out);
                    }
                } else if (argument.equalsIgnoreCase("search")) {
                    this.search(out, new UDATA(Long.decode(args[1])));
                } else if (argument.equalsIgnoreCase("monitors")) {
                    this.monitors(out);
                } else if (argument.equalsIgnoreCase("trace") && J9BuildFlags.ras_tdfTrace) {
                    this.trace(out);
                }
            }
        }
    }

    private String getThreadName(J9VMThreadPointer thread) throws CorruptDataException {
        U8Pointer threadName = thread.threadName();
        StringBuffer sb = new StringBuffer();
        if (threadName.isNull()) {
            sb.append("<NULL>");
        } else {
            while (!threadName.at(0L).eq(0L)) {
                U8 at = threadName.at(0L);
                sb.append((char)at.intValue());
                threadName = threadName.add(1L);
            }
        }
        return sb.toString();
    }

    private void trace(PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            if (mainThread.notNull()) {
                J9VMThreadPointer threadCursor = vm.mainThread();
                do {
                    out.append(String.format("    !stack 0x%s  !j9vmthread 0x%s  !j9thread 0x%s  tid 0x%s (%d) !utthreaddata 0x%s // %s", Long.toHexString(threadCursor.getAddress()), Long.toHexString(threadCursor.getAddress()), Long.toHexString(threadCursor.osThread().getAddress()), Long.toHexString(threadCursor.osThread().tid().longValue()), threadCursor.osThread().tid().longValue(), Long.toHexString(threadCursor.uteThread().getAddress()), this.getThreadName(threadCursor)));
                    out.append(nl);
                } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void monitors(PrintStream out) throws DDRInteractiveCommandException {
        try {
            MonitorTableListIterator iterator = MonitorTableList.from().iterator();
            MonitorTable previousMonitorTable = null;
            while (iterator.hasNext()) {
                J9ObjectMonitorPointer objectMonitorPointer = iterator.next();
                MonitorTable currentMonitorTable = iterator.currentMonitorTable();
                if (!currentMonitorTable.equals(previousMonitorTable)) {
                    out.append("Table = " + currentMonitorTable.getTableName() + ", itemCount=" + currentMonitorTable.getCount());
                    out.append(nl);
                }
                out.append(String.format("\n    !j9thread 0x%s    !j9threadmonitor 0x%s", Long.toHexString(objectMonitorPointer.monitor().owner().getAddress()), Long.toHexString(objectMonitorPointer.monitor().getAddress())));
                out.append(nl);
                previousMonitorTable = currentMonitorTable;
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void search(PrintStream out, UDATA tid) throws DDRInteractiveCommandException {
        block3: {
            try {
                J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
                J9VMThreadPointer mainThread = vm.mainThread();
                if (!mainThread.notNull()) break block3;
                J9VMThreadPointer threadCursor = vm.mainThread();
                do {
                    if (!threadCursor.osThread().tid().eq(tid)) continue;
                    out.println(String.format("\t!stack 0x%08x\t!j9vmthread 0x%08x\t!j9thread 0x%08x\ttid 0x%x (%d) // %s", threadCursor.getAddress(), threadCursor.getAddress(), threadCursor.osThread().getAddress(), threadCursor.osThread().tid().longValue(), threadCursor.osThread().tid().longValue(), this.getThreadName(threadCursor)));
                    break;
                } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
            }
            catch (CorruptDataException e) {
                throw new DDRInteractiveCommandException(e);
            }
        }
    }

    private void debugEventData(PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            if (mainThread.notNull()) {
                J9VMThreadPointer threadCursor = vm.mainThread();
                do {
                    out.append(String.format("    !j9vmthread 0x%s %s %s %s %s %s %s %s %s", Long.toHexString(threadCursor.getAddress()), Long.toHexString(threadCursor.debugEventData1().longValue()), Long.toHexString(threadCursor.debugEventData2().longValue()), Long.toHexString(threadCursor.debugEventData3().longValue()), Long.toHexString(threadCursor.debugEventData4().longValue()), Long.toHexString(threadCursor.debugEventData5().longValue()), Long.toHexString(threadCursor.debugEventData6().longValue()), Long.toHexString(threadCursor.debugEventData7().longValue()), Long.toHexString(threadCursor.debugEventData8().longValue())));
                    out.append(nl);
                } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void flags(PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            if (mainThread.notNull()) {
                J9VMThreadPointer threadCursor = vm.mainThread();
                do {
                    out.append(String.format("    !j9vmthread 0x%s publicFlags=%s privateFlags=%s // %s", Long.toHexString(threadCursor.getAddress()), Long.toHexString(threadCursor.publicFlags().longValue()), Long.toHexString(threadCursor.privateFlags().longValue()), this.getThreadName(threadCursor)));
                    out.append(nl);
                } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void stack(PrintStream out, Context context, String command) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            StackWalkCommand walkCommand = new StackWalkCommand();
            if (mainThread.notNull()) {
                J9VMThreadPointer threadCursor = vm.mainThread();
                do {
                    out.println(String.format("\t!stack 0x%08x\t!j9vmthread 0x%08x\t!j9thread 0x%08x\ttid 0x%x (%d) // %s", threadCursor.getAddress(), threadCursor.getAddress(), threadCursor.osThread().getAddress(), threadCursor.osThread().tid().longValue(), threadCursor.osThread().tid().longValue(), this.getThreadName(threadCursor)));
                    out.append(nl);
                    walkCommand.run(command, new String[]{Long.toString(threadCursor.getAddress())}, context, out);
                    out.append(nl);
                } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void help(PrintStream out) {
        out.append("!threads            -- list all threads in the VM");
        out.append(nl);
        out.append("!threads stack      -- list stacks for all threads in the VM");
        out.append(nl);
        out.append("!threads stackslots -- list stackslots for all threads in the VM");
        out.append(nl);
        out.append("!threads flags      -- print the public and private flags field for each thread");
        out.append(nl);
        if (J9BuildFlags.interp_debugSupport) {
            out.append("!threads debugEventData -- print the debugEventData fields for each thread");
            out.append(nl);
        }
        out.append("!threads search     -- find a thread by thread id");
        out.append(nl);
        out.append("!threads monitors     -- list all monitors owned by each thread");
        out.append(nl);
        if (J9BuildFlags.ras_tdfTrace) {
            out.append("!threads trace     -- show UTE thread information");
            out.append(nl);
        }
    }

    private void displayThreads(PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9VMThreadPointer mainThread = vm.mainThread();
            if (mainThread.notNull()) {
                J9VMThreadPointer threadCursor = vm.mainThread();
                do {
                    out.println(String.format("\t!stack 0x%08x\t!j9vmthread 0x%08x\t!j9thread 0x%08x\ttid 0x%x (%d) // (%s)", threadCursor.getAddress(), threadCursor.getAddress(), threadCursor.osThread().getAddress(), threadCursor.osThread().tid().longValue(), threadCursor.osThread().tid().longValue(), this.getThreadName(threadCursor)));
                } while (!(threadCursor = threadCursor.linkNext()).eq(mainThread));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

