/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.generated.EventTypePointer;
import com.ibm.j9ddr.vm26.pointer.generated.StoragePointer;
import com.ibm.j9ddr.vm26.structure.ValueEvent;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=ValueEvent.class)
public class ValueEventPointer
extends StoragePointer {
    public static final ValueEventPointer NULL = new ValueEventPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected ValueEventPointer(long address) {
        super(address);
    }

    public static ValueEventPointer cast(AbstractPointer structure) {
        return ValueEventPointer.cast(structure.getAddress());
    }

    public static ValueEventPointer cast(UDATA udata) {
        return ValueEventPointer.cast(udata.longValue());
    }

    public static ValueEventPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ValueEventPointer(address);
    }

    public ValueEventPointer add(long count) {
        return ValueEventPointer.cast(this.address + ValueEvent.SIZEOF * count);
    }

    public ValueEventPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public ValueEventPointer addOffset(long offset) {
        return ValueEventPointer.cast(this.address + offset);
    }

    public ValueEventPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public ValueEventPointer sub(long count) {
        return ValueEventPointer.cast(this.address - ValueEvent.SIZEOF * count);
    }

    public ValueEventPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public ValueEventPointer subOffset(long offset) {
        return ValueEventPointer.cast(this.address - offset);
    }

    public ValueEventPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public ValueEventPointer untag(long mask) {
        return ValueEventPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public ValueEventPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return ValueEvent.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_valueETOffset_", declaredType="class EventType*")
    public EventTypePointer valueET() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(ValueEvent._valueETOffset_);
        return EventTypePointer.cast(pointer);
    }

    public PointerPointer valueETEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)ValueEvent._valueETOffset_);
    }
}

