/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.j9.ObjectMonitor;
import com.ibm.j9ddr.vm26.j9.gc.MMObjectAccessBarrier;
import com.ibm.j9ddr.vm26.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.types.I32;
import com.ibm.j9ddr.vm26.types.UDATA;

class MMObjectAccessBarrier_V1
extends MMObjectAccessBarrier {
    private int shift = 0;

    protected MMObjectAccessBarrier_V1() throws CorruptDataException {
        if (J9BuildFlags.gc_compressedPointers) {
            try {
                J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
                this.shift = vm.compressedPointersShift().intValue();
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Error initializing the object access barrier", cde, true);
            }
        }
    }

    public J9ObjectPointer getFinalizeLink(J9ObjectPointer object) throws CorruptDataException {
        UDATA fieldOffset = J9ObjectHelper.clazz(object).finalizeLinkOffset();
        if (fieldOffset.eq(0L)) {
            return J9ObjectPointer.NULL;
        }
        return ObjectReferencePointer.cast(object.addOffset(fieldOffset)).at(0L);
    }

    public J9ObjectPointer getOwnableSynchronizerLink(J9ObjectPointer object) throws CorruptDataException {
        UDATA fieldOffset = MMObjectAccessBarrier_V1.getExtensions().accessBarrier()._ownableSynchronizerLinkOffset();
        if (fieldOffset.eq(0L)) {
            return J9ObjectPointer.NULL;
        }
        return ObjectReferencePointer.cast(object.addOffset(fieldOffset)).at(0L);
    }

    public J9ObjectPointer getReferenceLink(J9ObjectPointer object) throws CorruptDataException {
        UDATA linkOffset = MMObjectAccessBarrier_V1.getExtensions().accessBarrier()._referenceLinkOffset();
        return ObjectReferencePointer.cast(object.addOffset(linkOffset)).at(0L);
    }

    public I32 getObjectHashCode(J9ObjectPointer object) throws CorruptDataException, DataUnavailableException {
        return ObjectModel.getObjectHashCode(object);
    }

    public J9ObjectMonitorPointer getLockword(J9ObjectPointer object) throws CorruptDataException {
        return this.getMonitor(object).getLockword();
    }

    public ObjectMonitor getMonitor(J9ObjectPointer object) throws CorruptDataException {
        return ObjectMonitor.fromJ9Object(object);
    }

    public J9ObjectPointer convertPointerFromToken(long token) {
        if (token == 0L) {
            return J9ObjectPointer.NULL;
        }
        if (J9BuildFlags.gc_compressedPointers) {
            UDATA ref = new UDATA(token);
            ref = ref.leftShift(this.shift);
            return J9ObjectPointer.cast(ref);
        }
        return J9ObjectPointer.cast(token);
    }

    public long convertTokenFromPointer(J9ObjectPointer pointer) {
        if (pointer.isNull()) {
            return 0L;
        }
        UDATA address = UDATA.cast(pointer);
        if (J9BuildFlags.gc_compressedPointers) {
            address = address.rightShift(this.shift);
        }
        return address.longValue();
    }
}

