/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm26.j9.IAlgorithm;
import com.ibm.j9ddr.vm26.j9.ROMHelp;
import com.ibm.j9ddr.vm26.j9.walkers.LineNumber;
import com.ibm.j9ddr.vm26.j9.walkers.LineNumberIterator;
import com.ibm.j9ddr.vm26.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9EnclosingObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9SourceDebugExtensionPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VariableInfoPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.structure.J9Consts;
import com.ibm.j9ddr.vm26.structure.J9LineNumber;
import com.ibm.j9ddr.vm26.structure.J9MethodDebugInfo;
import com.ibm.j9ddr.vm26.structure.J9VariableInfo;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.LinkedList;

public class OptInfo {
    private static IOptInfoImpl impl;
    private static final AlgorithmPicker<IOptInfoImpl> picker;

    private static IOptInfoImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    public static int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
        return OptInfo.getImpl().getLineNumberForROMClass(method, relativePC);
    }

    public static J9MethodDebugInfoPointer getMethodDebugInfoForROMClass(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getMethodDebugInfoFromROMMethod(ROMHelp.getOriginalROMMethod(method));
    }

    private static SelfRelativePointer getSRPPtr(U32Pointer ptr, U32 flags, long option) {
        if (!flags.anyBitsIn(option) || ptr.isNull()) {
            return SelfRelativePointer.NULL;
        }
        return SelfRelativePointer.cast(ptr.add(OptInfo.countBits(OptInfo.COUNT_MASK(flags, option)) - 1));
    }

    public static int countBits(U32 word) {
        int count = 0;
        for (long x = word.longValue(); x != 0L; x >>= 1) {
            if ((x & 1L) == 0L) continue;
            ++count;
        }
        return count;
    }

    public static J9VariableInfoPointer getV0VariableTableForROMClass(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        return J9VariableInfoPointer.cast(OptInfo._getVariableTableForMethodDebugInfo(methodInfo));
    }

    public static U8Pointer getV1VariableTableForMethodDebugInfo(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        return U8Pointer.cast(OptInfo._getVariableTableForMethodDebugInfo(methodInfo));
    }

    private static VoidPointer _getVariableTableForMethodDebugInfo(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        if (!methodInfo.varInfoCount().eq(0L)) {
            U32 taggedSizeOrSRP = U32Pointer.cast(methodInfo).at(0L);
            if (taggedSizeOrSRP.allBitsIn(1L)) {
                U32 lineNumberTableSize = AlgorithmVersion.getVersionOf("VM_LINE_NUMBER_TABLE_VERSION").getAlgorithmVersion() < 1 ? methodInfo.lineNumberCount().mult((int)J9LineNumber.SIZEOF) : J9MethodDebugInfoHelper.getLineNumberCompressedSize(methodInfo);
                return VoidPointer.cast(U8Pointer.cast(methodInfo).addOffset(J9MethodDebugInfo.SIZEOF).addOffset(lineNumberTableSize));
            }
            return VoidPointer.cast(methodInfo.srpToVarInfo());
        }
        return VoidPointer.NULL;
    }

    public static UDATA variableInfoSize(UDATA modifiers) {
        UDATA size = new UDATA(J9VariableInfo.SIZEOF);
        if (modifiers.allBitsIn(J9Consts.J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC)) {
            size = size.add(4L);
        }
        return size;
    }

    public static U32 COUNT_MASK(U32 value, long mask) {
        return value.bitAnd((mask << 1) - 1L);
    }

    public static String getSourceFileNameForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9Consts.J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME);
    }

    public static String getSimpleNameForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9Consts.J9_ROMCLASS_OPTINFO_SIMPLE_NAME);
    }

    public static U32Pointer getClassAnnotationsDataForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, J9Consts.J9_ROMCLASS_OPTINFO_CLASS_ANNOTATION_INFO);
        return U32Pointer.cast(structure);
    }

    public static String getGenericSignatureForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9Consts.J9_ROMCLASS_OPTINFO_GENERIC_SIGNATURE);
    }

    public static J9EnclosingObjectPointer getEnclosingMethodForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, J9Consts.J9_ROMCLASS_OPTINFO_ENCLOSING_METHOD);
        if (!structure.isNull()) {
            return J9EnclosingObjectPointer.cast(structure);
        }
        return J9EnclosingObjectPointer.NULL;
    }

    private static String getOption(J9ROMClassPointer romClass, long option) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, option);
        if (structure != VoidPointer.NULL) {
            return J9UTF8Helper.stringValue(J9UTF8Pointer.cast(structure));
        }
        return null;
    }

    private static VoidPointer getStructure(J9ROMClassPointer romClass, long option) throws CorruptDataException {
        SelfRelativePointer ptr = OptInfo.getSRPPtr(romClass.optionalInfo(), romClass.optionalFlags(), option);
        if (!ptr.isNull()) {
            return VoidPointer.cast(ptr.get());
        }
        return VoidPointer.NULL;
    }

    public static J9SourceDebugExtensionPointer getSourceDebugExtensionForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        SelfRelativePointer srpPtr = OptInfo.getSRPPtr(romClass.optionalInfo(), romClass.optionalFlags(), J9Consts.J9_ROMCLASS_OPTINFO_SOURCE_DEBUG_EXTENSION);
        if (!srpPtr.isNull()) {
            return J9SourceDebugExtensionPointer.cast(srpPtr.get());
        }
        return J9SourceDebugExtensionPointer.NULL;
    }

    static {
        picker = new AlgorithmPicker<IOptInfoImpl>("OPT_INFO_VERSION"){

            @Override
            protected Iterable<? extends IOptInfoImpl> allAlgorithms() {
                LinkedList<OptInfo_26_V0> list = new LinkedList<OptInfo_26_V0>();
                list.add(new OptInfo_26_V0());
                return list;
            }
        };
    }

    private static interface IOptInfoImpl
    extends IAlgorithm {
        public int getLineNumberForROMClass(J9MethodPointer var1, UDATA var2) throws CorruptDataException;
    }

    private static class OptInfo_26_V0
    extends BaseAlgorithm
    implements IOptInfoImpl {
        protected OptInfo_26_V0() {
            super(60, 0);
        }

        public int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
            J9MethodDebugInfoPointer methodInfo;
            UDATA bytecodeSize = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(method));
            int number = -1;
            if ((relativePC.lt(bytecodeSize) || bytecodeSize.eq(0L)) && (methodInfo = OptInfo.getMethodDebugInfoForROMClass(method)).notNull()) {
                LineNumber lineNumber;
                LineNumberIterator lineNumberIterator = LineNumberIterator.lineNumberIteratorFor(methodInfo);
                while (lineNumberIterator.hasNext() && !relativePC.lt((lineNumber = (LineNumber)lineNumberIterator.next()).getLocation())) {
                    number = lineNumber.getLineNumber().intValue();
                }
            }
            return number;
        }
    }
}

