/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm26.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm26.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HiddenInstanceFieldPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.structure.J9Consts;
import com.ibm.j9ddr.vm26.structure.J9FieldFlags;
import com.ibm.j9ddr.vm26.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm26.structure.J9Object;
import com.ibm.j9ddr.vm26.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm26.types.IDATA;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9ObjectFieldOffsetIterator_V2
extends J9ObjectFieldOffsetIterator {
    private J9JavaVMPointer vm;
    private J9ROMClassPointer romClass;
    private J9ClassPointer superClazz;
    private Iterator romFieldsShapeIterator;
    private J9ClassPointer clazz;
    private boolean hiddenFieldOffsetResolutionRequired;
    private U32 doubleCount = new U32(0L);
    private U32 doubleSeen = new U32(0L);
    private U32 doubleStaticsSeen = new U32(0L);
    private UDATA firstDoubleOffset = new UDATA(0L);
    private UDATA firstSingleOffset = new UDATA(0L);
    private UDATA firstObjectOffset = new UDATA(0L);
    private U32 objectCount = new U32(0L);
    private U32 objectsSeen = new U32(0L);
    private U32 objectStaticsSeen = new U32(0L);
    private U32 singleCount = new U32(0L);
    private U32 singlesSeen = new U32(0L);
    private U32 singleStaticsSeen = new U32(0L);
    private U32 backfillEligibleFields = new U32(0L);
    private U32 walkFlags = new U32(0L);
    private J9ROMFieldShapePointer field;
    private UDATA index = new UDATA(0L);
    private UDATA instanceSize = new UDATA(0L);
    private UDATA offset = new UDATA(0L);
    private UDATA superTotalInstanceSize = new UDATA(0L);
    private IDATA backfillOffset = new IDATA(-1L);
    private IDATA backfillOffsetToUse = new IDATA(-1L);
    private UDATA lockwordNeeded = new UDATA(0L);
    private UDATA lockOffset = new UDATA(0L);
    private boolean isHidden;
    private UDATA finalizeLinkOffset = new UDATA(0L);
    private int hiddenInstanceFieldWalkIndex = -1;
    private ArrayList<HiddenInstanceField> hiddenInstanceFields = new ArrayList();
    private static final int fj9object_t_SizeOf = J9BuildFlags.gc_compressedPointers ? 4 : UDATA.SIZEOF;
    private static final int j9objectmonitor_t_SizeOf = J9BuildFlags.interp_smallMonitorSlot ? 4 : UDATA.SIZEOF;
    private static final IDATA BACKFILL_SIZE = new IDATA(4L);
    private static final IDATA LOCKWORD_SIZE = new IDATA(j9objectmonitor_t_SizeOf);
    private static final IDATA FINALIZE_LINK_SIZE = new IDATA(fj9object_t_SizeOf);
    private static final UDATA NO_LOCKWORD_NEEDED = new UDATA(-1L);
    private static final UDATA LOCKWORD_NEEDED = new UDATA(-2L);
    private static final String JAVA_LANG_CLASS_CLASSNAME = "java/lang/Class";
    private static final String JAVA_LANG_STRING_CLASSNAME = "java/lang/String";
    private static final String JAVA_LANG_BYTE_CLASSNAME = "java/lang/Byte";
    private static final String JAVA_LANG_CHARACTER_CLASSNAME = "java/lang/Character";
    private static final String JAVA_LANG_DOUBLE_CLASSNAME = "java/lang/Double";
    private static final String JAVA_LANG_FLOAT_CLASSNAME = "java/lang/Float";
    private static final String JAVA_LANG_INTEGER_CLASSNAME = "java/lang/Integer";
    private static final String JAVA_LANG_LONG_CLASSNAME = "java/lang/Long";
    private static final String JAVA_LANG_SHORT_CLASSNAME = "java/lang/Short";
    private static final String JAVA_MATH_BIGDECIMAL_CLASSNAME = "java/math/BigDecimal";
    private static final String JAVA_MATH_BIGINTEGER_CLASSNAME = "java/math/BigInteger";
    private static final String JAVA_MATH_MATHCONTEXT_CLASSNAME = "java/math/MathContext";
    private static final int LOCKNURSERY_ALGORITHM_ALL_BUT_ARRAY_AND_STRING = 0;
    private static final int LOCKNURSERY_ALGORITHM_ALL_INHERIT = 1;
    private static final int LOCKNURSERY_ALGORITHM_ALL_NO_INHERIT = 2;
    private static final int LOCKNURSERY_ALGORITHM_ALL_BUT_ARRAY_AND_STRING_AND_PRIM_WRAPPERS = 3;
    private static final int LOCKNURSERY_ALGORITHM_ALL_BUT_ARRAY_AND_STRING_AND_PRIM_WRAPPERS_AND_MATH = 4;
    private static final int LOCKNURSERY_ALGORITHM_MINIMAL_WITH_SYNCHRONIZED_METHODS = 5;
    private static final int LOCKNURSERY_ALGORITHM_NOBODY = 6;
    private static final int LOCKNURSERY_ALGORITHM_MINIMAL = 7;
    private static final int LOCKNURSERY_ALGORITHM_MINIMAL_INCLUDE_INNER_LOCK_CANDIDATES = 8;
    private static final int LOCKNURSERY_ALGORITHM_MINIMAL_AND_SYNCHRONIZED_METHODS_AND_INNER_LOCK_CANDIDATES = 9;
    private J9ObjectFieldOffset next;

    protected J9ObjectFieldOffsetIterator_V2(J9JavaVMPointer vm, J9ROMClassPointer romClass, J9ClassPointer clazz, J9ClassPointer superClazz, U32 flags) {
        this.vm = vm;
        this.romClass = romClass;
        this.clazz = clazz;
        this.superClazz = superClazz;
        this.walkFlags = flags;
    }

    private void init() throws CorruptDataException {
        this.initInstanceSize(this.romClass, this.superClazz);
        this.romFieldsShapeIterator = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
    }

    private void nextImpl() throws CorruptDataException {
        boolean walkHiddenFields = false;
        this.isHidden = false;
        this.field = null;
        if (this.hiddenInstanceFieldWalkIndex == -1) {
            this.fieldOffsetsFindNext();
            if (this.field == null && this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN)) {
                walkHiddenFields = true;
                this.hiddenInstanceFieldWalkIndex = this.hiddenInstanceFields.size();
            }
        } else {
            walkHiddenFields = true;
        }
        if (walkHiddenFields && this.hiddenInstanceFieldWalkIndex != 0) {
            HiddenInstanceField hiddenField = this.hiddenInstanceFields.get(--this.hiddenInstanceFieldWalkIndex);
            this.field = hiddenField.shape();
            this.isHidden = true;
            this.offset = new UDATA((long)hiddenField.fieldOffset().intValue() - J9Object.SIZEOF);
            this.index = new UDATA(-1L);
        }
    }

    private void fieldOffsetsFindNext() throws CorruptDataException {
        while (this.romFieldsShapeIterator.hasNext()) {
            J9ROMFieldShapePointer localField = (J9ROMFieldShapePointer)this.romFieldsShapeIterator.next();
            U32 modifiers = localField.modifiers();
            this.index = this.index.add(1L);
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) {
                if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC)) continue;
                if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                    this.offset = new UDATA(this.objectStaticsSeen.mult(UDATA.SIZEOF));
                    this.objectStaticsSeen = this.objectStaticsSeen.add(1);
                    this.field = localField;
                    break;
                }
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
                if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                    UDATA doubleSlots = J9BuildFlags.env_data64 ? new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount())) : new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount()).add(1)).rightShift(1);
                    this.offset = doubleSlots.mult(8).add(this.doubleStaticsSeen.mult(8));
                    this.doubleStaticsSeen = this.doubleStaticsSeen.add(1);
                } else {
                    this.offset = new UDATA(this.romClass.objectStaticCount().mult(UDATA.SIZEOF).add(this.singleStaticsSeen.mult(UDATA.SIZEOF)));
                    this.singleStaticsSeen = this.singleStaticsSeen.add(1);
                }
                this.field = localField;
                break;
            }
            if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD)) {
                    this.offset = new UDATA(this.backfillOffsetToUse);
                    this.walkFlags = this.walkFlags.bitAnd(new U32(new UDATA(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD).bitNot()));
                } else {
                    this.offset = this.firstObjectOffset.add(this.objectsSeen.mult(fj9object_t_SizeOf));
                    this.objectsSeen = this.objectsSeen.add(1);
                }
                this.field = localField;
                break;
            }
            if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.offset = this.firstDoubleOffset.add(this.doubleSeen.mult(8));
                this.doubleSeen = this.doubleSeen.add(1);
            } else if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD)) {
                this.offset = new UDATA(this.backfillOffsetToUse);
                this.walkFlags = this.walkFlags.bitAnd(new U32(new UDATA(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD).bitNot()));
            } else {
                this.offset = this.firstSingleOffset.add(this.singlesSeen.mult(4));
                this.singlesSeen = this.singlesSeen.add(1);
            }
            this.field = localField;
            break;
        }
    }

    private LinkedList<HiddenInstanceField> readHiddenInstanceFieldsList(J9JavaVMPointer vm) throws CorruptDataException {
        LinkedList<HiddenInstanceField> list = new LinkedList<HiddenInstanceField>();
        J9HiddenInstanceFieldPointer fieldPointer = vm.hiddenInstanceFields();
        while (!fieldPointer.isNull()) {
            list.add(new HiddenInstanceField(fieldPointer));
            fieldPointer = fieldPointer.next();
        }
        return list;
    }

    private void initInstanceSize(J9ROMClassPointer romClass, J9ClassPointer superClazz) throws CorruptDataException {
        if (J9BuildFlags.thr_lockNursery) {
            this.lockwordNeeded = NO_LOCKWORD_NEEDED;
        }
        if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_CALCULATE_INSTANCE_SIZE)) {
            return;
        }
        this.superTotalInstanceSize = superClazz.isNull() ? new UDATA(0L) : superClazz.totalInstanceSize();
        this.backfillOffset = new IDATA(-1L);
        if (superClazz.notNull() && !superClazz.backfillOffset().eq(superClazz.totalInstanceSize().add(J9Object.SIZEOF))) {
            this.backfillOffset = superClazz.backfillOffset().sub(J9Object.SIZEOF);
        }
        this.backfillOffsetToUse = new IDATA(-1L);
        LinkedList<HiddenInstanceField> extraHiddenFields = this.readHiddenInstanceFieldsList(this.vm);
        this.finalizeLinkOffset = new UDATA(0L);
        if (superClazz.notNull() && !superClazz.finalizeLinkOffset().eq(0L)) {
            this.finalizeLinkOffset = superClazz.finalizeLinkOffset();
        } else if (J9ROMClassHelper.finalizeNeeded(romClass)) {
            extraHiddenFields.addFirst(new HiddenInstanceField(this.vm.hiddenFinalizeLinkFieldShape()));
        }
        if (J9BuildFlags.thr_lockNursery) {
            this.lockwordNeeded = this.checkLockwordNeeded(romClass, superClazz, this.clazz);
            if ((this.lockwordNeeded.eq(LOCKWORD_NEEDED) || this.lockwordNeeded.eq(NO_LOCKWORD_NEEDED)) && superClazz.notNull() && !superClazz.lockOffset().eq(-1L) && !superClazz.classDepthAndFlags().anyBitsIn(J9Consts.J9_JAVA_CLASS_DEPTH_MASK)) {
                this.superTotalInstanceSize = this.superTotalInstanceSize.sub(LOCKWORD_SIZE);
                if (!this.backfillOffset.eq(-1L)) {
                    this.superTotalInstanceSize = this.superTotalInstanceSize.sub(BACKFILL_SIZE);
                    this.backfillOffset = new IDATA(-1L);
                }
            }
            this.lockOffset = new UDATA(this.lockwordNeeded);
            if (this.lockOffset.eq(LOCKWORD_NEEDED)) {
                extraHiddenFields.addFirst(new HiddenInstanceField(this.vm.hiddenLockwordFieldShape()));
            }
        }
        J9ROMFieldShapeIterator fields = new J9ROMFieldShapeIterator(romClass.romFields(), romClass.romFieldCount());
        while (fields.hasNext()) {
            J9ROMFieldShapePointer field = (J9ROMFieldShapePointer)fields.next();
            U32 modifiers = field.modifiers();
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                this.objectCount = this.objectCount.add(1);
                this.backfillEligibleFields = this.backfillEligibleFields.add(fj9object_t_SizeOf == BACKFILL_SIZE.intValue() ? 1 : 0);
                continue;
            }
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.doubleCount = this.doubleCount.add(1);
                continue;
            }
            this.singleCount = this.singleCount.add(1);
            this.backfillEligibleFields = this.backfillEligibleFields.add(1);
        }
        U32 originalSingleCount = this.singleCount;
        U32 originalDoubleCount = this.doubleCount;
        U32 originalObjectCount = this.objectCount;
        this.hiddenFieldOffsetResolutionRequired = false;
        String className = J9UTF8Helper.stringValue(romClass.className());
        for (HiddenInstanceField hiddenField : extraHiddenFields) {
            if (hiddenField.className() != null && !className.equals(hiddenField.className())) continue;
            U32 modifiers = hiddenField.shape().modifiers();
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                this.objectCount = this.objectCount.add(1);
                this.backfillEligibleFields = this.backfillEligibleFields.add(fj9object_t_SizeOf == BACKFILL_SIZE.intValue() ? 1 : 0);
            } else if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.doubleCount = this.doubleCount.add(1);
            } else {
                this.singleCount = this.singleCount.add(1);
                this.backfillEligibleFields = this.backfillEligibleFields.add(1);
            }
            this.hiddenInstanceFields.add(hiddenField);
            if (!hiddenField.fieldOffset().eq(-1L)) continue;
            this.hiddenFieldOffsetResolutionRequired = true;
        }
        this.firstDoubleOffset = new UDATA(this.superTotalInstanceSize);
        if (!(AlgorithmVersion.getVersionOf("J9_OBJECT_FIELD_OFFSET_ITERATOR_VERSION").getAlgorithmVersion() < 1 && !superClazz.isNull() || this.doubleCount.eq(0L) && (this.singleCount.eq(0L) || fj9object_t_SizeOf != 8) || this.firstDoubleOffset.add(J9Object.SIZEOF).bitAnd(4).eq(0L))) {
            this.backfillOffset = new IDATA(this.firstDoubleOffset);
            this.firstDoubleOffset = this.firstDoubleOffset.add(BACKFILL_SIZE);
        }
        this.firstObjectOffset = this.firstDoubleOffset.add(this.doubleCount.mult(8));
        this.firstSingleOffset = this.firstObjectOffset.add(this.objectCount.mult(fj9object_t_SizeOf));
        this.instanceSize = this.firstSingleOffset.add(this.singleCount.mult(4));
        boolean useBackfillForFirstHiddenSingleField = false;
        boolean useBackfillForFirstHiddenObjectField = false;
        if (this.backfillOffset.gte(new IDATA(0L)) && !this.backfillEligibleFields.eq(0L)) {
            this.backfillOffsetToUse = new IDATA(this.backfillOffset);
            this.instanceSize = this.instanceSize.sub(BACKFILL_SIZE);
            this.backfillOffset = new IDATA(-1L);
            if (this.singleCount.gt(0)) {
                if (originalSingleCount.eq(0L)) {
                    useBackfillForFirstHiddenSingleField = true;
                } else {
                    this.walkFlags = this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD);
                    originalSingleCount = originalSingleCount.sub(1);
                }
            } else if (originalObjectCount.eq(0L)) {
                useBackfillForFirstHiddenObjectField = true;
            } else {
                this.walkFlags = this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD);
                originalObjectCount = originalObjectCount.sub(1);
            }
        }
        if (!this.hiddenInstanceFields.isEmpty()) {
            UDATA singleOffset = new UDATA(J9Object.SIZEOF + (long)this.firstSingleOffset.intValue() + (long)(originalSingleCount.intValue() * 4));
            UDATA doubleOffset = new UDATA(J9Object.SIZEOF + (long)this.firstDoubleOffset.intValue() + (long)(originalDoubleCount.intValue() * 8));
            UDATA objectOffset = new UDATA(J9Object.SIZEOF + (long)this.firstObjectOffset.intValue() + (long)(originalObjectCount.intValue() * fj9object_t_SizeOf));
            int fieldIndex = this.hiddenInstanceFields.size();
            do {
                HiddenInstanceField hiddenField;
                U32 modifiers;
                if ((modifiers = (hiddenField = this.hiddenInstanceFields.get(--fieldIndex)).shape().modifiers()).anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                    if (useBackfillForFirstHiddenObjectField) {
                        hiddenField.setFieldOffset(new UDATA(J9Object.SIZEOF + (long)this.backfillOffsetToUse.intValue()));
                        useBackfillForFirstHiddenObjectField = false;
                        continue;
                    }
                    hiddenField.setFieldOffset(objectOffset);
                    objectOffset = objectOffset.add(fj9object_t_SizeOf);
                    continue;
                }
                if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                    hiddenField.setFieldOffset(doubleOffset);
                    doubleOffset = doubleOffset.add(8L);
                    continue;
                }
                if (useBackfillForFirstHiddenSingleField) {
                    hiddenField.setFieldOffset(new UDATA(J9Object.SIZEOF + (long)this.backfillOffsetToUse.intValue()));
                    useBackfillForFirstHiddenSingleField = false;
                    continue;
                }
                hiddenField.setFieldOffset(singleOffset);
                singleOffset = singleOffset.add(4L);
            } while (0 != fieldIndex);
        }
        if (!this.instanceSize.add(J9Object.SIZEOF).bitAnd(4).eq(0L)) {
            this.backfillOffset = new IDATA(this.instanceSize);
            this.instanceSize = this.instanceSize.add(BACKFILL_SIZE);
        }
    }

    private UDATA checkLockwordNeeded(J9ROMClassPointer romClass, J9ClassPointer ramSuperClass, J9ClassPointer clazz) throws CorruptDataException {
        if (!J9BuildFlags.thr_lockNursery) {
            return NO_LOCKWORD_NEEDED;
        }
        if (clazz.lockOffset().eq(NO_LOCKWORD_NEEDED)) {
            return NO_LOCKWORD_NEEDED;
        }
        if (ramSuperClass != null && !ramSuperClass.isNull() && clazz.lockOffset().eq(ramSuperClass.lockOffset())) {
            return ramSuperClass.lockOffset();
        }
        return LOCKWORD_NEEDED;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.next = this.getNext();
        return this.next != null;
    }

    private J9ObjectFieldOffset getNext() {
        if (this.romFieldsShapeIterator == null) {
            try {
                this.init();
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("CorruptDataException in  com.ibm.j9ddr.vm26.j9.J9ObjectFieldOffsetIterator_V2.init()", e, false);
                return null;
            }
        }
        try {
            this.nextImpl();
            if (this.field == null) {
                return null;
            }
            return new J9ObjectFieldOffset(this.field, this.offset, this.isHidden);
        }
        catch (AddressedCorruptDataException e) {
            EventManager.raiseCorruptDataEvent("AddressedCorruptDataException getting next field offset.", e, false);
            return null;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("CorruptDataException getting next field offset.", e, false);
            return null;
        }
    }

    @Override
    public J9ObjectFieldOffset next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        J9ObjectFieldOffset toReturn = this.next;
        this.next = null;
        return toReturn;
    }

    private class HiddenInstanceField {
        private J9HiddenInstanceFieldPointer pointer;
        private J9ROMFieldShapePointer shape;
        private UDATA fieldOffset = new UDATA(0L);

        public HiddenInstanceField(J9HiddenInstanceFieldPointer pointer) throws CorruptDataException {
            this.pointer = pointer;
            this.shape = pointer.shape();
        }

        public HiddenInstanceField(J9ROMFieldShapePointer shape) {
            this.pointer = null;
            this.shape = shape;
        }

        public J9ROMFieldShapePointer shape() throws CorruptDataException {
            return this.shape;
        }

        public String className() throws CorruptDataException {
            String className = null;
            if (this.pointer != null && !this.pointer.className().isNull()) {
                className = J9UTF8Helper.stringValue(this.pointer.className());
            }
            return className;
        }

        public UDATA fieldOffset() {
            return this.fieldOffset;
        }

        public void setFieldOffset(UDATA fieldOffset) throws CorruptDataException {
            if (this.shape.eq(J9ObjectFieldOffsetIterator_V2.this.vm.hiddenFinalizeLinkFieldShape())) {
                J9ObjectFieldOffsetIterator_V2.this.finalizeLinkOffset = fieldOffset;
            } else if (this.shape.eq(J9ObjectFieldOffsetIterator_V2.this.vm.hiddenLockwordFieldShape())) {
                J9ObjectFieldOffsetIterator_V2.this.lockOffset = fieldOffset;
            }
            this.fieldOffset = fieldOffset;
        }
    }
}

