/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckCycle;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckEngine;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckReporterTTY;
import java.io.PrintStream;
import java.util.List;

public class GCCheckRunner
implements IBootstrapRunnable {
    public void run(IVMData vmData, Object[] userData) {
        List argList = (List)userData[0];
        String[] args = argList.toArray(new String[argList.size()]);
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            GCCheckRunner.run(vm, args, System.out);
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }

    public static void run(J9JavaVMPointer vm, String[] args, PrintStream out) throws CorruptDataException {
        String options = args.length > 0 ? args[0] : "";
        CheckReporterTTY reporter = new CheckReporterTTY(out);
        CheckEngine engine = new CheckEngine(vm, reporter);
        CheckCycle cycle = new CheckCycle(vm, engine, options);
        out.println("Starting GC Check");
        long startTime = System.currentTimeMillis();
        cycle.run();
        long endTime = System.currentTimeMillis();
        out.println("Done (" + (endTime - startTime) + "ms)");
    }
}

