/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9PortLibraryPointer;
import com.ibm.j9ddr.vm24.structure.J9ZipCache;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=J9ZipCache.class)
public class J9ZipCachePointer
extends StructurePointer {
    public static final J9ZipCachePointer NULL = new J9ZipCachePointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9ZipCachePointer(long address) {
        super(address);
    }

    public static J9ZipCachePointer cast(AbstractPointer structure) {
        return J9ZipCachePointer.cast(structure.getAddress());
    }

    public static J9ZipCachePointer cast(UDATA udata) {
        return J9ZipCachePointer.cast(udata.longValue());
    }

    public static J9ZipCachePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ZipCachePointer(address);
    }

    public J9ZipCachePointer add(long count) {
        return J9ZipCachePointer.cast(this.address + J9ZipCache.SIZEOF * count);
    }

    public J9ZipCachePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9ZipCachePointer addOffset(long offset) {
        return J9ZipCachePointer.cast(this.address + offset);
    }

    public J9ZipCachePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9ZipCachePointer sub(long count) {
        return J9ZipCachePointer.cast(this.address - J9ZipCache.SIZEOF * count);
    }

    public J9ZipCachePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9ZipCachePointer subOffset(long offset) {
        return J9ZipCachePointer.cast(this.address - offset);
    }

    public J9ZipCachePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9ZipCachePointer untag(long mask) {
        return J9ZipCachePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9ZipCachePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9ZipCache.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_cachePoolOffset_", declaredType="void*")
    public VoidPointer cachePool() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9ZipCache._cachePoolOffset_));
    }

    public PointerPointer cachePoolEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9ZipCache._cachePoolOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_cachePoolEntryOffset_", declaredType="void*")
    public VoidPointer cachePoolEntry() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9ZipCache._cachePoolEntryOffset_));
    }

    public PointerPointer cachePoolEntryEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9ZipCache._cachePoolEntryOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_portLibOffset_", declaredType="struct J9PortLibrary*")
    public J9PortLibraryPointer portLib() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9ZipCache._portLibOffset_);
        return J9PortLibraryPointer.cast(pointer);
    }

    public PointerPointer portLibEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9ZipCache._portLibOffset_);
    }
}

