/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.ObjectModel;
import com.ibm.j9ddr.vm24.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm24.j9.gc.GCScavengerForwardedHeader;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.MM_ScavengerForwardedHeader;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;

class GCScavengerForwardedHeader_V1
extends GCScavengerForwardedHeader {
    private static final int ALL_TAGS = (int)MM_ScavengerForwardedHeader.FORWARDED_TAG;

    protected GCScavengerForwardedHeader_V1(J9ObjectPointer object) {
        super(object);
    }

    public J9ObjectPointer getForwardedObject() throws CorruptDataException {
        if (this.isForwardedPointer()) {
            return this.getForwardedObjectNoCheck();
        }
        return J9ObjectPointer.NULL;
    }

    protected J9ObjectPointer getForwardedObjectNoCheck() throws CorruptDataException {
        if (J9BuildFlags.interp_compressedObjectHeader && !J9BuildFlags.env_littleEndian) {
            U32 low = U32Pointer.cast(this.objectPointer.clazzEA()).at(0L).bitAnd(~ALL_TAGS);
            U32 high = U32Pointer.cast(this.objectPointer.clazzEA()).at(1L);
            J9ObjectPointer forwardedObject = J9ObjectPointer.cast(new UDATA(low).bitOr(new UDATA(high).leftShift(32)));
            return forwardedObject;
        }
        J9ObjectPointer forwardedObject = J9ObjectPointer.cast(UDATAPointer.cast(this.objectPointer.clazzEA()).at(0L));
        return forwardedObject.untag(ALL_TAGS);
    }

    public J9ObjectPointer getReverseForwardedPointer() throws CorruptDataException {
        GCHeapLinkedFreeHeader next = GCHeapLinkedFreeHeader.fromJ9Object(this.objectPointer).getNext();
        return next.getObject();
    }

    public boolean isForwardedPointer() throws CorruptDataException {
        return this.objectPointer.clazz().allBitsIn(MM_ScavengerForwardedHeader.FORWARDED_TAG);
    }

    public boolean isReverseForwardedPointer() throws CorruptDataException {
        UDATA flagBits = UDATA.cast(this.objectPointer.clazz());
        return flagBits.bitAnd(J9Consts.J9_GC_OBJ_HEAP_HOLE_MASK).eq(J9Consts.J9_GC_MULTI_SLOT_HOLE);
    }

    public UDATA getObjectSize() throws CorruptDataException {
        J9ObjectPointer forwardedObject = this.getForwardedObjectNoCheck();
        return ObjectModel.getConsumedSizeInBytesWithHeader(forwardedObject);
    }
}

