/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCIterator;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.ArrayList;
import java.util.Iterator;

public class GCClassStaticsIterator
extends GCIterator {
    Iterator<J9ObjectPointer> slotsIterator;
    Iterator<VoidPointer> addressIterator;

    protected GCClassStaticsIterator(J9ClassPointer clazz) throws CorruptDataException {
        ArrayList<J9ObjectPointer> statics = new ArrayList<J9ObjectPointer>();
        ArrayList<VoidPointer> addresses = new ArrayList<VoidPointer>();
        long objectStaticCount = clazz.romClass().objectStaticCount().longValue();
        UDATAPointer staticPtr = clazz.ramStatics();
        if (staticPtr.isNull()) {
            objectStaticCount = 0L;
        }
        while (objectStaticCount > 0L) {
            UDATA slot = staticPtr.at(0L);
            if (!slot.eq(0L)) {
                statics.add(J9ObjectPointer.cast(slot));
                addresses.add(VoidPointer.cast(staticPtr));
            }
            staticPtr = staticPtr.add(1L);
            --objectStaticCount;
        }
        this.slotsIterator = statics.iterator();
        this.addressIterator = addresses.iterator();
    }

    public static GCClassStaticsIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassStaticsIterator(clazz);
    }

    public boolean hasNext() {
        return this.slotsIterator.hasNext();
    }

    public J9ObjectPointer next() {
        this.addressIterator.next();
        return this.slotsIterator.next();
    }

    public VoidPointer nextAddress() {
        this.slotsIterator.next();
        return this.addressIterator.next();
    }
}

