/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.gc.GCClassHeapIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCDebuggerClassReferenceIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCDebuggerReferenceIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCFinalizableListIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCFinalizableListSlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCJNIGlobalReferenceIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCJNIWeakGlobalReferenceIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCJVMTIObjectTagTableIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCJVMTIObjectTagTableListIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCMonitorReferenceIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCPhantomReferenceObjectListIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCReferenceObjectListSlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCRememberedSetIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCRememberedSetSlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCSoftReferenceObjectListIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCStringTableIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCUnfinalizedListIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCUnfinalizedListSlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCVMClassSlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCVMThreadJNISlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCVMThreadMonitorRecordSlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCVMThreadSlotIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCWeakReferenceObjectListIterator;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.GC_FinalizeListPointer;
import com.ibm.j9ddr.vm24.pointer.generated.GC_FinalizerJobPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9DebuggerReferencePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JVMTIDataPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JVMTIEnvPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm24.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm24.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm24.pointer.helper.MM_GCExtensionsHelper;
import com.ibm.j9ddr.vm24.structure.J9MemorySegment;
import com.ibm.j9ddr.vm24.structure.MM_GCExtensionsCore;

public abstract class RootScanner {
    private Reachability _reachability = Reachability.STRONG;
    private static J9JavaVMPointer vm;
    private static MM_GCExtensionsPointer extensions;

    public static J9JavaVMPointer getJavaVM() throws CorruptDataException {
        if (vm == null) {
            vm = DataType.getJ9RASPointer().getVM();
        }
        return vm;
    }

    public static MM_GCExtensionsPointer getExtensions() throws CorruptDataException {
        if (extensions == null) {
            extensions = MM_GCExtensionsHelper.fromJ9JavaVM(RootScanner.getJavaVM());
        }
        return extensions;
    }

    protected abstract void doClassSlot(J9ClassPointer var1);

    protected abstract void doClass(J9ClassPointer var1);

    protected abstract void doClassLoader(J9ClassLoaderPointer var1);

    protected abstract void doWeakReferenceSlot(J9ObjectPointer var1);

    protected abstract void doSoftReferenceSlot(J9ObjectPointer var1);

    protected abstract void doPhantomReferenceSlot(J9ObjectPointer var1);

    protected abstract void doFinalizableSlot(GC_FinalizerJobPointer var1);

    protected abstract void doUnfinalizedSlot(J9ObjectPointer var1);

    protected abstract void doDebuggerReference(J9DebuggerReferencePointer var1);

    protected abstract void doDebuggerClassReference(J9DebuggerReferencePointer var1);

    protected abstract void doMonitorReference(J9ObjectMonitorPointer var1);

    protected abstract void doJNIWeakGlobalReference(J9ObjectPointer var1);

    protected abstract void doJNIGlobalReferenceSlot(J9ObjectPointer var1);

    protected abstract void doRememberedSlot(J9ObjectPointer var1);

    protected abstract void doJVMTIObjectTagSlot(J9ObjectPointer var1);

    protected abstract void doStringTableSlot(J9ObjectPointer var1);

    protected abstract void doStringCacheTableSlot(J9ObjectPointer var1);

    protected abstract void doVMClassSlot(J9ClassPointer var1);

    protected abstract void doVMThreadSlot(J9ObjectPointer var1);

    protected abstract void doVMThreadJNISlot(J9ObjectPointer var1);

    protected abstract void doVMThreadMonitorRecordSlot(J9ObjectPointer var1);

    protected void doClassSlot(J9ClassPointer slot, VoidPointer address) {
        this.doClassSlot(slot);
    }

    protected void doClass(J9ClassPointer clazz, VoidPointer address) {
        this.doClass(clazz);
    }

    protected void doClassLoader(J9ClassLoaderPointer slot, VoidPointer address) {
        this.doClassLoader(slot);
    }

    protected void doWeakReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doWeakReferenceSlot(slot);
    }

    protected void doSoftReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doSoftReferenceSlot(slot);
    }

    protected void doPhantomReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doPhantomReferenceSlot(slot);
    }

    protected void doFinalizableSlot(GC_FinalizerJobPointer slot, VoidPointer address) {
        this.doFinalizableSlot(slot);
    }

    protected void doUnfinalizedSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doUnfinalizedSlot(slot);
    }

    protected void doMonitorReference(J9ObjectMonitorPointer objectMonitor, VoidPointer address) {
        this.doMonitorReference(objectMonitor);
    }

    protected void doJNIWeakGlobalReference(J9ObjectPointer slot, VoidPointer address) {
        this.doJNIWeakGlobalReference(slot);
    }

    protected void doJNIGlobalReferenceSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doJNIGlobalReferenceSlot(slot);
    }

    protected void doRememberedSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doRememberedSlot(slot);
    }

    protected void doJVMTIObjectTagSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doJVMTIObjectTagSlot(slot);
    }

    protected void doStringTableSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doStringTableSlot(slot);
    }

    protected void doStringCacheTableSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doStringCacheTableSlot(slot);
    }

    protected void doVMClassSlot(J9ClassPointer slot, VoidPointer address) {
        this.doVMClassSlot(slot);
    }

    protected void doVMThreadSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doVMThreadSlot(slot);
    }

    protected void doVMThreadJNISlot(J9ObjectPointer slot, VoidPointer address) {
        this.doVMThreadJNISlot(slot);
    }

    protected void doVMThreadMonitorRecordSlot(J9ObjectPointer slot, VoidPointer address) {
        this.doVMThreadMonitorRecordSlot(slot);
    }

    public void scanAllSlots() throws CorruptDataException {
        this.scanClasses();
        this.scanVMClassSlots();
        if (!J9BuildFlags.opt_noClassloaders) {
            this.scanClassLoaders();
        }
        this.scanThreads();
        if (J9BuildFlags.gc_finalization) {
            this.scanFinalizableObjects();
        }
        if (J9BuildFlags.interp_JNISupport || J9BuildFlags.interp_debugSupport) {
            this.scanJNIGlobalReferences();
        }
        this.scanStringTable();
        if (J9BuildFlags.gc_weakReferenceObjects) {
            this.scanWeakReferenceObjects();
        }
        if (J9BuildFlags.gc_referenceObjects) {
            this.scanSoftReferenceObjects();
            this.scanPhantomReferenceObjects();
        }
        if (J9BuildFlags.gc_finalization) {
            this.scanUnfinalizedObjects();
        }
        this.scanMonitorReferences();
        if (J9BuildFlags.interp_JNISupport) {
            this.scanJNIWeakGlobalReferences();
        }
        if (J9BuildFlags.interp_debugSupport) {
            this.scanDebuggerReferences();
            this.scanDebuggerClassReferences();
        }
        if (J9BuildFlags.gc_modronScavenger && !RootScanner.getExtensions().scavengerEnabled()) {
            this.scanRememberedSet();
        }
        if (J9BuildFlags.opt_jvmti) {
            this.scanJVMTIObjectTagTables();
        }
    }

    protected void scanJVMTIObjectTagTables() throws CorruptDataException {
        if (!J9BuildFlags.opt_jvmti) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        J9JVMTIDataPointer jvmtiData = J9JVMTIDataPointer.cast(RootScanner.getJavaVM().jvmtiData());
        if (jvmtiData.notNull()) {
            GCJVMTIObjectTagTableListIterator objectTagTableList = GCJVMTIObjectTagTableListIterator.fromJ9JVMTIData(jvmtiData);
            while (objectTagTableList.hasNext()) {
                J9JVMTIEnvPointer list = objectTagTableList.next();
                GCJVMTIObjectTagTableIterator objectTagTableIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(list);
                GCJVMTIObjectTagTableIterator addressIterator = GCJVMTIObjectTagTableIterator.fromJ9JVMTIEnv(list);
                while (objectTagTableIterator.hasNext()) {
                    this.doJVMTIObjectTagSlot(objectTagTableIterator.next(), addressIterator.nextAddress());
                }
            }
        }
    }

    protected void scanRememberedSet() throws CorruptDataException {
        if (!J9BuildFlags.gc_modronScavenger) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCRememberedSetIterator rememberedSetIterator = GCRememberedSetIterator.from();
        while (rememberedSetIterator.hasNext()) {
            MM_SublistPuddlePointer puddle = rememberedSetIterator.next();
            GCRememberedSetSlotIterator rememberedSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(puddle);
            GCRememberedSetSlotIterator addressIterator = GCRememberedSetSlotIterator.fromSublistPuddle(puddle);
            while (rememberedSetSlotIterator.hasNext()) {
                this.doRememberedSlot(rememberedSetSlotIterator.next(), addressIterator.nextAddress());
            }
        }
    }

    protected void scanDebuggerClassReferences() throws CorruptDataException {
        if (!J9BuildFlags.interp_debugSupport) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCDebuggerClassReferenceIterator debuggerClassReferenceIterator = GCDebuggerClassReferenceIterator.fromJ9JavaVM(RootScanner.getJavaVM());
        while (debuggerClassReferenceIterator.hasNext()) {
            this.doDebuggerClassReference(debuggerClassReferenceIterator.next());
        }
    }

    protected void scanDebuggerReferences() throws CorruptDataException {
        if (!J9BuildFlags.interp_debugSupport) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCDebuggerReferenceIterator debuggerReferenceIterator = GCDebuggerReferenceIterator.fromJ9JavaVM(RootScanner.getJavaVM());
        while (debuggerReferenceIterator.hasNext()) {
            this.doDebuggerReference(debuggerReferenceIterator.next());
        }
    }

    protected void scanJNIWeakGlobalReferences() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCJNIWeakGlobalReferenceIterator jniWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.from();
        GCJNIWeakGlobalReferenceIterator addressIterator = GCJNIWeakGlobalReferenceIterator.from();
        while (jniWeakGlobalReferenceIterator.hasNext()) {
            this.doJNIWeakGlobalReference(jniWeakGlobalReferenceIterator.next(), addressIterator.nextAddress());
        }
    }

    protected void scanMonitorReferences() throws CorruptDataException {
        this.setReachability(Reachability.WEAK);
        GCMonitorReferenceIterator monitorReferenceIterator = GCMonitorReferenceIterator.from();
        while (monitorReferenceIterator.hasNext()) {
            this.doMonitorReference(monitorReferenceIterator.next());
        }
    }

    protected void scanUnfinalizedObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_finalization) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCUnfinalizedListIterator unfinalizedListIterator = GCUnfinalizedListIterator.from();
        while (unfinalizedListIterator.hasNext()) {
            MM_SublistPuddlePointer puddle = unfinalizedListIterator.next();
            GCUnfinalizedListSlotIterator unfinalizedListSlotIterator = GCUnfinalizedListSlotIterator.fromSublistPuddle(puddle);
            GCUnfinalizedListSlotIterator addressIterator = GCUnfinalizedListSlotIterator.fromSublistPuddle(puddle);
            while (unfinalizedListSlotIterator.hasNext()) {
                this.doUnfinalizedSlot(unfinalizedListSlotIterator.next(), addressIterator.nextAddress());
            }
        }
    }

    protected void scanPhantomReferenceObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_referenceObjects) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCPhantomReferenceObjectListIterator referenceObjectListIterator = GCPhantomReferenceObjectListIterator.from();
        while (referenceObjectListIterator.hasNext()) {
            MM_SublistPuddlePointer puddle = referenceObjectListIterator.next();
            GCReferenceObjectListSlotIterator referenceObjectListSlotIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(puddle);
            GCReferenceObjectListSlotIterator addressIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(puddle);
            while (referenceObjectListSlotIterator.hasNext()) {
                this.doPhantomReferenceSlot(referenceObjectListSlotIterator.next(), addressIterator.nextAddress());
            }
        }
    }

    protected void scanSoftReferenceObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_referenceObjects) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCSoftReferenceObjectListIterator referenceObjectListIterator = GCSoftReferenceObjectListIterator.from();
        while (referenceObjectListIterator.hasNext()) {
            MM_SublistPuddlePointer puddle = referenceObjectListIterator.next();
            GCReferenceObjectListSlotIterator referenceObjectListSlotIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(puddle);
            GCReferenceObjectListSlotIterator addressIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(puddle);
            while (referenceObjectListSlotIterator.hasNext()) {
                this.doSoftReferenceSlot(referenceObjectListSlotIterator.next(), addressIterator.nextAddress());
            }
        }
    }

    protected void scanWeakReferenceObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_weakReferenceObjects) {
            return;
        }
        this.setReachability(Reachability.WEAK);
        GCWeakReferenceObjectListIterator referenceObjectListIterator = GCWeakReferenceObjectListIterator.from();
        while (referenceObjectListIterator.hasNext()) {
            MM_SublistPuddlePointer puddle = referenceObjectListIterator.next();
            GCReferenceObjectListSlotIterator referenceObjectListSlotIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(puddle);
            GCReferenceObjectListSlotIterator addressIterator = GCReferenceObjectListSlotIterator.fromSublistPuddle(puddle);
            while (referenceObjectListSlotIterator.hasNext()) {
                this.doWeakReferenceSlot(referenceObjectListSlotIterator.next(), addressIterator.nextAddress());
            }
        }
    }

    protected void scanStringTable() throws CorruptDataException {
        if (RootScanner.getExtensions().collectStringConstants()) {
            this.setReachability(Reachability.WEAK);
        } else {
            this.setReachability(Reachability.STRONG);
        }
        GCStringTableIterator stringTableIterator = GCStringTableIterator.fromJ9JavaVM(RootScanner.getJavaVM());
        GCStringTableIterator stringTableAddressIterator = GCStringTableIterator.fromJ9JavaVM(RootScanner.getJavaVM());
        while (stringTableIterator.hasNext()) {
            this.doStringTableSlot(stringTableIterator.next(), stringTableAddressIterator.nextAddress());
        }
    }

    protected void scanJNIGlobalReferences() throws CorruptDataException {
        this.setReachability(Reachability.STRONG);
        GCJNIGlobalReferenceIterator jniGlobalReferenceIterator = GCJNIGlobalReferenceIterator.from();
        GCJNIGlobalReferenceIterator addressIterator = GCJNIGlobalReferenceIterator.from();
        while (jniGlobalReferenceIterator.hasNext()) {
            this.doJNIGlobalReferenceSlot(jniGlobalReferenceIterator.next(), addressIterator.nextAddress());
        }
    }

    protected void scanFinalizableObjects() throws CorruptDataException {
        if (!J9BuildFlags.gc_finalization) {
            return;
        }
        this.setReachability(Reachability.STRONG);
        GCFinalizableListIterator finalizableListIterator = GCFinalizableListIterator.from();
        while (finalizableListIterator.hasNext()) {
            GC_FinalizeListPointer list = finalizableListIterator.next();
            GCFinalizableListSlotIterator finalizableListSlotIterator = GCFinalizableListSlotIterator.fromFinalizeList(list);
            while (finalizableListSlotIterator.hasNext()) {
                this.doFinalizableSlot(finalizableListSlotIterator.next());
            }
        }
    }

    protected void scanThreads() throws CorruptDataException {
        this.setReachability(Reachability.STRONG);
        GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.from();
        while (vmThreadListIterator.hasNext()) {
            J9VMThreadPointer walkThread = vmThreadListIterator.next();
            GCVMThreadSlotIterator threadSlotIterator = GCVMThreadSlotIterator.fromJ9VMThread(walkThread);
            GCVMThreadSlotIterator threadSlotAddressIterator = GCVMThreadSlotIterator.fromJ9VMThread(walkThread);
            while (threadSlotIterator.hasNext()) {
                this.doVMThreadSlot(threadSlotIterator.next(), threadSlotAddressIterator.nextAddress());
            }
            GCVMThreadJNISlotIterator jniSlotIterator = GCVMThreadJNISlotIterator.fromJ9VMThread(walkThread);
            GCVMThreadJNISlotIterator jniSlotAddressIterator = GCVMThreadJNISlotIterator.fromJ9VMThread(walkThread);
            while (jniSlotIterator.hasNext()) {
                this.doVMThreadJNISlot(jniSlotIterator.next(), jniSlotAddressIterator.nextAddress());
            }
            if (!J9BuildFlags.interp_hotCodeReplacement) continue;
            GCVMThreadMonitorRecordSlotIterator monitorRecordSlotIterator = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(walkThread);
            GCVMThreadMonitorRecordSlotIterator addressIterator = GCVMThreadMonitorRecordSlotIterator.fromJ9VMThread(walkThread);
            while (monitorRecordSlotIterator.hasNext()) {
                this.doVMThreadMonitorRecordSlot(monitorRecordSlotIterator.next(), addressIterator.nextAddress());
            }
        }
    }

    protected void scanClassLoaders() throws CorruptDataException {
        J9ClassLoaderPointer sysClassLoader = RootScanner.getJavaVM().systemClassLoader();
        J9ClassLoaderPointer appClassLoader = J9ClassLoaderPointer.cast(RootScanner.getJavaVM().applicationClassLoader());
        long dynamicClassUnloadingFlag = RootScanner.getExtensions().dynamicClassUnloading();
        GCClassLoaderIterator classLoaderIterator = GCClassLoaderIterator.from();
        while (classLoaderIterator.hasNext()) {
            J9ClassLoaderPointer loader = classLoaderIterator.next();
            Reachability reachability = J9BuildFlags.gc_dynamicClassUnloading ? (MM_GCExtensionsCore.DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == dynamicClassUnloadingFlag ? Reachability.STRONG : (loader.eq(sysClassLoader) || loader.eq(appClassLoader) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
            this.setReachability(reachability);
            this.doClassLoader(loader);
        }
    }

    protected void scanVMClassSlots() throws CorruptDataException {
        GCVMClassSlotIterator classSlotIterator = GCVMClassSlotIterator.from();
        GCVMClassSlotIterator addressIterator = GCVMClassSlotIterator.from();
        this.setReachability(Reachability.STRONG);
        while (classSlotIterator.hasNext()) {
            this.doVMClassSlot(classSlotIterator.next(), addressIterator.nextAddress());
        }
    }

    protected void scanClasses() throws CorruptDataException {
        J9ClassLoaderPointer sysClassLoader = RootScanner.getJavaVM().systemClassLoader();
        J9ClassLoaderPointer appClassLoader = J9ClassLoaderPointer.cast(RootScanner.getJavaVM().applicationClassLoader());
        long dynamicClassUnloadingFlag = RootScanner.getExtensions().dynamicClassUnloading();
        GCSegmentIterator segmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(RootScanner.getJavaVM().classMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM_CLASS);
        while (segmentIterator.hasNext()) {
            J9MemorySegmentPointer segment = segmentIterator.next();
            if (!this.shouldScanClassSegment(segment)) continue;
            GCClassHeapIterator classHeapIterator = GCClassHeapIterator.fromJ9MemorySegment(segment);
            while (classHeapIterator.hasNext()) {
                J9ClassPointer clazz = classHeapIterator.next();
                Reachability reachability = J9BuildFlags.gc_dynamicClassUnloading ? (MM_GCExtensionsCore.DynamicClassUnloading.DYNAMIC_CLASS_UNLOADING_NEVER == dynamicClassUnloadingFlag ? Reachability.STRONG : (clazz.classLoader().eq(sysClassLoader) || clazz.classLoader().eq(appClassLoader) ? Reachability.STRONG : Reachability.WEAK)) : Reachability.STRONG;
                this.setReachability(reachability);
                this.doClass(clazz);
            }
        }
    }

    private void setReachability(Reachability r) {
        this._reachability = r;
    }

    protected Reachability getReachability() {
        return this._reachability;
    }

    protected boolean shouldScanClassSegment(J9MemorySegmentPointer segment) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reachability {
        STRONG,
        WEAK;

    }
}

