/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.tools.ddrinteractive.commands;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;

public class BuildFlagsCommand
extends Command {
    public BuildFlagsCommand() {
        this.addCommand("buildflags", "[regex]", "Prints all or matching buildflags and their values.");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        Pattern pattern = null;
        try {
            if (0 == args.length) {
                pattern = null;
            } else if (args.length >= 1) {
                String regex = args[0];
                pattern = Pattern.compile(regex);
                pattern = Pattern.compile("(?i).*(" + regex + ").*");
            }
            Field[] fields = J9BuildFlags.class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Boolean.TYPE) continue;
                String fieldName = field.getName();
                if (null != pattern) {
                    if (!pattern.matcher(fieldName).matches()) continue;
                    out.println(fieldName + " = " + field.getBoolean(null));
                    continue;
                }
                out.println(fieldName + " = " + field.getBoolean(null));
            }
        }
        catch (Exception e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

