/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.StructurePointer;
import com.ibm.j9ddr.vm23.pointer.U64Pointer;
import com.ibm.j9ddr.vm23.structure.CollectionCounts;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.U64;
import com.ibm.j9ddr.vm23.types.UDATA;

@GeneratedPointerClass(structureClass=CollectionCounts.class)
public class CollectionCountsPointer
extends StructurePointer {
    public static final CollectionCountsPointer NULL = new CollectionCountsPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected CollectionCountsPointer(long address) {
        super(address);
    }

    public static CollectionCountsPointer cast(AbstractPointer structure) {
        return CollectionCountsPointer.cast(structure.getAddress());
    }

    public static CollectionCountsPointer cast(UDATA udata) {
        return CollectionCountsPointer.cast(udata.longValue());
    }

    public static CollectionCountsPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new CollectionCountsPointer(address);
    }

    public CollectionCountsPointer add(long count) {
        return CollectionCountsPointer.cast(this.address + CollectionCounts.SIZEOF * count);
    }

    public CollectionCountsPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public CollectionCountsPointer addOffset(long offset) {
        return CollectionCountsPointer.cast(this.address + offset);
    }

    public CollectionCountsPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public CollectionCountsPointer sub(long count) {
        return CollectionCountsPointer.cast(this.address - CollectionCounts.SIZEOF * count);
    }

    public CollectionCountsPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public CollectionCountsPointer subOffset(long offset) {
        return CollectionCountsPointer.cast(this.address - offset);
    }

    public CollectionCountsPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public CollectionCountsPointer untag(long mask) {
        return CollectionCountsPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public CollectionCountsPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return CollectionCounts.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_concurrentGCOffset_", declaredType="U64")
    public U64 concurrentGC() throws CorruptDataException {
        return new U64(this.getLongAtOffset(CollectionCounts._concurrentGCOffset_));
    }

    public U64Pointer concurrentGCEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U64Pointer.cast(this.address + (long)CollectionCounts._concurrentGCOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nurseryAFOffset_", declaredType="U64")
    public U64 nurseryAF() throws CorruptDataException {
        return new U64(this.getLongAtOffset(CollectionCounts._nurseryAFOffset_));
    }

    public U64Pointer nurseryAFEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U64Pointer.cast(this.address + (long)CollectionCounts._nurseryAFOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_systemGCOffset_", declaredType="U64")
    public U64 systemGC() throws CorruptDataException {
        return new U64(this.getLongAtOffset(CollectionCounts._systemGCOffset_));
    }

    public U64Pointer systemGCEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U64Pointer.cast(this.address + (long)CollectionCounts._systemGCOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_tenureAFOffset_", declaredType="U64")
    public U64 tenureAF() throws CorruptDataException {
        return new U64(this.getLongAtOffset(CollectionCounts._tenureAFOffset_));
    }

    public U64Pointer tenureAFEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U64Pointer.cast(this.address + (long)CollectionCounts._tenureAFOffset_);
    }
}

