/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.Pointer;
import com.ibm.j9ddr.vm23.types.Scalar;
import com.ibm.j9ddr.vm23.types.UDATA;

public class BoolPointer
extends Pointer {
    public static final int SIZEOF = DataType.SIZEOF_BOOL;
    public static final BoolPointer NULL = new BoolPointer(0L);

    protected BoolPointer(long address) {
        super(address);
    }

    public static BoolPointer cast(AbstractPointer pointer) {
        return BoolPointer.cast(pointer.getAddress());
    }

    public static BoolPointer cast(UDATA udata) {
        return BoolPointer.cast(udata.longValue());
    }

    public static BoolPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new BoolPointer(address);
    }

    public boolean boolAt(long index) throws CorruptDataException {
        return this.getBoolAtOffset((long)SIZEOF * index);
    }

    public BoolPointer at(long index) throws CorruptDataException {
        throw new UnsupportedOperationException("Use boolAt(long index)");
    }

    public BoolPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public BoolPointer add(long count) {
        return new BoolPointer(this.address + (long)SIZEOF * count);
    }

    public BoolPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public BoolPointer addOffset(long offset) {
        return new BoolPointer(this.address + offset);
    }

    public BoolPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public BoolPointer sub(long count) {
        return new BoolPointer(this.address - (long)SIZEOF * count);
    }

    public BoolPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public BoolPointer subOffset(long offset) {
        return new BoolPointer(this.address - offset);
    }

    public BoolPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public BoolPointer untag() {
        throw new UnsupportedOperationException("Use BoolPointer.untag(long mask) insetead");
    }

    public BoolPointer untag(long mask) {
        return new BoolPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    protected long sizeOfBaseType() {
        return SIZEOF;
    }
}

