/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.Pool;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9PoolPointer;
import java.util.Iterator;

public class GCJNIGlobalReferenceIterator
extends GCIterator {
    protected Iterator<PointerPointer> iterator;

    protected GCJNIGlobalReferenceIterator(J9PoolPointer globalRefs) throws CorruptDataException {
        this.iterator = Pool.fromJ9Pool(globalRefs, PointerPointer.class).iterator();
    }

    public static GCJNIGlobalReferenceIterator fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        return new GCJNIGlobalReferenceIterator(vm.jniGlobalReferences());
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public J9ObjectPointer next() {
        try {
            PointerPointer next = this.iterator.next();
            return J9ObjectPointer.cast(next.at(0L));
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }
}

