/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.DataType;
import com.ibm.j9ddr.vm23.j9.HashTable;
import com.ibm.j9ddr.vm23.j9.Pool;
import com.ibm.j9ddr.vm23.pointer.AbstractPointer;
import com.ibm.j9ddr.vm23.pointer.PointerPointer;
import com.ibm.j9ddr.vm23.pointer.VoidPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashTable_V1<StructType extends AbstractPointer>
extends HashTable<StructType> {
    protected <T extends AbstractPointer> HashTable_V1(J9HashTablePointer structure, Class<T> structType, HashTable.HashEqualFunction<T> equalFn, HashTable.HashFunction<T> hashFn) throws CorruptDataException {
        super(structure, structType, equalFn, hashFn, null);
    }

    @Override
    public long getCount() {
        try {
            return this._table.numberOfNodes().longValue();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting table count", e, true);
            return 0L;
        }
    }

    @Override
    public String getTableName() {
        try {
            return this._table.tableName().getCStringAtOffset(0L);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting name", e, true);
            return null;
        }
    }

    @Override
    public StructType find(StructType entry) {
        try {
            int hash = this._hashFn.hash(entry).intValue() % this._table.tableSize().intValue();
            VoidPointer nodePointer = this._table.nodes().at(hash);
            AbstractPointer node = (AbstractPointer)DataType.getStructure(this._structType.getSimpleName(), nodePointer.getAddress());
            while (node.notNull() && !this._equalFn.equal(node, entry)) {
                nodePointer.addOffset(this._table.nodeSize().longValue() - (long)UDATA.SIZEOF);
                node = (AbstractPointer)DataType.getStructure(this._structType.getSimpleName(), nodePointer.getAddress());
            }
            return (StructType)node;
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error finding type", cde, true);
            return null;
        }
    }

    @Override
    public Iterator<StructType> iterator() {
        return new Iterator<StructType>(){
            boolean EOI = false;
            Iterator<PointerPointer> poolIterator;
            {
                try {
                    this.poolIterator = Pool.fromJ9Pool(HashTable_V1.this._table.nodePool(), PointerPointer.class).iterator();
                    this.EOI = !this.poolIterator.hasNext();
                }
                catch (CorruptDataException cde) {
                    this.EOI = true;
                    EventManager.raiseCorruptDataEvent("Error getting iterator", cde, true);
                }
            }

            @Override
            public boolean hasNext() {
                return !this.EOI;
            }

            @Override
            public StructType next() {
                if (this.hasNext()) {
                    PointerPointer pool = this.poolIterator.next();
                    this.EOI = !this.poolIterator.hasNext();
                    return (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType.getSimpleName(), pool.getAddress());
                }
                throw new NoSuchElementException("There are no more available elements");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The J9HashTable is read only and cannot be modified.");
            }
        };
    }
}

