/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.view.dtfj.image.J9DDRBaseImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageRegister;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageStackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9DDRImageThread
extends J9DDRBaseImageThread
implements ImageThread {
    private final IOSThread thread;
    private long overriddenThreadId;
    private boolean threadIdOverridden;

    public J9DDRImageThread(IProcess process, IOSThread thread) {
        super(process);
        this.thread = thread;
        this.threadIdOverridden = false;
    }

    public J9DDRImageThread(IProcess process, IOSThread thread, long threadId) {
        this(process, thread);
        this.threadIdOverridden = true;
        this.overriddenThreadId = threadId;
    }

    @Override
    public long getThreadId() throws CorruptDataException {
        if (this.threadIdOverridden) {
            return this.overriddenThreadId;
        }
        return this.thread.getThreadId();
    }

    public Properties getProperties() {
        return this.thread.getProperties();
    }

    public Iterator<?> getRegisters() {
        Collection<? extends IRegister> registers = this.thread.getRegisters();
        ArrayList<J9DDRImageRegister> dtfjRegisters = new ArrayList<J9DDRImageRegister>(registers.size());
        for (IRegister iRegister : registers) {
            dtfjRegisters.add(new J9DDRImageRegister(iRegister));
        }
        return dtfjRegisters.iterator();
    }

    public Iterator<?> getStackFrames() throws DataUnavailable {
        List<? extends IOSStackFrame> frames = this.thread.getStackFrames();
        ArrayList<J9DDRImageStackFrame> dtfjFrames = new ArrayList<J9DDRImageStackFrame>(frames.size());
        for (IOSStackFrame iOSStackFrame : frames) {
            dtfjFrames.add(new J9DDRImageStackFrame(this.process, iOSStackFrame, this));
        }
        return dtfjFrames.iterator();
    }

    public Iterator<?> getStackSections() {
        Collection<? extends IMemoryRange> ranges = this.thread.getMemoryRanges();
        ArrayList<J9DDRImageSection> sections = new ArrayList<J9DDRImageSection>(ranges.size());
        for (IMemoryRange iMemoryRange : ranges) {
            sections.add(new J9DDRImageSection(this.process, iMemoryRange.getBaseAddress(), iMemoryRange.getSize(), "stack section at " + Long.toHexString(iMemoryRange.getBaseAddress())));
        }
        return sections.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.thread == null ? 0 : this.thread.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof J9DDRImageThread)) {
            return false;
        }
        J9DDRImageThread other = (J9DDRImageThread)obj;
        return !(this.thread == null ? other.thread != null : !this.thread.equals(other.thread));
    }

    public String toString() {
        StringBuilder data = new StringBuilder();
        data.append("ImageThread 0x");
        try {
            data.append(Long.toHexString(this.thread.getThreadId()));
        }
        catch (CorruptDataException e) {
            data.append("[corrupt ID]");
        }
        return data.toString();
    }
}

