/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.EnvironmentUtils;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageModule;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRStubImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9DDRImageProcess
implements ImageProcess {
    private static final String JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "IBM_JAVA_COMMAND_LINE";
    private final IProcess process;
    private boolean processDataSet = false;
    private J9RASImageDataFactory.ProcessData j9rasProcessData;
    private String version;
    private static final int J9PORT_SIG_FLAG_SIGSEGV = 4;
    private static final int J9PORT_SIG_FLAG_SIGBUS = 8;
    private static final int J9PORT_SIG_FLAG_SIGILL = 16;
    private static final int J9PORT_SIG_FLAG_SIGFPE = 32;
    private static final int J9PORT_SIG_FLAG_SIGTRAP = 64;
    private static final int J9PORT_SIG_FLAG_SIGQUIT = 1024;
    private static final int J9PORT_SIG_FLAG_SIGABRT = 2048;
    private static final int J9PORT_SIG_FLAG_SIGTERM = 4096;
    private static final int J9PORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO = 262176;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO = 524320;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_OVERFLOW = 0x100020;
    private static final String[] SIGNAL_NAMES = new String[]{"ZERO", "SIGHUP", "SIGINT", "SIGQUIT", "SIGILL", "SIGTRAP", "SIGABRT", "SIGEMT", "SIGFPE", "SIGKILL", "SIGBUS", "SIGSEGV", "SIGSYS", "SIGPIPE", "SIGALRM", "SIGTERM", "SIGUSR1", "SIGUSR2", "SIGCHLD", "SIGPWR", "SIGWINCH", "SIGURG/BREAK", "SIGPOLL/ABRT", "SIGSTOP", "SIGTSTP", "SIGCONT", "SIGTTIN", "SIGTTOU", "SIGVTALRM", "SIGPROF", "SIGXCPU", "SIGXFSZ", "SIGWAITING", "SIGLWP", "SIGAIO", "SIGFPE_DIV_BY_ZERO", "SIGFPE_INT_DIV_BY_ZERO", "SIGFPE_INT_OVERFLOW"};

    public J9DDRImageProcess(IProcess thisProcess) {
        this.process = thisProcess;
    }

    public IProcess getIProcess() {
        return this.process;
    }

    public String getCommandLine() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Properties environment = this.getEnvironment();
            String javaCommandLine = environment.getProperty(JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
            if (javaCommandLine != null) {
                return javaCommandLine;
            }
            return this.process.getCommandLine();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(this.process, e);
        }
        catch (DataUnavailableException e) {
            throw new DataUnavailable(e.getMessage());
        }
    }

    private void checkFailureInfo() {
        if (!this.processDataSet) {
            this.j9rasProcessData = J9RASImageDataFactory.getProcessData(this.process);
            this.processDataSet = true;
        }
    }

    public ImageThread getCurrentThread() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                long currentThreadId;
                try {
                    currentThreadId = this.j9rasProcessData.tid();
                }
                catch (DataUnavailable e) {
                    Iterator<? extends IOSThread> iterator = this.process.getThreads().iterator();
                    if (iterator.hasNext()) {
                        IOSThread thread = iterator.next();
                        return new J9DDRImageThread(this.process, thread);
                    }
                    return null;
                }
                for (IOSThread iOSThread : this.process.getThreads()) {
                    if (iOSThread.getThreadId() != currentThreadId) continue;
                    return new J9DDRImageThread(this.process, iOSThread);
                }
                if (currentThreadId == 0L && this.process.getPlatform() == Platform.ZOS) {
                    for (IOSThread iOSThread : this.process.getThreads()) {
                        Properties threadProps = iOSThread.getProperties();
                        String tcc = threadProps.getProperty("Task Completion Code");
                        if (tcc == null || tcc.equals("0x0")) continue;
                        return new J9DDRImageThread(this.process, iOSThread);
                    }
                }
                return new J9DDRStubImageThread(this.process, currentThreadId);
            }
            return null;
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(this.process, e);
        }
    }

    public Properties getEnvironment() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    long environ = this.j9rasProcessData.getEnvironment();
                    long stringPointer = this.process.getPointerAt(environ);
                    Properties properties = EnvironmentUtils.readEnvironment(this.process, stringPointer);
                    if (null == properties || 0 == properties.size()) {
                        throw new CorruptDataException("");
                    }
                    return properties;
                }
                catch (CorruptDataException e1) {
                    return this.process.getEnvironmentVariables();
                }
            }
            return this.process.getEnvironmentVariables();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(this.process, e);
        }
        catch (DataUnavailableException e) {
            throw new DataUnavailable(e.getMessage());
        }
    }

    public ImageModule getExecutable() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        IModule executable;
        try {
            executable = this.process.getExecutable();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, e));
        }
        if (executable == null) {
            throw new DataUnavailable("executable not found");
        }
        if (this.process.getPlatform() == Platform.LINUX) {
            String executableName = this.getExecutablePath();
            if (null == executableName) {
                return new J9DDRImageModule(this.process, executable);
            }
            return new J9DDRImageModule(this.process, executable, executableName);
        }
        return new J9DDRImageModule(this.process, executable);
    }

    String getExecutablePath() {
        String commandLine;
        try {
            commandLine = this.getCommandLine();
        }
        catch (Exception e) {
            return this.getExecutablePathFromSystemProperties();
        }
        int spaceIndex = commandLine.indexOf(" ");
        String executableName = null;
        executableName = spaceIndex != -1 ? commandLine.substring(0, spaceIndex) : commandLine;
        return executableName;
    }

    private String getExecutablePathFromSystemProperties() {
        Iterator<?> runtimeIt = this.getRuntimes();
        while (runtimeIt.hasNext()) {
            Object o = runtimeIt.next();
            if (!(o instanceof JavaRuntime)) continue;
            JavaRuntime runtime = (JavaRuntime)o;
            try {
                JavaVMInitArgs args = runtime.getJavaVMInitArgs();
                Iterator optionsIt = args.getOptions();
                Pattern javaHomePattern = Pattern.compile("-Djava.home=(.*)");
                while (optionsIt.hasNext()) {
                    JavaVMOption option;
                    Matcher m;
                    Object optionObj = optionsIt.next();
                    if (!(optionObj instanceof JavaVMOption) || !(m = javaHomePattern.matcher((option = (JavaVMOption)optionObj).getOptionString())).find()) continue;
                    String javaHome = m.group(1);
                    return javaHome + "/bin/java";
                }
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public String getID() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    return Long.toString(this.j9rasProcessData.pid());
                }
                catch (DataUnavailable e) {
                    return Long.toString(this.process.getProcessId());
                }
            }
            return Long.toString(this.process.getProcessId());
        }
        catch (CorruptDataException e) {
            return "<Unknown>";
        }
    }

    public String toString() {
        try {
            return "ImageProcess: " + this.getID();
        }
        catch (Exception ex) {
            return "ImageProcess";
        }
    }

    public Iterator<?> getLibraries() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Collection<? extends IModule> modules = this.process.getModules();
            ArrayList<J9DDRImageModule> libraries = new ArrayList<J9DDRImageModule>();
            for (IModule iModule : modules) {
                libraries.add(new J9DDRImageModule(this.process, iModule));
            }
            return libraries.iterator();
        }
        catch (CorruptDataException e) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, e));
        }
    }

    public int getPointerSize() {
        return this.process.bytesPerPointer() * 8;
    }

    public Iterator<?> getRuntimes() {
        LinkedList<Object> toIterate = new LinkedList<Object>();
        try {
            IVMData data = VMDataFactory.getVMData(this.process);
            this.version = data.getVersion();
            Object[] passbackArray = new Object[1];
            try {
                data.bootstrapRelative("view.dtfj.DTFJBootstrapShim", passbackArray, this);
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            if (passbackArray[0] != null) {
                toIterate.add(passbackArray[0]);
            }
        }
        catch (IOException e) {
            toIterate.add(new J9DDRCorruptData(this.process, "Unsupported JVM level: " + e.getMessage()));
        }
        catch (UnsupportedOperationException e) {
            toIterate.add(new J9DDRCorruptData(this.process, "Unsupported JVM level"));
        }
        catch (Exception e) {
            toIterate.add(new J9DDRCorruptData(this.process, e.getMessage()));
        }
        return toIterate.iterator();
    }

    public String getSignalName() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        int number = this.getSignalNumber();
        if (number == 0) {
            return null;
        }
        if (number > 0 && number < SIGNAL_NAMES.length) {
            return SIGNAL_NAMES[number];
        }
        return "Unknown signal number " + number;
    }

    public int getSignalNumber() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkFailureInfo();
        try {
            if (this.j9rasProcessData.gpInfo() != null) {
                int genericSignalNumber = (int)J9DDRImageProcess.longByResolvingRawKey(this.j9rasProcessData.gpInfo(), "J9Generic_Signal_Number");
                if (genericSignalNumber == 0) {
                    genericSignalNumber = (int)J9DDRImageProcess.longByResolvingRawKey(this.j9rasProcessData.gpInfo(), "J9Generic_Signal");
                }
                if (genericSignalNumber != 0) {
                    return this.resolveGenericSignal(genericSignalNumber);
                }
                return 0;
            }
        }
        catch (CorruptDataException e) {
            // empty catch block
        }
        try {
            return this.process.getSignalNumber();
        }
        catch (DataUnavailableException e) {
            return 0;
        }
    }

    public Iterator<?> getThreads() {
        Collection<? extends IOSThread> threads = null;
        try {
            threads = this.process.getThreads();
        }
        catch (CorruptDataException e) {
            return Collections.singletonList(new J9DDRCorruptData(this.process, e)).iterator();
        }
        boolean forkandabort = this.process.getPlatform() == Platform.LINUX && threads.size() == 1;
        ArrayList<Object> dtfjThreads = new ArrayList<Object>(threads.size() + 1);
        if (forkandabort) {
            try {
                dtfjThreads.add(this.getCurrentThread());
            }
            catch (com.ibm.dtfj.image.CorruptDataException e) {
                dtfjThreads.add(new J9DDRCorruptData(this.process, e.getMessage()));
            }
        }
        for (IOSThread iOSThread : threads) {
            dtfjThreads.add(new J9DDRImageThread(this.process, iOSThread));
        }
        return dtfjThreads.iterator();
    }

    private int resolveGenericSignal(int num) {
        if ((num & 0x400) != 0) {
            return 3;
        }
        if ((num & 0x10) != 0) {
            return 4;
        }
        if ((num & 0x40) != 0) {
            return 5;
        }
        if ((num & 0x800) != 0) {
            return 6;
        }
        if ((num & 0x20) != 0) {
            if (num == 262176) {
                return 35;
            }
            if (num == 524320) {
                return 36;
            }
            if (num == 0x100020) {
                return 37;
            }
            return 8;
        }
        if ((num & 8) != 0) {
            return 10;
        }
        if ((num & 4) != 0) {
            return 11;
        }
        if ((num & 0x1000) != 0) {
            return 15;
        }
        return num;
    }

    private static long longByResolvingRawKey(String rawText, String key) {
        int equalSign;
        long value = 0L;
        int index = rawText.indexOf(key);
        while (index > 0 && !Character.isWhitespace(rawText.charAt(index - 1))) {
            index = rawText.indexOf(key, index + 1);
        }
        if (index >= 0 && (equalSign = rawText.indexOf("=", index)) > index) {
            int exclusiveEnd;
            for (exclusiveEnd = equalSign + 1; exclusiveEnd < rawText.length() && !Character.isWhitespace(rawText.charAt(exclusiveEnd)); ++exclusiveEnd) {
            }
            String number = "0x" + rawText.substring(equalSign + 1, exclusiveEnd);
            value = J9DDRImageProcess.longFromString(number, 0L);
        }
        return value;
    }

    private static long longFromString(String value, long defaultValue) {
        long translated = defaultValue;
        int radix = 10;
        if (null != value) {
            if (value.startsWith("0x")) {
                value = value.substring(2);
                radix = 16;
                if (16 == value.length()) {
                    String highS = value.substring(0, 8);
                    String lowS = value.substring(8, 16);
                    long high = Long.parseLong(highS, radix);
                    long low = Long.parseLong(lowS, radix);
                    translated = high << 32 | low;
                } else {
                    translated = Long.parseLong(value, radix);
                }
            } else {
                translated = Long.parseLong(value, radix);
            }
        }
        return translated;
    }

    public String getVersion() {
        return this.version;
    }

    boolean isFailingProcess() throws DataUnavailableException {
        return this.process.isFailingProcess();
    }

    public Properties getProperties() {
        return new Properties();
    }
}

