/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ant.tasks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class ClassList
extends MatchingTask {
    private HashMap<String, Object> attribs = new HashMap();
    private static final String ATTRIB_DIR = "dir";
    private static final String ATTRIB_OUTPUT = "output";
    private static final String ATTRIB_FILE = "file";

    public ClassList() {
        this.attribs.put(ATTRIB_DIR, null);
        this.attribs.put(ATTRIB_OUTPUT, null);
        this.attribs.put(ATTRIB_FILE, null);
    }

    public void setDir(File dir) {
        this.attribs.put(ATTRIB_DIR, dir);
    }

    public void setOutput(String path) {
        this.attribs.put(ATTRIB_OUTPUT, path);
    }

    public void setFile(String name) {
        this.attribs.put(ATTRIB_FILE, name);
    }

    public void execute() throws BuildException {
        this.checkAttributes();
        this.createList();
    }

    private void createList() {
        boolean pathCreated;
        File path = new File((String)this.attribs.get(ATTRIB_OUTPUT));
        if (!path.exists() && !(pathCreated = path.mkdirs())) {
            throw new BuildException("The output path for the file list [" + path.getPath() + "] could not be found");
        }
        File dir = (File)this.attribs.get(ATTRIB_DIR);
        if (!dir.exists()) {
            throw new BuildException("The output path for the file list [" + dir.getPath() + "] could not be found");
        }
        File outputFile = new File(path, (String)this.attribs.get(ATTRIB_FILE));
        if (outputFile.exists()) {
            outputFile.delete();
        }
        FileWriter out = null;
        try {
            out = new FileWriter(outputFile);
            this.log("Created output file " + outputFile.getPath());
            DirectoryScanner ds = this.getDirectoryScanner(dir);
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String classname;
                int pos = files[i].lastIndexOf(File.separatorChar);
                if (pos == -1 || (pos = (classname = files[i].substring(pos + 1)).lastIndexOf(46)) == -1) continue;
                String data = classname.substring(0, pos);
                if ((pos = data.indexOf("Pointer")) != -1) {
                    String shortname = data.substring(0, pos);
                    out.write(shortname.toLowerCase() + "=" + shortname + "\n");
                } else {
                    out.write(data.toLowerCase() + "=" + data + "\n");
                }
                this.log("adding file: " + files[i]);
            }
            out.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.log("Could not close output file " + e.getMessage(), 0);
                }
            }
        }
    }

    private void checkAttributes() {
        for (String key : this.attribs.keySet()) {
            if (this.attribs.get(key) == null) {
                throw new BuildException(key + " attribute must be specified");
            }
            this.log(key + " = " + this.attribs.get(key), 4);
        }
    }
}

