/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.CodeGenerator;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointerGenerator
extends CodeGenerator {
    private static final String END_USER_CODE = "[END USER CODE]";
    private static final String BEGIN_USER_CODE = "[BEGIN USER CODE]";
    private static final String END_USER_IMPORTS = "[END USER IMPORTS]";
    private static final String BEGIN_USER_IMPORTS = "[BEGIN USER IMPORTS]";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final List<String> invalidMethodNames = Arrays.asList("assert", "abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized", "clone", "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait");
    File outputDirHelpers;
    private boolean cacheClass = false;
    private boolean cacheFields = false;
    private Properties cacheProperties = null;
    private StructureTypeManager typeManager;
    private static final List<String> omitList = Arrays.asList("v8__Ainternal__ACodeEntryPointer.builtin_id_", "v8__Ainternal__ACodeEntryPointer.tag_");

    public PointerGenerator() {
        this.opts.put("-p", null);
        this.opts.put("-o", null);
        this.opts.put("-f", null);
        this.opts.put("-v", null);
        this.opts.put("-s", null);
        this.opts.put("-h", null);
        this.opts.put("-u", "true");
        this.opts.put("-c", "");
        this.opts.put("-a", null);
    }

    public static void main(String[] args) throws Exception {
        PointerGenerator app = new PointerGenerator();
        app.parseArgs(args);
        app.generateClasses();
        System.out.println("Processing complete");
    }

    private void generateClasses() {
        String fileName = (String)this.opts.get("-f");
        String supersetFileName = (String)this.opts.get("-s");
        try {
            J9DDRStructureStore store = new J9DDRStructureStore(fileName, supersetFileName);
            System.out.println("superset directory name : " + fileName);
            System.out.println("superset file name : " + store.getSuperSetFileName());
            InputStream inputStream = store.getSuperset();
            if (this.opts.get("-a") != null) {
                Map<String, String> aliases = StructureReader.loadAliasMap((String)this.opts.get("-a"));
                this.structureReader = new StructureReader(inputStream);
                this.structureReader.applyAliases(aliases);
            } else {
                this.structureReader = new StructureReader(inputStream);
            }
            inputStream.close();
        }
        catch (IOException e) {
            System.out.println("Problem with file: " + fileName);
            e.printStackTrace();
            return;
        }
        this.outputDir = this.getOutputDir("-p");
        if (this.opts.get("-h") != null) {
            this.outputDirHelpers = this.getOutputDir("-h");
        }
        this.typeManager = new StructureTypeManager(this.structureReader.getStructures());
        for (StructureReader.StructureDescriptor structure : this.structureReader.getStructures()) {
            String error;
            try {
                if (FlagStructureList.isFlagsStructure(structure.getName())) {
                    this.generateBuildFlags(structure);
                    continue;
                }
                this.generateClass(structure);
            }
            catch (FileNotFoundException e) {
                error = String.format("File Not Found processing: %s: %s", structure.getPointerName(), e.getMessage());
                System.out.println(error);
            }
            catch (IOException e) {
                error = String.format("IOException processing: %s: %s", structure.getPointerName(), e.getMessage());
                System.out.println(error);
            }
        }
    }

    private void generateBuildFlags(StructureReader.StructureDescriptor structure) throws IOException {
        CodeGenerator.JavaSourceObject srcfile = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.OTHER);
        File javaFile = srcfile.getFile();
        ArrayList<StringBuilder> userImports = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> userCode = new ArrayList<StringBuilder>();
        this.collectMergeData(javaFile, userImports, userCode, structure);
        long length = javaFile.length();
        byte[] original = new byte[(int)length];
        if (javaFile.exists()) {
            FileInputStream fis = new FileInputStream(javaFile);
            fis.read(original);
            fis.close();
        }
        ByteArrayOutputStream newContents = new ByteArrayOutputStream((int)length);
        PrintWriter writer = new PrintWriter(newContents);
        this.writeCopyright(writer);
        writer.println();
        writer.format("package %s;%n", srcfile.getPackageName());
        this.writeBuildFlagImports(writer);
        writer.println();
        this.writeClassComment(writer, structure.getName());
        writer.format("public final class %s {%n", structure.getName());
        writer.println();
        writer.println("\t// Do not instantiate constant classes");
        writer.format("\tprivate %s() {%n", structure.getName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        this.writeBuildFlags(writer, structure);
        writer.println();
        this.writeBuildFlagsStaticInitializer(writer, structure);
        writer.println("}");
        writer.close();
        byte[] newContentsBytes = newContents.toByteArray();
        if (!javaFile.exists() || !Arrays.equals(original, newContentsBytes)) {
            FileOutputStream fos = new FileOutputStream(javaFile);
            fos.write(newContentsBytes);
            fos.close();
        }
    }

    private void writeBuildFlagsStaticInitializer(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        Collections.sort(structure.getConstants());
        writer.println("\tstatic {");
        writer.println("\t\tHashMap<String, Boolean> defaultValues = new HashMap<String, Boolean>();");
        writer.println();
        writer.println("\t\t// Edit default values here");
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            writer.format("\t\tdefaultValues.put(\"%s\", false);%n", constant.getName());
        }
        writer.println();
        writer.println("\t\ttry {");
        writer.println("\t\t\tClassLoader loader = " + structure.getName() + ".class.getClassLoader();");
        writer.println("\t\t\tif(!(loader instanceof com.ibm.j9ddr.J9DDRClassLoader)) {");
        writer.println("\t\t\t\tthrow new IllegalArgumentException(\"Cannot determine the runtime loader\");");
        writer.println("\t\t\t}");
        writer.println("\t\t\tClass<?> runtimeClass = ((com.ibm.j9ddr.J9DDRClassLoader) loader).loadClassRelativeToStream(\"structure." + structure.getName() + "\", false);");
        writer.println("\t\t\tField[] fields = runtimeClass.getFields();");
        writer.println("\t\t\tfor (int i = 0; i < fields.length; i++) {");
        writer.println("\t\t\t\tField field = fields[i];");
        writer.println("\t\t\t\t// Overwrite default value with real value if it exists.");
        writer.println("\t\t\t\tdefaultValues.put(field.getName(), field.getLong(runtimeClass) != 0);");
        writer.println("\t\t\t}");
        writer.println("\t\t} catch (ClassNotFoundException e) {");
        writer.println("\t\t\tthrow new IllegalArgumentException(String.format(\"Can not initialize flags from core file.%n%s\", e.getMessage()));");
        writer.println("\t\t} catch (IllegalAccessException e) {");
        writer.println("\t\t\tthrow new IllegalArgumentException(String.format(\"Can not initialize flags from core file.%n%s\", e.getMessage()));");
        writer.println("\t\t}");
        writer.println();
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            writer.format("\t\t%s = defaultValues.get(\"%s\");%n", constant.getName(), constant.getName());
        }
        writer.println("\t}");
        writer.println();
    }

    private String getClassName(String type, String compareTo) {
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(type, CodeGenerator.JavaSourceObjectType.POINTER);
        CodeGenerator.JavaSourceObject this_jso = new CodeGenerator.JavaSourceObject(compareTo, CodeGenerator.JavaSourceObjectType.POINTER);
        type = this_jso.getPackageName().equals(jso.getPackageName()) ? jso.getClassName() : jso.getFullClassName();
        return type;
    }

    private void generateClass(StructureReader.StructureDescriptor structure) throws IOException {
        String superClassName = structure.getSuperName() + "Pointer";
        superClassName = superClassName.equals("Pointer") ? "StructurePointer" : this.getClassName(superClassName, structure.getName());
        CodeGenerator.JavaSourceObject srcfile = new CodeGenerator.JavaSourceObject(structure.getPointerName(), CodeGenerator.JavaSourceObjectType.POINTER);
        File javaFile = srcfile.getFile();
        if (structure.getFields().size() == 0 && structure.getConstants().size() > 1 && superClassName.equals("StructurePointer")) {
            if (javaFile.exists()) {
                System.out.println("No fields and no superclass.  Deleting: " + structure.getName());
                javaFile.delete();
            }
            return;
        }
        ArrayList<StringBuilder> userImports = new ArrayList<StringBuilder>();
        ArrayList<StringBuilder> userCode = new ArrayList<StringBuilder>();
        if (((String)this.opts.get("-u")).equals("true")) {
            this.collectMergeData(javaFile, userImports, userCode, structure);
        } else {
            this.setCacheStatusFromPropertyFile(structure);
        }
        if (this.cacheClass || this.cacheFields) {
            System.out.println("Caching enabled for " + structure.getName() + "=" + this.cacheClass + "," + this.cacheFields);
        }
        long length = 0L;
        byte[] original = null;
        if (javaFile.exists()) {
            length = javaFile.length();
            original = new byte[(int)length];
            FileInputStream fis = new FileInputStream(javaFile);
            fis.read(original);
            fis.close();
        }
        ByteArrayOutputStream newContents = new ByteArrayOutputStream((int)length);
        PrintWriter writer = new PrintWriter(newContents);
        this.writeCopyright(writer);
        writer.println();
        this.writeGeneratedWarning(writer);
        writer.format("package %s;%n", srcfile.getPackageName());
        writer.println();
        if (((String)this.opts.get("-u")).equals("true")) {
            this.writerUserData(BEGIN_USER_IMPORTS, END_USER_IMPORTS, userImports, writer);
        }
        writer.println();
        this.writeImports(writer, structure);
        writer.println();
        this.writeClassComment(writer, structure.getPointerName());
        writer.format("@com.ibm.j9ddr.GeneratedPointerClass(structureClass=%s.class)", structure.getName());
        writer.println();
        writer.format("public class %s extends %s {%n", srcfile.getClassName(), superClassName);
        writer.println();
        writer.println("\t// NULL");
        writer.format("\tpublic static final %s NULL = new %s(0);%n", srcfile.getClassName(), srcfile.getClassName());
        writer.println();
        if (this.cacheClass) {
            writer.println("\t// Class Cache");
            if (((String)this.opts.get("-u")).equals("false")) {
                writer.format("\tprivate static final boolean CACHE_CLASS = true;\r\n", new Object[0]);
            }
            writer.format("\tprivate static HashMap<Long, %s> CLASS_CACHE = new HashMap<Long, %s>();%n", srcfile.getClassName(), srcfile.getClassName());
            writer.println();
        }
        if (this.cacheFields && ((String)this.opts.get("-u")).equals("false")) {
            writer.format("\tprivate static final boolean CACHE_FIELDS = true;\r\n", new Object[0]);
        }
        if (((String)this.opts.get("-u")).equals("true")) {
            this.writerUserData(BEGIN_USER_CODE, END_USER_CODE, userCode, writer);
        }
        writer.println();
        this.writeConstructor(writer, structure);
        writer.println();
        if (this.cacheClass) {
            writer.println("\t // Caching support methods");
            writer.println();
            this.generateCacheSupportMethods(writer, structure);
        }
        writer.println("\t// Implementation methods");
        writer.println();
        this.generateImplementationMethods(writer, structure);
        writer.println();
        writer.println("}");
        writer.close();
        byte[] newContentsBytes = newContents.toByteArray();
        if (null == original || !Arrays.equals(original, newContentsBytes)) {
            FileOutputStream fos = new FileOutputStream(javaFile);
            fos.write(newContentsBytes);
            fos.close();
        }
        if (this.outputDirHelpers != null && userCode.size() > 4) {
            File helperFile = new File(this.outputDirHelpers, structure.getPointerName() + ".java");
            FileWriter fos = new FileWriter(helperFile);
            for (StringBuilder builder : userImports) {
                fos.write(builder.toString());
            }
            for (StringBuilder builder : userCode) {
                fos.write(builder.toString());
            }
            fos.close();
        }
    }

    private void setCacheStatusFromPropertyFile(StructureReader.StructureDescriptor structure) {
        String opt = (String)this.opts.get("-c");
        if (opt == null || opt.length() == 0) {
            this.cacheClass = false;
            this.cacheFields = false;
        } else {
            String values;
            String[] parts;
            if (this.cacheProperties == null) {
                this.cacheProperties = new Properties();
                File file = new File(opt);
                if (file.exists()) {
                    try {
                        FileInputStream in = new FileInputStream(file);
                        this.cacheProperties.load(in);
                    }
                    catch (Exception e) {
                        String msg = String.format("The cache properties file [%s] specified by the -c option could not be read", file.getAbsolutePath());
                        throw new IllegalArgumentException(msg, e);
                    }
                } else {
                    String msg = String.format("The cache properties file [%s] specified by the -c option does not exist", file.getAbsolutePath());
                    throw new IllegalArgumentException(msg);
                }
            }
            if ((parts = (values = this.cacheProperties.getProperty(structure.getName(), "false,false")).split(",")).length != 2) {
                String msg = String.format("The cache properties file [%s] contains an invalid setting for the key [%s]. The value should be in the format <boolean>,<boolean>", opt);
                throw new IllegalArgumentException(msg);
            }
            this.cacheClass = Boolean.parseBoolean(parts[0]);
            this.cacheFields = Boolean.parseBoolean(parts[1]);
        }
    }

    private void generateCacheSupportMethods(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        if (this.cacheClass) {
            writer.format("\tprivate static void setCache(Long address, %s clazz) {%n", structure.getPointerName());
            writer.format("\t\tCLASS_CACHE.put(address, clazz);%n", new Object[0]);
            writer.format("\t}%n", new Object[0]);
            writer.println();
            writer.format("\tprivate static %s checkCache(Long address) {%n", structure.getPointerName());
            writer.format("\t\treturn CLASS_CACHE.get(address);%n", new Object[0]);
            writer.format("\t}%n", new Object[0]);
            writer.println();
        }
    }

    private void writeBuildFlags(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        writer.println("\t// Build Flags");
        Collections.sort(structure.getConstants());
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            writer.format("\tpublic static final boolean %s;%n", constant.getName());
        }
    }

    private void collectMergeData(File javaFile, ArrayList<StringBuilder> userImports, ArrayList<StringBuilder> userCode, StructureReader.StructureDescriptor structure) throws IOException {
        if (javaFile.exists()) {
            String aLine;
            BufferedReader reader = new BufferedReader(new FileReader(javaFile));
            while ((aLine = reader.readLine()) != null) {
                if (aLine.contains(BEGIN_USER_IMPORTS)) {
                    userImports.add(this.collectUserData(reader, END_USER_IMPORTS));
                    continue;
                }
                if (!aLine.contains(BEGIN_USER_CODE)) continue;
                userCode.add(this.collectUserData(reader, END_USER_CODE));
            }
            reader.close();
        }
        boolean containsCacheClass = false;
        boolean containsCacheFields = false;
        for (StringBuilder builder : userCode) {
            int pos = 0;
            pos = builder.indexOf("private static final boolean CACHE_FIELDS");
            if (pos != -1) {
                containsCacheFields = true;
                this.cacheFields = this.getFlagValue(builder, pos);
            }
            if ((pos = builder.indexOf("private static final boolean CACHE_CLASS")) == -1) continue;
            containsCacheClass = true;
            this.cacheClass = this.getFlagValue(builder, pos);
        }
        if (!containsCacheClass) {
            userCode.add(0, new StringBuilder("\tprivate static final boolean CACHE_CLASS = false;\r\n"));
            this.cacheClass = false;
        }
        if (!containsCacheFields) {
            if (structure.getFields().size() == 0) {
                userCode.add(0, new StringBuilder("\t@SuppressWarnings(\"unused\")\r\n"));
            }
            userCode.add(0, new StringBuilder("\tprivate static final boolean CACHE_FIELDS = false;\r\n"));
            this.cacheFields = false;
        }
    }

    private boolean getFlagValue(StringBuilder builder, int start) {
        int semicolon;
        int equals = builder.indexOf("=", start);
        if (equals != -1 && (semicolon = builder.indexOf(";", equals)) != -1) {
            String value = builder.substring(equals + 1, semicolon).trim();
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private StringBuilder collectUserData(BufferedReader reader, String endTag) throws IOException {
        String aLine;
        StringBuilder builder = new StringBuilder();
        while ((aLine = reader.readLine()) != null) {
            if (aLine.contains(endTag)) {
                return builder;
            }
            builder.append(aLine);
            builder.append(NEW_LINE);
        }
        return builder;
    }

    private void writerUserData(String beginTag, String endTag, ArrayList<StringBuilder> data, PrintWriter writer) {
        writer.print("/*");
        writer.print(beginTag);
        writer.println("*/");
        for (StringBuilder builder : data) {
            if (builder.length() <= 0) continue;
            writer.print(builder);
        }
        writer.print("/*");
        writer.print(endTag);
        writer.println("*/");
    }

    private void writeGeneratedWarning(PrintWriter writer) {
        writer.println("/**");
        writer.println(" * WARNING!!! GENERATED FILE");
        writer.println(" *");
        writer.println(" * This class is generated.");
        writer.println(" * Do not use the Eclipse \"Organize Imports\" feature on this class.");
        writer.println(" * ");
        if (((String)this.opts.get("-u")).equals("true")) {
            writer.println(" * It can contain user content, but that content must be delimited with the");
            writer.println(" * the tags");
            writer.println(" * [BEGIN USER IMPORTS]");
            writer.println(" * [END USER IMPORTS]");
            writer.println(" * ");
            writer.println(" * or");
            writer.println(" *");
            writer.println(" * [BEGIN USER CODE]");
            writer.println(" * [END USER CODE]");
            writer.println(" * ");
            writer.println(" * These tags are entered as comments.  Characters before [ and after ] are ignored.");
            writer.println(" * Lines between the tags are inserted into the newly generated file.");
            writer.println(" * ");
            writer.println(" * IMPORTS are combined and inserted above newly generated imports.  CODE is combined");
            writer.println(" * and inserted immediately after the class declaration");
            writer.println(" * ");
            writer.println(" * All lines outside these tags are lost and replaced with newly generated code.");
            writer.println(" * ");
        }
        writer.println(" */");
    }

    private void writeClassComment(PrintWriter writer, String name) {
        writer.println("/**");
        writer.format(" * Structure: %s%n", name);
        writer.println(" *");
        writer.println(" * A generated implementation a VM structure");
        if (((String)this.opts.get("-u")).equals("true")) {
            writer.println(" * This class contains generated code and MAY contain hand written user code.");
            writer.println(" * ");
            writer.println(" * Hand written user code must be contained at the top of");
            writer.println(" * the class file, specifically above ");
            writer.println(" * the comment line containing WARNING!!! GENERATED CODE");
            writer.println(" * ");
            writer.println(" * ALL code below the GENERATED warning will be replaced with new generated code");
            writer.println(" * each time the PointerGenerator utility is run.");
            writer.println(" * ");
            writer.format(" * The generated code will provide getters for all elements in the %s%n", name);
            writer.println(" * structure.  Where possible, meaningful return types are inferred.");
            writer.println(" * ");
            writer.println(" * The user may add methods to provide meaningful return types where only pointers");
            writer.println(" * could be automatically inferred");
            writer.println(" * ");
        } else {
            writer.println(" * Do not place hand written user code in this class as it will be overwritten.");
            writer.println(" * ");
        }
        writer.println(" */");
        writer.println();
    }

    private void generateImplementationMethods(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        Collections.sort(structure.getFields());
        block24: for (StructureReader.FieldDescriptor fieldDescriptor : structure.getFields()) {
            if (this.omitFieldImplementation(structure, fieldDescriptor)) continue;
            CTypeParser jtype = CTypeParser.fromBlob(fieldDescriptor.getType());
            int type = this.typeManager.getType(jtype.getDeclaredType());
            switch (type) {
                case 120: {
                    this.writeStructureMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 121: {
                    this.writeStructurePointerMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 110: {
                    this.writePointerMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 113: {
                    this.writeArrayMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 111: {
                    this.writeSRPMethod(writer, structure, fieldDescriptor, false);
                    continue block24;
                }
                case 112: {
                    this.writeSRPMethod(writer, structure, fieldDescriptor, true);
                    continue block24;
                }
                case 114: {
                    this.writeSRPPointerMethod(writer, structure, fieldDescriptor, false);
                    continue block24;
                }
                case 115: {
                    this.writeSRPPointerMethod(writer, structure, fieldDescriptor, true);
                    continue block24;
                }
                case 130: {
                    this.writeFJ9ObjectMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 131: {
                    this.writeFJ9ObjectPointerMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 132: {
                    this.writeJ9ObjectClassMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 133: {
                    this.writeJ9ObjectClassPointerMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 134: {
                    this.writeJ9ObjectMonitorMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 135: {
                    this.writeJ9ObjectMonitorPointerMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 0: {
                    this.writeStructureMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 100: {
                    this.writeBoolMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 102: {
                    this.writeDoubleMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 103: {
                    this.writeFloatMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 101: {
                    this.writeEnumMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 105: {
                    this.writeEnumPointerMethod(writer, structure, fieldDescriptor);
                    continue block24;
                }
                case 104: {
                    String typeName = fieldDescriptor.getType();
                    int colonIndex = typeName.indexOf(58);
                    if (colonIndex == -1) {
                        throw new IllegalArgumentException(String.format("%s is not a bitfield", fieldDescriptor));
                    }
                    this.writeBitFieldMethod(writer, structure, fieldDescriptor, type, fieldDescriptor.getName());
                    continue block24;
                }
                case 136: {
                    this.writeSimpleTypeMethod(writer, structure, fieldDescriptor, type);
                    continue block24;
                }
            }
            if (type >= 1 && type <= 99) {
                this.writeSimpleTypeMethod(writer, structure, fieldDescriptor, type);
                continue;
            }
            String error = String.format("Unhandled structure type: %s->%s %s", structure.getPointerName(), fieldDescriptor.getName(), fieldDescriptor.getType());
            System.out.println(error);
        }
    }

    private void writeSRPPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, boolean wide) {
        String pointerType;
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        String string = pointerType = wide ? "WideSelfRelativePointer" : "SelfRelativePointer";
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache ;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, pointerType, getter, fieldDescriptor, true);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = %s.cast(getPointerAtOffset(%s._%sOffset_));%n", getter, pointerType, structure.getName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn %s.cast(getPointerAtOffset(%s._%sOffset_));%n", pointerType, structure.getName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeBitFieldMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, int type, String getter) {
        CTypeParser parser = CTypeParser.fromNative(fieldDescriptor.getType());
        String typeString = parser.getCoreType();
        if (typeString.equals("bool")) {
            typeString = "boolean";
        } else if (this.isRawBlobType(typeString)) {
            typeString = this.getClassName(typeString, structure.getName());
        }
        if (getter.length() == 0) {
            writer.format("\t// %s %s %n", fieldDescriptor.getDeclaredType(), fieldDescriptor.getName());
            writer.println();
            return;
        }
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", typeString, getter);
        }
        this.writeMethodSignature(writer, typeString, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = get%sBitfield(%s._%s_s_, %s._%s_b_);%n", getter, typeString, jso.getFullClassName(), getter, structure.getName(), getter);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn get%sBitfield(%s._%s_s_, %s._%s_b_);%n", typeString, jso.getClassName(), getter, jso.getClassName(), getter);
        if (this.cacheFields) {
            writer.println("\t\t}");
        }
        this.writeMethodClose(writer);
    }

    private boolean omitFieldImplementation(StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor field) {
        String name = structure.getPointerName() + "." + field.getName();
        return omitList.contains(name);
    }

    private boolean isRawBlobType(String type) {
        String ptr = "Pointer";
        if (type.endsWith(ptr)) {
            type = type.substring(0, type.length() - ptr.length());
        }
        return this.structureReader.getStructureNames().contains(type);
    }

    private void writeMethodSignature(PrintWriter writer, String returnType, String getter, StructureReader.FieldDescriptor field, boolean fieldAccessor) {
        if (this.isRawBlobType(returnType)) {
            CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(returnType, CodeGenerator.JavaSourceObjectType.POINTER);
            returnType = jso.getClassName();
        }
        writer.format("\t// %s %s %n", field.getDeclaredType(), field.getDeclaredName());
        if (fieldAccessor) {
            String type = field.getDeclaredType();
            CTypeParser parser = CTypeParser.fromBlob(type);
            writer.format("\t@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName=\"_%sOffset_\", declaredType=\"%s\")", PointerGenerator.getOffsetConstant(field), parser.getDeclaredType());
            writer.println();
        }
        if (invalidMethodNames.contains(getter)) {
            getter = "_" + getter + "_";
        }
        writer.format("\tpublic %s %s() throws CorruptDataException {%n", returnType, getter);
    }

    private void writeEAMethod(PrintWriter writer, String returnType, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        if (this.isRawBlobType(returnType)) {
            returnType = this.getClassName(returnType, structure.getName());
        }
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %sEA_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter + "EA", fieldDescriptor, false);
        this.writeZeroCheck(writer);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%sEA_cache == null) {%n", getter);
            writer.format("\t\t\t\t%sEA_cache = %s.cast(address + %s._%sOffset_);%n", getter, returnType, structure.getName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %sEA_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        CTypeParser bparser = CTypeParser.fromBlob(returnType);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        writer.format("\t\treturn %s.cast(address + %s._%sOffset_);%n", bparser.getBlobType(), jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
    }

    private void writeZeroCheck(PrintWriter writer) {
        writer.format("\t\tif (address == 0) {%n", new Object[0]);
        writer.format("\t\t\tthrow new NullPointerDereference();%n", new Object[0]);
        writer.format("\t\t}%n", new Object[0]);
        writer.println();
    }

    private void writeEnumEAMethod(PrintWriter writer, String returnType, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        String enumType = this.getEnumType(CTypeParser.fromBlob(fieldDescriptor.getType()).getDeclaredType());
        enumType = enumType.replace("::", "$");
        CodeGenerator.JavaSourceObject ejso = new CodeGenerator.JavaSourceObject(enumType, CodeGenerator.JavaSourceObjectType.STUB);
        enumType = ejso.getClassName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %sEA_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter + "EA", fieldDescriptor, false);
        this.writeZeroCheck(writer);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%sEA_cache == null) {%n", getter);
            writer.format("\t\t\t\t%sEA_cache = %s.cast(address + %s._%sOffset_, %s.class);%n", getter, returnType, jso.getFullClassName(), offsetConstant, enumType);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %sEA_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn %s.cast(address + %s._%sOffset_, %s.class);%n", returnType, jso.getClassName(), offsetConstant, enumType);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
    }

    public static String getOffsetConstant(StructureReader.FieldDescriptor fieldDescriptor) {
        String fieldName = fieldDescriptor.getName();
        int index = fieldName.indexOf("_v");
        if (index == -1) {
            return fieldName;
        }
        if (Character.isDigit(fieldName.charAt(index + 2))) {
            return fieldName.substring(0, index);
        }
        return fieldName;
    }

    private void writeSRPEAMethod(PrintWriter writer, String returnType, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %sEA_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter + "EA", fieldDescriptor, false);
        this.writeZeroCheck(writer);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%sEA_cache == null) {%n", getter);
            writer.format("\t\t\t\t%sEA_cache = %s.cast(address + (%s._%sOffset_ + getIntAtOffset(%s._%sOffset_)));%n", getter, returnType, structure.getName(), offsetConstant, structure.getName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %sEA_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn %s.cast(address + %s._%sOffset_);%n", returnType, structure.getName(), offsetConstant, structure.getName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
    }

    private void writeMethodClose(PrintWriter writer) {
        writer.println("\t}");
        writer.println();
    }

    private void writePointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        String pointerType = this.getPointerType(fieldDescriptor.getType());
        CodeGenerator.JavaSourceObject jso = null;
        if (this.isRawBlobType(pointerType)) {
            jso = new CodeGenerator.JavaSourceObject(pointerType, CodeGenerator.JavaSourceObjectType.POINTER);
            pointerType = jso.getFullClassName();
        }
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache ;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, pointerType, getter, fieldDescriptor, true);
        jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = %s.cast(getPointerAtOffset(%s._%sOffset_));%n", getter, pointerType, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn %s.cast(getPointerAtOffset(%s._%sOffset_));%n", pointerType, jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private String getPointerType(String type) {
        if (type.indexOf(42) != type.lastIndexOf(42)) {
            return "PointerPointer";
        }
        int index = type.indexOf("const ");
        if (index != -1) {
            type = type.substring(index + "const ".length());
        }
        index = type.indexOf(42);
        type = type.substring(0, index).trim();
        type = type.replace('<', '_');
        type = type.replace('>', '_');
        return type.toUpperCase().substring(0, 1) + type.substring(1) + "Pointer";
    }

    private void writeArrayMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = this.getArrayType(CTypeParser.fromBlob(fieldDescriptor.getType()).getDeclaredType());
        if (returnType == null) {
            String error = String.format("Unhandled array type: %s->%s %s", structure.getPointerName(), fieldDescriptor.getName(), fieldDescriptor.getType());
            System.out.println(error);
            return;
        }
        if ((returnType = returnType.replace("::", "$")).equals("EnumPointer")) {
            this.writeEnumEAMethod(writer, returnType, structure, fieldDescriptor);
        } else {
            this.writeEAMethod(writer, returnType, structure, fieldDescriptor);
        }
    }

    private String getEnumType(String enumDeclaration) {
        int start = 0;
        int end = enumDeclaration.length();
        if (enumDeclaration.startsWith("enum ")) {
            start = "enum ".length();
        } else if (enumDeclaration.startsWith("enum")) {
            start = "enum".length();
        }
        if (enumDeclaration.endsWith("[]")) {
            end -= 2;
        }
        return enumDeclaration.substring(start, end);
    }

    private String getArrayType(String arrayDeclaration) {
        String componentType = arrayDeclaration.substring(0, arrayDeclaration.lastIndexOf(91)).trim();
        CTypeParser bparser = CTypeParser.fromBlob(componentType);
        int arrayType = this.typeManager.getType(bparser.getDeclaredType());
        switch (arrayType) {
            case 100: {
                return "BoolPointer";
            }
            case 101: {
                return "EnumPointer";
            }
            case 102: {
                return "DoublePointer";
            }
            case 103: {
                return "FloatPointer";
            }
            case 104: {
                break;
            }
            case 110: 
            case 113: 
            case 121: 
            case 131: 
            case 133: 
            case 135: {
                return "PointerPointer";
            }
            case 111: 
            case 112: {
                break;
            }
            case 120: {
                int start = componentType.indexOf("struct ");
                start = start >= 0 ? (start += "struct ".length()) : ((start = componentType.indexOf("class ")) >= 0 ? (start += "class ".length()) : ((start = componentType.indexOf("enum ")) >= 0 ? (start += "enum ".length()) : 0));
                return componentType.substring(start, componentType.length()).trim() + "Pointer";
            }
            case 130: {
                return "ObjectReferencePointer";
            }
            case 132: {
                return "ObjectClassReferencePointer";
            }
            case 134: {
                return "ObjectMonitorReferencePointer";
            }
            default: {
                if (arrayType < 1 || arrayType >= 99) break;
                return componentType + "Pointer";
            }
        }
        return null;
    }

    private void writeBoolMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate Boolean %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "boolean", getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = new Boolean(getBoolAtOffset(%s._%sOffset_));%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache.booleanValue();%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn getBoolAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "BoolPointer", structure, fieldDescriptor);
    }

    private void writeDoubleMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate Double %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "double", getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = new Double(getDoubleAtOffset(%s._%sOffset_));%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache.doubleValue();%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn getDoubleAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "DoublePointer", structure, fieldDescriptor);
    }

    private void writeEnumMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        String enumType = this.getEnumType(CTypeParser.fromBlob(fieldDescriptor.getType()).getDeclaredType());
        enumType = enumType.replace("::", "$");
        CodeGenerator.JavaSourceObject ejso = new CodeGenerator.JavaSourceObject(enumType, CodeGenerator.JavaSourceObjectType.STUB);
        enumType = ejso.getClassName();
        if (this.cacheFields) {
            writer.format("\tprivate Long %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "long", getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\tif (%s.SIZEOF == 1) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = new Long(getByteAtOffset(%s._%sOffset_));%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t\t} else if (%s.SIZEOF == 2) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = new Long(getShortAtOffset(%s._%sOffset_));%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t\t} else if (%s.SIZEOF == 4) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = new Long(getIntAtOffset(%s._%sOffset_));%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t\t} else if (%s.SIZEOF == 8) {%n", enumType);
            writer.format("\t\t\t\t\t%s_cache = new Long(getLongAtOffset(%s._%sOffset_));%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t\t} else {%n", new Object[0]);
            writer.format("\t\t\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
            writer.format("\t\t\t\t}%n", new Object[0]);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache.longValue();%n", getter);
            writer.format("\t\t} else {%n", new Object[0]);
        }
        writer.format("\t\t\tif (%s.SIZEOF == 1) {%n", enumType);
        writer.format("\t\t\t\treturn getByteAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        writer.format("\t\t\t} else if (%s.SIZEOF == 2) {%n", enumType);
        writer.format("\t\t\t\treturn getShortAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        writer.format("\t\t\t} else if (%s.SIZEOF == 4) {%n", enumType);
        writer.format("\t\t\t\treturn getIntAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        writer.format("\t\t\t} else if (%s.SIZEOF == 8) {%n", enumType);
        writer.format("\t\t\t\treturn getLongAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        writer.format("\t\t\t} else {%n", new Object[0]);
        writer.format("\t\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
        writer.format("\t\t\t}%n", new Object[0]);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEnumEAMethod(writer, "EnumPointer", structure, fieldDescriptor);
    }

    private void writeEnumPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        String pointerType = "EnumPointer";
        String type = fieldDescriptor.getType();
        String enumType = this.getEnumType(type.substring(0, type.indexOf(42)));
        CodeGenerator.JavaSourceObject ejso = new CodeGenerator.JavaSourceObject(enumType, CodeGenerator.JavaSourceObjectType.STUB);
        enumType = ejso.getClassName();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache ;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, pointerType, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = %s.cast(getPointerAtOffset(%s._%sOffset_), %s.class);%n", getter, pointerType, jso.getFullClassName(), offsetConstant, enumType);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn %s.cast(getPointerAtOffset(%s._%sOffset_), %s.class);%n", pointerType, jso.getClassName(), offsetConstant, enumType);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeFloatMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate Float %s_cache;%n", getter);
        }
        this.writeMethodSignature(writer, "float", getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = new Float(getFloatAtOffset(%s._%sOffset_));%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache.floatValue();%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn getFloatAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "FloatPointer", structure, fieldDescriptor);
    }

    private void writeSimpleTypeMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, int type) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        String typeString = fieldDescriptor.getType();
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", typeString, getter);
        }
        this.writeMethodSignature(writer, typeString, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = new %s(%s(%s._%sOffset_));%n", getter, typeString, StructureTypeManager.simpleTypeAccessorMap.get(type), jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn new %s(%s(%s._%sOffset_));%n", typeString, StructureTypeManager.simpleTypeAccessorMap.get(type), jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, fieldDescriptor.getType() + "Pointer", structure, fieldDescriptor);
    }

    private void writeSRPMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor, boolean isWide) {
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        String typeString = CTypeParser.fromBlob(fieldDescriptor.getType()).getDeclaredType();
        String prefix = isWide ? "J9WSRP" : "J9SRP";
        String getAtOffsetFunction = isWide ? "getPointerAtOffset" : "getIntAtOffset";
        String referencedTypeString = null;
        referencedTypeString = typeString.startsWith(prefix + "(") ? typeString.substring(prefix.length() + 1, typeString.length() - 1) : "void";
        int type = this.typeManager.getType(referencedTypeString);
        String pointerType = null;
        switch (type) {
            case 120: {
                pointerType = referencedTypeString.substring("struct ".length()) + "Pointer";
                break;
            }
            case 0: {
                pointerType = "VoidPointer";
                break;
            }
            case 111: {
                pointerType = "SelfRelativePointer";
                break;
            }
            case 112: {
                pointerType = "WideSelfRelativePointer";
                break;
            }
            default: {
                if (type >= 1 && type <= 99) {
                    pointerType = this.getPointerType(referencedTypeString + "*");
                    break;
                }
                throw new RuntimeException("Unexpected SRP reference type: " + type + " from " + fieldDescriptor.getType());
            }
        }
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", pointerType, getter);
        }
        this.writeMethodSignature(writer, pointerType, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        this.writeZeroCheck(writer);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\tlong nextAddress = %s(%s._%sOffset_);%n", getAtOffsetFunction, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t\tif(nextAddress == 0) {%n", new Object[0]);
            writer.format("\t\t\t\t\t%s_cache = %s.NULL;%n", getter, pointerType);
            writer.format("\t\t\t\t} else {%n", new Object[0]);
            writer.format("\t\t\t\t\t%s_cache = %s.cast(address + (%s._%sOffset_ + nextAddress));%n", getter, pointerType, structure.getName(), offsetConstant);
            writer.format("\t\t\t\t}%n", new Object[0]);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n", new Object[0]);
        }
        writer.format("\t\t\tlong nextAddress = %s(%s._%sOffset_);%n", getAtOffsetFunction, jso.getClassName(), offsetConstant);
        writer.format("\t\t\tif(nextAddress == 0) {%n", new Object[0]);
        writer.format("\t\t\t\treturn %s.NULL;%n", pointerType);
        writer.format("\t\t\t}%n", new Object[0]);
        writer.format("\t\t\treturn %s.cast(address + (%s._%sOffset_ + nextAddress));%n", pointerType, jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeSRPEAMethod(writer, isWide ? "WideSelfRelativePointer" : "SelfRelativePointer", structure, fieldDescriptor);
    }

    private void writeStructurePointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String type = CTypeParser.fromBlob(fieldDescriptor.getType()).getDeclaredType();
        int start = type.indexOf("struct ");
        start = start >= 0 ? (start += "struct ".length()) : ((start = type.indexOf("class ")) >= 0 ? (start += "class ".length()) : ((start = type.indexOf("enum ")) >= 0 ? (start += "enum ".length()) : 0));
        String typeName = type.substring(start, type.indexOf(42)) + "Pointer";
        typeName = typeName.replace("::", "$");
        String returnType = this.getClassName(typeName, structure.getName());
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t\t%s_cache = %s.cast(pointer);%n", getter, returnType);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        writer.format("\t\treturn %s.cast(pointer);%n", returnType);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeFJ9ObjectMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "J9ObjectPointer";
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = getObjectReferenceAtOffset(%s._%sOffset_);%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn getObjectReferenceAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "ObjectReferencePointer", structure, fieldDescriptor);
    }

    private void writeFJ9ObjectPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "ObjectReferencePointer";
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t\t%s_cache = %s.cast(pointer);%n", getter, returnType);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        writer.format("\t\t\treturn %s.cast(pointer);%n", returnType);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectClassMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "J9ClassPointer";
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = getObjectClassAtOffset(%s._%sOffset_);%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn getObjectClassAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "ObjectClassReferencePointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectClassPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "ObjectClassReferencePointer";
        String getter = fieldDescriptor.getName();
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        writer.format("\t\t// j9objectclass_t* method goes here%n", new Object[0]);
        writer.format("\t\treturn null;%n", new Object[0]);
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "J9ObjectMonitorPointer";
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = getObjectMonitorAtOffset(%s._%sOffset_);%n", getter, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn getObjectMonitorAtOffset(%s._%sOffset_);%n", jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "ObjectMonitorReferencePointer", structure, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorPointerMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType = "ObjectMonitorReferencePointer";
        String getter = fieldDescriptor.getName();
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        writer.format("\t\t// j9objectmonitor_t* method goes here%n", new Object[0]);
        writer.format("\t\treturn null;%n", new Object[0]);
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeStructureMethod(PrintWriter writer, StructureReader.StructureDescriptor structure, StructureReader.FieldDescriptor fieldDescriptor) {
        String returnType;
        String type = CTypeParser.fromBlob(fieldDescriptor.getType()).getDeclaredType();
        Object jret = null;
        if (type.equals("void")) {
            returnType = "VoidPointer";
        } else {
            int start = type.indexOf("struct ");
            start = start >= 0 ? (start += "struct ".length()) : ((start = type.indexOf("class ")) >= 0 ? (start += "class ".length()) : 0);
            type = type.replace("::", "$");
            returnType = this.getClassName(type.substring(start) + "Pointer", structure.getName());
        }
        String getter = fieldDescriptor.getName();
        String offsetConstant = PointerGenerator.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            writer.format("\tprivate %s %s_cache;%n", returnType, getter);
        }
        this.writeMethodSignature(writer, returnType, getter, fieldDescriptor, true);
        this.writeZeroCheck(writer);
        CodeGenerator.JavaSourceObject jso = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        if (this.cacheFields) {
            writer.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            writer.format("\t\t\tif (%s_cache == null) {%n", getter);
            writer.format("\t\t\t\t%s_cache = %s.cast(address + %s._%sOffset_);%n", getter, returnType, jso.getFullClassName(), offsetConstant);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn %s_cache;%n", getter);
            writer.format("\t\t} else {%n\t", new Object[0]);
        }
        writer.format("\t\treturn %s.cast(address + %s._%sOffset_);%n", returnType, jso.getClassName(), offsetConstant);
        if (this.cacheFields) {
            writer.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(writer);
        this.writeEAMethod(writer, "PointerPointer", structure, fieldDescriptor);
    }

    private void writeConstructor(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        CodeGenerator.JavaSourceObject name = new CodeGenerator.JavaSourceObject(structure.getPointerName(), CodeGenerator.JavaSourceObjectType.POINTER);
        CodeGenerator.JavaSourceObject structureName = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        writer.println("\t// Do not call this constructor.  Use static method cast instead");
        writer.format("\tprotected %s(long address) {%n", name.getClassName());
        writer.println("\t\tsuper(address);");
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic static %s cast(AbstractPointer structure) {%n", name.getClassName());
        writer.format("\t\treturn cast(structure.getAddress());%n", new Object[0]);
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic static %s cast(UDATA udata) {%n", name.getClassName());
        writer.format("\t\treturn cast(udata.longValue());%n", new Object[0]);
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic static %s cast(long address) {%n", name.getClassName());
        writer.format("\tif (address == 0) {%n", new Object[0]);
        writer.format("\t\treturn NULL;%n", new Object[0]);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        if (this.cacheClass) {
            writer.format("\t\tif (CACHE_CLASS) {%n", new Object[0]);
            writer.format("\t\t\t%s clazz = checkCache(address);%n", name.getClassName());
            writer.format("\t\t\tif (null == clazz) {%n", new Object[0]);
            writer.format("\t\t\t\tclazz = new %s(address);%n", name.getClassName(), name.getClassName());
            writer.format("\t\t\t\tsetCache(address, clazz);%n", new Object[0]);
            writer.format("\t\t\t}%n", new Object[0]);
            writer.format("\t\t\treturn clazz;%n", new Object[0]);
            writer.format("\t\t} else {\t%n", new Object[0]);
        }
        writer.format("\t\treturn new %s(address);%n", name.getClassName(), name.getClassName());
        if (this.cacheClass) {
            writer.format("\t\t}%n", new Object[0]);
        }
        writer.println("\t}");
        writer.println();
        writer.format("\tpublic %s add(long count) {%n", name.getClassName());
        writer.format("\t\treturn %s.cast(address + (%s.SIZEOF * count));%n", name.getClassName(), structureName.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s add(Scalar count) {%n", name.getClassName());
        writer.format("\t\treturn add(count.longValue());%n", name.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s addOffset(long offset) {%n", name.getClassName());
        writer.format("\t\treturn %s.cast(address + offset);%n", name.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s addOffset(Scalar offset) {%n", name.getClassName());
        writer.format("\t\treturn addOffset(offset.longValue());%n", name.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s sub(long count) {%n", name.getClassName());
        writer.format("\t\treturn %s.cast(address - (%s.SIZEOF * count));%n", name.getClassName(), structureName.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s sub(Scalar count) {%n", name.getClassName());
        writer.format("\t\treturn sub(count.longValue());%n", name.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s subOffset(long offset) {%n", name.getClassName());
        writer.format("\t\treturn %s.cast(address - offset);%n", name.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s subOffset(Scalar offset) {%n", name.getClassName());
        writer.format("\t\treturn subOffset(offset.longValue());%n", name.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s untag(long mask) {%n", name.getClassName());
        writer.format("\t\treturn %s.cast(address & ~mask);%n", name.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tpublic %s untag() {%n", name.getClassName());
        writer.format("\t\treturn untag(UDATA.SIZEOF - 1);%n", new Object[0]);
        writer.format("\t}%n", new Object[0]);
        writer.println();
        writer.format("\tprotected long sizeOfBaseType() {%n", new Object[0]);
        writer.format("\t\treturn %s.SIZEOF;%n", structureName.getClassName());
        writer.format("\t}%n", new Object[0]);
        writer.println();
    }

    private void writeImports(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        if (structure.getFields().size() > 0) {
            writer.println("import com.ibm.j9ddr.CorruptDataException;");
            writer.println("import com.ibm.j9ddr.NullPointerDereference;");
        }
        String version = (String)this.opts.get("-v");
        writer.println(String.format("import com.ibm.j9ddr.%s.pointer.*;", version));
        writer.println(String.format("import com.ibm.j9ddr.%s.structure.*;", version));
        writer.println(String.format("import com.ibm.j9ddr.%s.types.*;", version));
        if (this.cacheClass) {
            writer.println("import java.util.HashMap;");
        }
    }

    private void writeBuildFlagImports(PrintWriter writer) {
        writer.println("import java.util.HashMap;");
        writer.println("import java.lang.reflect.Field;");
    }

    private void parseArgs(String[] args) {
        if (args.length == 0 || args.length % 2 != 0) {
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < args.length; i += 2) {
            if (this.opts.containsKey(args[i])) {
                this.opts.put(args[i], args[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + args[i]);
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (String key : this.opts.keySet()) {
            String value = (String)this.opts.get(key);
            if (value != null || key.equals("-s") || key.equals("-h")) continue;
            System.err.println("The option " + key + " has not been set.\n");
            PointerGenerator.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava PointerGenerator -p <package name> -o <output path> -f <path to structure file> -v <vm version> [-s <superset file name> -h <helper class package> -u <user code support> -c <cache properties>]\n");
        System.out.println("<package name>           : the package name for all the generated classes e.g. com.ibm.j9ddr.vm.pointer.generated");
        System.out.println("<relative output path>   : where to write out the class files.  Full path to base of package hierarchy e.g. c:\\src\\");
        System.out.println("<path to structure file> : full path to the J9 structure file");
        System.out.println("<vm version>             : the version of the VM for which the pointers are generated e.g. 23 and corresponds to the stub package name");
        System.out.println("<superset file name>     : optional filename of the superset to be used as input / output");
        System.out.println("<helper class package>   : optional package for pointer helper files to be generated in from user code ");
        System.out.println("<user code support>      : optional set to true or false to enable or disable user code support in the generated pointers, default if not specified is true");
        System.out.println("<cache properties>       : optional properties file which controls the class and field caching of generated pointers");
    }

    private File getOutputDir(String option) {
        String outputPath = (String)this.opts.get("-o");
        if (!outputPath.endsWith("/") || !outputPath.endsWith("\\")) {
            outputPath = outputPath + "/";
        }
        outputPath = outputPath + ((String)this.opts.get(option)).replace('.', '/');
        System.out.println("Writing generated pointer classes to " + outputPath + "/" + "pointer.generated".replace('.', '/'));
        File output = new File(outputPath);
        output.mkdirs();
        return output;
    }

    private void writeCopyright(PrintWriter writer) {
        int year = Calendar.getInstance().get(1);
        writer.println("/*******************************************************************************");
        writer.println(" * Licensed Materials - Property of IBM");
        writer.println(" * \"Restricted Materials of IBM\"");
        writer.println(" * ");
        writer.println(" * (c) Copyright IBM Corp. 1991, " + year + " All Rights Reserved");
        writer.println(" * ");
        writer.println(" * US Government Users Restricted Rights - Use, duplication or disclosure");
        writer.println(" * restricted by GSA ADP Schedule Contract with IBM Corp.");
        writer.println(" *******************************************************************************/");
    }
}

