/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.PrimitiveArray;

public final class IntegerArray
extends PrimitiveArray {
    int[][] chunks;

    public IntegerArray(int shift) {
        this.shift = shift;
        this.CHUNK_SIZE = 1 << shift;
        this.mask = this.CHUNK_SIZE - 1;
        this.chunks = new int[1][this.CHUNK_SIZE];
    }

    public IntegerArray() {
        this(12);
    }

    public IntegerArray(int length, int value) {
        for (int i = 0; i < length; ++i) {
            this.add(value);
        }
    }

    public Object clone() {
        IntegerArray clone = new IntegerArray();
        clone.chunks = new int[this.chunks.length][this.CHUNK_SIZE];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, clone.chunks[i], 0, this.CHUNK_SIZE);
        }
        clone.chunkOffset = this.chunkOffset;
        clone.size = this.size;
        return clone;
    }

    public int[] toArray() {
        int[] a = new int[this.size()];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, a, i << this.shift, i == this.chunks.length - 1 ? this.chunkOffset : this.CHUNK_SIZE);
        }
        return a;
    }

    public void add(int value) {
        if (this.chunkOffset >= this.CHUNK_SIZE) {
            int[][] newchunks = new int[this.chunks.length + 1][];
            for (int i = 0; i < this.chunks.length; ++i) {
                newchunks[i] = this.chunks[i];
            }
            newchunks[this.chunks.length] = new int[this.CHUNK_SIZE];
            this.chunks = newchunks;
            this.chunkOffset = 0;
        }
        this.chunks[this.chunks.length - 1][this.chunkOffset++] = value;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new Error("Attempt to get " + index + " greater than size " + this.size);
        }
        return this.chunks[index >> this.shift][index & this.mask];
    }

    long lget(int index) {
        return this.get(index);
    }

    public void put(int index, int value) {
        if (index >= this.size) {
            throw new Error("Attempt to put " + index + " greater than size " + this.size);
        }
        this.chunks[index >> this.shift][index & this.mask] = value;
    }

    void lput(int index, long value) {
        this.put(index, (int)value);
    }

    public void add(int index, int value) {
        for (int i = 0; i < index + 1 - this.size; ++i) {
            this.add(0);
        }
        this.put(index, value);
    }

    public void putAll(int value) {
        for (int i = 0; i < this.size; ++i) {
            this.put(i, value);
        }
    }

    public int memoryUsage() {
        return this.chunks.length * this.CHUNK_SIZE * 4;
    }
}

