/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.MVSFileReader;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.SystemTrace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.CharConversion;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.FileFormatException;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ObjectMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;

public final class Dump
extends ImageInputStreamImpl {
    private String filename;
    private ImageInputStream raf;
    private BufferedInputStream inputStream;
    private BufferedOutputStream outputStream;
    private AddressSpace[] spaces;
    private String title;
    private String productName;
    private String productVersion;
    private String productRelease;
    private String productModification;
    private Date creationDate;
    private long fileSize;
    AddressSpace rootSpace;
    AddressSpace highVirtualSharedSpace;
    private SoftReference<SystemTrace> systemTraceRef;
    static final int HEADERSIZE = 64;
    public static final int DATABLOCKSIZE = 4096;
    static final int BLOCKSIZE = 4160;
    private static final int DR1 = -992349888;
    private static final int DR2 = -992349632;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public static boolean isValid(String filename) {
        try {
            new Dump(filename, false);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (FileFormatException e) {
            return false;
        }
    }

    public Dump(String filename) throws FileNotFoundException, FileFormatException {
        this(filename, true);
    }

    public Dump(ImageInputStream in) throws FileNotFoundException, FileFormatException {
        this(in, true);
    }

    public Dump(ImageInputStream in, boolean initialize) throws FileNotFoundException, FileFormatException {
        log.fine("Initialising from input stream");
        this.filename = "DataStream";
        this.raf = in;
        this.fileSize = -1L;
        this.readFirstBlock();
        if (initialize) {
            this.initialize();
        }
    }

    public Dump(String filename, boolean initialize) throws FileNotFoundException, FileFormatException {
        log.fine("opening dump " + filename);
        this.filename = filename;
        try {
            this.raf = new FileImageInputStream(new RandomAccessFile(filename, "r"));
            this.fileSize = new File(filename).length();
        }
        catch (FileNotFoundException e) {
            if (System.getProperty("os.arch").indexOf("390") == -1) {
                throw e;
            }
            try {
                this.raf = new MVSFileReader(filename);
            }
            catch (Exception ex) {
                log.info("could not load dump: " + ex.getMessage());
                throw e;
            }
        }
        catch (LinkageError le) {
            log.info("could not load recordio: " + le);
            throw le;
        }
        this.readFirstBlock();
        if (initialize) {
            this.initialize();
        }
    }

    public Dump(InputStream stream, boolean initialize) throws FileNotFoundException, FileFormatException {
        log.fine("Creating dump image from input stream");
        this.filename = "stream";
        this.raf = new MemoryCacheImageInputStream(stream);
        this.readFirstBlock();
        if (initialize) {
            this.initialize();
        }
    }

    public Dump(String filename, ImageInputStream stream) throws FileNotFoundException, FileFormatException {
        this.filename = filename;
        this.raf = stream;
        this.fileSize = new File(filename).length();
        this.readFirstBlock();
        this.initialize();
    }

    public Dump(BufferedInputStream inputStream, String filename) throws FileNotFoundException, FileFormatException {
        this.inputStream = inputStream;
        this.filename = filename;
        this.outputStream = new BufferedOutputStream(new FileOutputStream(filename));
        this.readFirstBlock();
        this.initialize();
    }

    private void readFirstBlock() throws FileNotFoundException, FileFormatException {
        try {
            byte[] blockHeader = new byte[512];
            if (this.inputStream != null) {
                this.inputStream.mark(blockHeader.length * 2);
            }
            this.readFully(blockHeader);
            int eye = Dump.readInt(blockHeader, 0);
            if (eye != -992349888 && eye != -992349632) {
                throw new FileFormatException("bad eyecatcher " + Dump.hex(eye) + " in first block");
            }
            this.title = CharConversion.getEbcdicString(blockHeader, 88, 100);
            this.productName = CharConversion.getEbcdicString(blockHeader, 244, 16);
            this.productVersion = CharConversion.getEbcdicString(blockHeader, 260, 2);
            this.productRelease = CharConversion.getEbcdicString(blockHeader, 262, 2);
            this.productModification = CharConversion.getEbcdicString(blockHeader, 264, 2);
            long c1 = Dump.readInt(blockHeader, 72);
            long c2 = Dump.readInt(blockHeader, 76);
            this.creationDate = Dump.mvsClockToDate(c1 << 32 | c2 & 0xFFFFFFFFL);
            if (this.inputStream != null) {
                this.inputStream.reset();
            } else {
                this.raf.seek(0L);
            }
        }
        catch (IOException e) {
            throw new FileFormatException("oops: " + e);
        }
    }

    public void initialize() throws FileNotFoundException, FileFormatException {
        try {
            log.fine("Scanning dump file");
            byte[] blockHeader = null;
            ObjectMap asidMap = new ObjectMap();
            long offset = 0L;
            while (true) {
                if (this.inputStream == null) {
                    this.raf.seek(offset);
                }
                if (this.inputStream != null) {
                    if (blockHeader == null) {
                        blockHeader = new byte[4160];
                    }
                } else if (offset == 0L) {
                    blockHeader = new byte[512];
                } else if (offset == 4160L) {
                    blockHeader = new byte[64];
                }
                try {
                    this.readFully(blockHeader);
                }
                catch (EOFException eof) {
                    break;
                }
                if (this.inputStream != null) {
                    this.outputStream.write(blockHeader, 0, 4160);
                }
                int eye = Dump.readInt(blockHeader, 0);
                boolean oldFormat = false;
                if (eye == -992349888) {
                    oldFormat = true;
                } else if (eye != -992349632) {
                    throw new FileFormatException("bad eyecatcher " + Dump.hex(eye) + " at offset " + offset);
                }
                int asid = Dump.readInt(blockHeader, 12);
                if (asid < 0 && asid != -910042680) {
                    log.fine("ignoring asid " + Dump.hex(asid) + " " + Dump.hex(Dump.readInt(blockHeader, 13)));
                } else {
                    AddressSpace space;
                    long address;
                    long l = address = oldFormat ? (long)Dump.readInt(blockHeader, 20) : Dump.readLong(blockHeader, 20);
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("read block, asid = " + Dump.hex(asid) + " address = " + Dump.hex(address));
                    }
                    if ((space = (AddressSpace)asidMap.get(asid)) == null) {
                        space = new AddressSpace(this, asid);
                        asidMap.put(asid, space);
                    }
                    space.mapAddressToFileOffset(address, offset + 64L);
                    if (asid == 1) {
                        this.rootSpace = space;
                    }
                    if (asid == -910042680) {
                        this.highVirtualSharedSpace = space;
                    }
                }
                offset += 4160L;
            }
            this.spaces = (AddressSpace[])asidMap.toArray(new AddressSpace[0]);
            Arrays.sort(this.spaces, new Comparator<AddressSpace>(){

                @Override
                public int compare(AddressSpace space1, AddressSpace space2) {
                    return space1.getAsid() - space2.getAsid();
                }
            });
            this.seek(0L);
            log.fine("scan complete");
        }
        catch (FileFormatException e) {
            throw e;
        }
        catch (Exception e) {
            log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.Dump", "initialize", "Unexpected exception", e);
            throw new Error("unexpected exception: " + e);
        }
    }

    static int readInt(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
        return n;
    }

    static long readLong(byte[] buf, int offset) {
        long upper = Dump.readInt(buf, offset);
        long lower = Dump.readInt(buf, offset + 4);
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    public void seek(long offset) throws IOException {
        super.seek(offset);
        if (this.inputStream == null) {
            this.raf.seek(offset);
        }
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int r = this.read(buf);
        if (r <= 0) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int n;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read into " + buf + " " + Dump.hex(off) + " " + Dump.hex(len));
        }
        if ((n = this.inputStream != null ? this.inputStream.read(buf, off, len) : this.raf.read(buf, off, len)) > 0) {
            this.streamPos += (long)n;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("read 0x" + Dump.hex(n) + " bytes");
        }
        return n;
    }

    public int read(byte[] buf) throws IOException {
        int n;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Read into " + buf + " " + Dump.hex(buf.length));
        }
        if ((n = this.inputStream != null ? this.inputStream.read(buf) : this.raf.read(buf)) > 0) {
            this.streamPos += (long)n;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("read 0x" + Dump.hex(n) + " bytes");
        }
        return n;
    }

    public long length() {
        return this.fileSize;
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.outputStream.close();
        } else {
            this.raf.close();
        }
    }

    public void localClose() throws IOException {
    }

    public AddressSpace[] getAddressSpaces() {
        return this.spaces;
    }

    public AddressSpace getAddressSpace(int id) {
        for (int i = 0; i < this.spaces.length; ++i) {
            if (this.spaces[i].getAsid() != id) continue;
            return this.spaces[i];
        }
        return null;
    }

    public boolean is64bit() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    public String getProductModification() {
        return this.productModification;
    }

    public static Date mvsClockToDate(long clock) {
        clock >>>= 12;
        clock /= 1000L;
        long epoch = 613608L;
        epoch *= 3600L;
        return new Date(clock -= (epoch *= 1000L));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public SystemTrace getSystemTrace() throws IOException {
        SystemTrace systemTrace;
        SystemTrace systemTrace2 = systemTrace = this.systemTraceRef == null ? null : this.systemTraceRef.get();
        if (systemTrace != null) {
            return systemTrace;
        }
        for (int i = 0; i < this.spaces.length; ++i) {
            AddressSpace space = this.spaces[i];
            long lowestAddress = space.getLowestAddress();
            int eyecatcher = space.readInt(lowestAddress);
            if (eyecatcher != -471612472) continue;
            systemTrace = new SystemTrace(space);
            this.systemTraceRef = new SoftReference<SystemTrace>(systemTrace);
            return systemTrace;
        }
        throw new Error("no system trace found!");
    }

    public String getName() {
        return this.filename;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static String hex(long n) {
        return Long.toHexString(n);
    }

    public boolean equals(Object obj) {
        Dump dump = (Dump)obj;
        return dump.filename.equals(this.filename);
    }

    public int hashCode() {
        return this.filename.hashCode();
    }
}

