/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.CorruptCoreException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import com.ibm.j9ddr.corereaders.minidump.LateInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.minidump.unwind.RuntimeFunction;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindModule;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModuleStream
extends LateInitializedStream {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");

    public ModuleStream(int dataSize, int location) {
        super(dataSize, location);
    }

    private String getModuleName(MiniDumpReader dump, int position) throws IOException {
        dump.seek(position);
        int length = dump.readInt();
        if (length <= 0 || 512 <= length) {
            length = 512;
        }
        byte[] nameWide = dump.readBytes(length);
        return new String(nameWide, "UTF-16LE");
    }

    @Override
    public void readFrom(MiniDumpReader dump, IAddressSpace as, boolean is64Bit) throws IOException, CorruptDataException {
        dump.seek(this.getLocation());
        int numberOfModules = dump.readInt();
        if (numberOfModules > 1024) {
            throw new CorruptDataException("Improbably high number of modules found: " + numberOfModules + ", location = " + Long.toHexString(this.getLocation()));
        }
        class ModuleData {
            long imageBaseAddress;
            Properties properties;
            int nameAddress;

            ModuleData() {
            }
        }
        ModuleData[] moduleData = new ModuleData[numberOfModules];
        for (int i = 0; i < numberOfModules; ++i) {
            moduleData[i] = new ModuleData();
            moduleData[i].imageBaseAddress = dump.readLong();
            int imageSize = dump.readInt();
            int checksum = dump.readInt();
            int timeDateStamp = dump.readInt();
            moduleData[i].nameAddress = dump.readInt();
            moduleData[i].properties = this.readProperties(dump, imageSize, checksum, timeDateStamp);
        }
        for (ModuleData thisModule : moduleData) {
            long imageBaseAddress = thisModule.imageBaseAddress;
            String moduleName = this.getModuleName(dump, thisModule.nameAddress);
            Properties properties = thisModule.properties;
            try {
                short magic = as.getShortAt(imageBaseAddress);
                if (23117 != magic) {
                    logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "readFrom", "Magic number was: " + Integer.toHexString(0xFFFF & magic) + " expected 0x5A4D");
                }
            }
            catch (MemoryFault e1) {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "readFrom", "MemoryFault reading magic number", e1);
            }
            long e_lfanewAddress = imageBaseAddress + 60L;
            LinkedList<IMemoryRange> sections = new LinkedList<IMemoryRange>();
            try {
                long e_lfanew = 0xFFFFFFFFL & (long)as.getIntAt(e_lfanewAddress);
                long readingAddress = e_lfanew + imageBaseAddress;
                List<Object> symbols = null;
                if (0L != e_lfanew) {
                    this.loadModuleSections(as, imageBaseAddress, readingAddress, e_lfanew, sections);
                    symbols = this.buildSymbols(dump, as, imageBaseAddress);
                }
                if (symbols == null) {
                    symbols = new LinkedList();
                }
                List<RuntimeFunction> runtimeFunctionList = null;
                runtimeFunctionList = this.buildRuntimeFunctionList(dump, as, imageBaseAddress);
                Module module = runtimeFunctionList != null ? new UnwindModule(as.getProcesses().iterator().next(), moduleName, symbols, sections, thisModule.imageBaseAddress, properties, runtimeFunctionList) : new Module(as.getProcesses().iterator().next(), moduleName, symbols, sections, thisModule.imageBaseAddress, properties);
                if (moduleName.toLowerCase().endsWith(".exe")) {
                    dump.setExecutable(module);
                    continue;
                }
                dump.addLibrary(module);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "readFrom", "Problem reading symbols", e);
            }
        }
    }

    private void loadModuleSections(IAddressSpace as, long imageBaseAddress, long readingAddress, long e_lfanew, Collection<IMemoryRange> sections) throws MemoryFault {
        int pemagic = as.getIntAt(readingAddress);
        readingAddress += 4L;
        if (17744 != pemagic) {
            logger.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.minidump.ModuleStream", "loadModuleSections", "PE Magic is: \"" + Integer.toHexString(pemagic));
        }
        int numberOfSections = as.getShortAt(readingAddress += 2L);
        readingAddress += 2L;
        readingAddress += 4L;
        readingAddress += 4L;
        short sizeOfOptionalHeader = as.getShortAt(readingAddress += 4L);
        readingAddress += 2L;
        readingAddress += 2L;
        readingAddress = imageBaseAddress + e_lfanew + 24L + (0xFFFFL & (long)sizeOfOptionalHeader);
        for (int j = 0; j < numberOfSections; ++j) {
            String name;
            byte[] rawName = new byte[8];
            as.getBytesAt(readingAddress, rawName);
            long virtualSize = as.getIntAt(readingAddress += 8L);
            long virtualAddress = as.getIntAt(readingAddress += 4L);
            readingAddress += 4L;
            readingAddress += 4L;
            readingAddress += 4L;
            readingAddress += 4L;
            readingAddress += 4L;
            readingAddress += 2L;
            readingAddress += 2L;
            readingAddress += 4L;
            long relocatedAddress = virtualAddress + imageBaseAddress;
            try {
                name = new String(rawName, "ASCII");
                name = name.trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            MemoryRange section = new MemoryRange(as, relocatedAddress, virtualSize, name);
            sections.add(section);
        }
    }

    private Properties readProperties(MiniDumpReader dump, int imageSize, int checksum, int timeDateStamp) throws IOException {
        int versionInfoDwSignature = dump.readInt();
        int versionInfoDwStrucVersion = dump.readInt();
        int versionInfoDwFileVersionMS = dump.readInt();
        int versionInfoDwFileVersionLS = dump.readInt();
        int versionInfoDwProductVersionMS = dump.readInt();
        int versionInfoDwProductVersionLS = dump.readInt();
        int versionInfoDwFileFlagsMask = dump.readInt();
        int versionInfoDwFileFlags = dump.readInt();
        int versionInfoDwFileOS = dump.readInt();
        int versionInfoDwFileType = dump.readInt();
        int versionInfoDwFileSubtype = dump.readInt();
        int versionInfoDwFileDateMS = dump.readInt();
        int versionInfoDwFileDateLS = dump.readInt();
        dump.readInt();
        dump.readInt();
        dump.readInt();
        dump.readInt();
        dump.readLong();
        dump.readLong();
        Properties properties = new Properties();
        properties.setProperty("imageSize", Integer.toHexString(imageSize));
        properties.setProperty("checksum", Integer.toHexString(checksum));
        properties.setProperty("timeDateStamp", new Date(1000L * ((long)timeDateStamp + 28800L)).toString());
        properties.setProperty("versionInfoDwSignature", Integer.toHexString(versionInfoDwSignature));
        properties.setProperty("versionInfoDwStrucVersion", Integer.toHexString(versionInfoDwStrucVersion));
        properties.setProperty("versionInfoDwFileVersionMS", Integer.toHexString(versionInfoDwFileVersionMS));
        properties.setProperty("versionInfoDwFileVersionLS", Integer.toHexString(versionInfoDwFileVersionLS));
        properties.setProperty("versionInfoDwProductVersionMS", Integer.toHexString(versionInfoDwProductVersionMS));
        properties.setProperty("versionInfoDwProductVersionLS", Integer.toHexString(versionInfoDwProductVersionLS));
        properties.setProperty("versionInfoDwFileFlagsMask", Integer.toHexString(versionInfoDwFileFlagsMask));
        properties.setProperty("versionInfoDwFileFlags", Integer.toHexString(versionInfoDwFileFlags));
        properties.setProperty("versionInfoDwFileOS", Integer.toHexString(versionInfoDwFileOS));
        properties.setProperty("versionInfoDwFileType", Integer.toHexString(versionInfoDwFileType));
        properties.setProperty("versionInfoDwFileSubtype", Integer.toHexString(versionInfoDwFileSubtype));
        properties.setProperty("versionInfoDwFileDateMS", Integer.toHexString(versionInfoDwFileDateMS));
        properties.setProperty("versionInfoDwFileDateLS", Integer.toHexString(versionInfoDwFileDateLS));
        return properties;
    }

    private List<ISymbol> buildSymbols(MiniDumpReader dump, IAddressSpace as, long imageBase) throws CorruptDataException, CorruptCoreException {
        short magicShort;
        long moduleLoadAddress = imageBase;
        byte[] magic = new byte[2];
        as.getBytesAt(imageBase, magic);
        String magicStr = null;
        try {
            magicStr = new String(magic, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (!magicStr.equals("MZ")) {
            throw new CorruptCoreException("Invalid image magic number: \"" + magicStr + "\" @ " + Long.toHexString(imageBase));
        }
        int peInt = as.getIntAt(imageBase + 60L);
        long peBase = ((long)peInt & 0xFFFFFFFFL) + imageBase;
        as.getBytesAt(peBase, magic);
        try {
            magicStr = new String(magic, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (!magicStr.equals("PE")) {
            throw new CorruptCoreException("Invalid PE magic number: \"" + magicStr + "\" @ " + Long.toHexString(peBase));
        }
        long nextRead = peBase + 4L;
        nextRead += 2L;
        nextRead += 2L;
        nextRead += 4L;
        nextRead += 4L;
        long imageOptionalHeaderSizeAddress = nextRead += 4L;
        short optionalHeaderSize = as.getShortAt(imageOptionalHeaderSizeAddress);
        nextRead += 2L;
        nextRead += 2L;
        if (224 == optionalHeaderSize) {
            magicShort = as.getShortAt(nextRead);
            if (267 != magicShort) {
                throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER magic number: \"0x" + Integer.toHexString(0xFFFF & magicShort) + "\" @ " + Long.toHexString(nextRead));
            }
            nextRead += 2L;
            ++nextRead;
            ++nextRead;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
        } else if (240 == optionalHeaderSize) {
            magicShort = as.getShortAt(nextRead);
            if (523 != magicShort) {
                throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER64 magic number: \"0x" + Integer.toHexString(0xFFFF & magicShort) + "\" @ " + Long.toHexString(nextRead));
            }
            nextRead += 2L;
            ++nextRead;
            ++nextRead;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 8L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 8L;
            nextRead += 8L;
            nextRead += 8L;
            nextRead += 8L;
            nextRead += 4L;
            nextRead += 4L;
        } else {
            throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER size: \"" + optionalHeaderSize + "\" bytes @ " + Long.toHexString(imageOptionalHeaderSizeAddress));
        }
        int exportRVA = as.getIntAt(nextRead);
        nextRead += 4L;
        if (0 == exportRVA) {
            return Collections.emptyList();
        }
        nextRead += 4L;
        nextRead = moduleLoadAddress + ((long)exportRVA & 0xFFFFFFFFL);
        nextRead += 4L;
        nextRead += 4L;
        nextRead += 2L;
        nextRead += 2L;
        nextRead += 4L;
        long numberOfFunctionsAddress = nextRead += 4L;
        int numberOfFunctions = as.getIntAt(numberOfFunctionsAddress);
        int numberOfNames = as.getIntAt(nextRead += 4L);
        nextRead += 4L;
        if (numberOfFunctions < numberOfNames) {
            throw new CorruptCoreException("IMAGE_EXPORT_DIRECTORY NumberOfFunctions (" + numberOfFunctions + ") < NumberOfNames (" + numberOfNames + ") @ " + Long.toHexString(numberOfFunctionsAddress));
        }
        long funcAddress = (long)as.getIntAt(nextRead) & 0xFFFFFFFFL;
        long nameAddress = (long)as.getIntAt(nextRead += 4L) & 0xFFFFFFFFL;
        long ordinalAddress = (long)as.getIntAt(nextRead += 4L) & 0xFFFFFFFFL;
        nextRead += 4L;
        int[] nameAddresses = new int[numberOfNames];
        nextRead = nameAddress + moduleLoadAddress;
        for (int x = 0; x < numberOfNames; ++x) {
            nameAddresses[x] = as.getIntAt(nextRead);
            nextRead += 4L;
        }
        long[] addresses = new long[numberOfFunctions];
        nextRead = funcAddress + moduleLoadAddress;
        for (int x = 0; x < numberOfFunctions; ++x) {
            addresses[x] = as.getIntAt(nextRead);
            nextRead += 4L;
        }
        short[] ordinals = new short[numberOfNames];
        nextRead = ordinalAddress + moduleLoadAddress;
        for (int x = 0; x < numberOfNames; ++x) {
            ordinals[x] = as.getShortAt(nextRead);
            nextRead += 2L;
        }
        String[] names = new String[numberOfNames];
        byte[] buffer = new byte[2048];
        for (int x = 0; x < numberOfNames; ++x) {
            nextRead = ((long)nameAddresses[x] & 0xFFFFFFFFL) + moduleLoadAddress;
            Arrays.fill(buffer, (byte)0);
            int index = 0;
            byte thisByte = 0;
            do {
                thisByte = as.getByteAt(nextRead);
                ++nextRead;
                buffer[index] = thisByte;
            } while (0 != thisByte && ++index < buffer.length);
            try {
                names[x] = new String(buffer, 0, index - 1, "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>(numberOfNames);
        for (int x = 0; x < numberOfNames; ++x) {
            short index = ordinals[x];
            long relocatedFunctionAddress = addresses[index] + moduleLoadAddress;
            String functionName = names[x];
            Symbol symbol = new Symbol(functionName, relocatedFunctionAddress);
            symbols.add(symbol);
        }
        return symbols;
    }

    private List<RuntimeFunction> buildRuntimeFunctionList(MiniDumpReader dump, IAddressSpace as, long imageBase) throws CorruptDataException, CorruptCoreException {
        long moduleLoadAddress = imageBase;
        byte[] magic = new byte[2];
        as.getBytesAt(imageBase, magic);
        String magicStr = null;
        try {
            magicStr = new String(magic, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new CorruptCoreException("Unable to decode magic number");
        }
        if (!magicStr.equals("MZ")) {
            throw new CorruptCoreException("Invalid image magic number: \"" + magicStr + "\" @ " + Long.toHexString(imageBase));
        }
        int peInt = as.getIntAt(imageBase + 60L);
        long peBase = ((long)peInt & 0xFFFFFFFFL) + imageBase;
        as.getBytesAt(peBase, magic);
        try {
            magicStr = new String(magic, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (!magicStr.equals("PE")) {
            throw new CorruptCoreException("Invalid PE magic number: \"" + magicStr + "\" @ " + Long.toHexString(peBase));
        }
        long nextRead = peBase + 4L;
        nextRead += 2L;
        nextRead += 2L;
        nextRead += 4L;
        nextRead += 4L;
        long imageOptionalHeaderSizeAddress = nextRead += 4L;
        short optionalHeaderSize = as.getShortAt(imageOptionalHeaderSizeAddress);
        nextRead += 2L;
        nextRead += 2L;
        if (224 == optionalHeaderSize) {
            return null;
        }
        if (240 == optionalHeaderSize) {
            short magicShort = as.getShortAt(nextRead);
            if (523 != magicShort) {
                throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER64 magic number: \"0x" + Integer.toHexString(0xFFFF & magicShort) + "\" @ " + Long.toHexString(nextRead));
            }
            nextRead += 2L;
            ++nextRead;
            ++nextRead;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 8L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 4L;
            nextRead += 2L;
            nextRead += 2L;
            nextRead += 8L;
            nextRead += 8L;
            nextRead += 8L;
            nextRead += 8L;
            nextRead += 4L;
            nextRead += 4L;
        } else {
            throw new CorruptCoreException("Invalid IMAGE_OPTIONAL_HEADER size: \"" + optionalHeaderSize + "\" bytes @ " + Long.toHexString(imageOptionalHeaderSizeAddress));
        }
        int IMAGE_DIRECTORY_ENTRY_EXCEPTION = 3;
        for (int i = 0; i < IMAGE_DIRECTORY_ENTRY_EXCEPTION; ++i) {
            nextRead += 4L;
            nextRead += 4L;
        }
        int exceptionRVA = as.getIntAt(nextRead);
        int exceptionSize = as.getIntAt(nextRead);
        int entryCount = exceptionSize / 12;
        nextRead = moduleLoadAddress + ((long)exceptionRVA & 0xFFFFFFFFL);
        LinkedList<RuntimeFunction> rfList = new LinkedList<RuntimeFunction>();
        for (int i = 0; i < entryCount; ++i) {
            int start = as.getIntAt(nextRead);
            nextRead += 4L;
            if (start == 0) break;
            int end = as.getIntAt(nextRead);
            int unwindAddress = as.getIntAt(nextRead += 4L);
            nextRead += 4L;
            RuntimeFunction rf = new RuntimeFunction(start, end, unwindAddress);
            rfList.add(rf);
        }
        return rfList;
    }
}

