/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.DelegatingMemorySource;
import com.ibm.j9ddr.corereaders.memory.IDetailedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemorySourceTable;
import com.ibm.j9ddr.corereaders.memory.SearchableMemory;
import com.ibm.j9ddr.util.WeakValueMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMemory
extends SearchableMemory
implements IMemory {
    static final Logger logger;
    private static final long MAXIMUM_CORE_FILE_CACHE_BYTES;
    private static final long DEFAULT_MAX_CORE_FILE_CACHE_BYTES = 0xA00000L;
    private static final String MAX_CORE_FILE_CACHE_SIZE_SYSTEM_PROPERTY = "ddr.max.core.data.cache.bytes";
    private static final String ENABLE_CACHE_STATS_SYSTEM_PROPERTY = "ddr.track.core.cache.stats";
    private static final long CACHE_BLOCK_SIZE = 1024L;
    private static final boolean GLOBAL_CACHE_ENABLED;
    static final boolean RECORDING_CACHE_STATS;
    private static long cacheHits;
    private static long cacheMisses;
    private static long bytesReadFromDisk;
    private static long bytesReadFromBlockCache;
    private static long purgedBlocks;
    private static long purgedBytes;
    private static long cacheByteHighWaterMark;
    private static final List<CacheBlock> keepAliveList;
    private static long cacheSize;
    private final ByteOrder byteOrder;
    protected final MemorySourceTable memorySources = new MemorySourceTable();
    protected final Map<IMemorySource, IMemorySource> decoratorMappingTable = new TreeMap<IMemorySource, IMemorySource>();

    protected AbstractMemory(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public byte getByteAt(long address) throws MemoryFault {
        byte[] buffer = new byte[1];
        this.getBytesAt(address, buffer);
        return buffer[0];
    }

    @Override
    public int getBytesAt(long address, byte[] buffer) throws MemoryFault {
        return this.getBytesAt(address, buffer, 0, buffer.length);
    }

    @Override
    public int getBytesAt(long address, byte[] buffer, int offset, int length) throws MemoryFault {
        IMemorySource range = this.memorySources.getRangeForAddress(address);
        int read = 0;
        if (range == null) {
            throw new MemoryFault(address);
        }
        long maxAddress = address + (long)length - 1L;
        if (range.contains(maxAddress)) {
            read = range.getBytes(address, buffer, offset, length);
        } else {
            int index = offset;
            long addressPointer = address;
            while (Addresses.lessThanOrEqual(addressPointer, maxAddress) && (range.contains(addressPointer) || null != (range = this.memorySources.getRangeForAddress(addressPointer)))) {
                long topAddress = range.getTopAddress();
                long toRead = Addresses.greaterThan(topAddress, maxAddress) ? maxAddress - addressPointer + 1L : topAddress - addressPointer + 1L;
                int readThisTime = range.getBytes(addressPointer, buffer, index, (int)toRead);
                read += readThisTime;
                addressPointer += (long)readThisTime;
                index += readThisTime;
            }
        }
        return read;
    }

    @Override
    public int getIntAt(long address) throws MemoryFault {
        byte[] buffer = new byte[4];
        this.getBytesAt(address, buffer);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (0xFF & buffer[3]) << 24 | (0xFF & buffer[2]) << 16 | (0xFF & buffer[1]) << 8 | 0xFF & buffer[0];
        }
        return (0xFF & buffer[0]) << 24 | (0xFF & buffer[1]) << 16 | (0xFF & buffer[2]) << 8 | 0xFF & buffer[3];
    }

    @Override
    public long getLongAt(long address) throws MemoryFault {
        byte[] buffer = new byte[8];
        this.getBytesAt(address, buffer);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return 0xFF00000000000000L & (long)buffer[7] << 56 | 0xFF000000000000L & (long)buffer[6] << 48 | 0xFF0000000000L & (long)buffer[5] << 40 | 0xFF00000000L & (long)buffer[4] << 32 | 0xFF000000L & (long)buffer[3] << 24 | 0xFF0000L & (long)buffer[2] << 16 | 0xFF00L & (long)buffer[1] << 8 | 0xFFL & (long)buffer[0];
        }
        return 0xFF00000000000000L & (long)buffer[0] << 56 | 0xFF000000000000L & (long)buffer[1] << 48 | 0xFF0000000000L & (long)buffer[2] << 40 | 0xFF00000000L & (long)buffer[3] << 32 | 0xFF000000L & (long)buffer[4] << 24 | 0xFF0000L & (long)buffer[5] << 16 | 0xFF00L & (long)buffer[6] << 8 | 0xFFL & (long)buffer[7];
    }

    @Override
    public short getShortAt(long address) throws MemoryFault {
        byte[] buffer = new byte[2];
        this.getBytesAt(address, buffer);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (short)((0xFF & buffer[1]) << 8 | 0xFF & buffer[0]);
        }
        return (short)((0xFF & buffer[0]) << 8 | 0xFF & buffer[1]);
    }

    public void addMemorySource(IMemorySource source) {
        logger.logp(Level.FINEST, "AbstractMemory", "addMemorySource", "Added memory range {0}-{1}", new Object[]{Long.toHexString(source.getBaseAddress()), Long.toHexString(source.getTopAddress())});
        if (GLOBAL_CACHE_ENABLED) {
            CachingMemorySource wrappedSource = new CachingMemorySource(source);
            this.decoratorMappingTable.put(source, wrappedSource);
            this.memorySources.addMemorySource(wrappedSource);
        } else if (RECORDING_CACHE_STATS) {
            CountingMemorySource wrappedSource = new CountingMemorySource(source);
            this.decoratorMappingTable.put(source, wrappedSource);
            this.memorySources.addMemorySource(wrappedSource);
        } else {
            this.memorySources.addMemorySource(source);
        }
        this.rangeTable = null;
    }

    public void removeMemorySource(IMemorySource source) {
        IMemorySource wrappedSource = this.decoratorMappingTable.remove(source);
        if (wrappedSource != null) {
            this.memorySources.removeMemorySource(wrappedSource);
        } else {
            this.memorySources.removeMemorySource(source);
        }
        this.rangeTable = null;
    }

    public void addMemorySources(Collection<? extends IMemorySource> memorySources) {
        for (IMemorySource iMemorySource : memorySources) {
            this.addMemorySource(iMemorySource);
        }
    }

    public List<IMemoryRange> getMemoryRanges() {
        return this.memorySources.getMemorySources();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public boolean isShared(long address) {
        IMemorySource match = this.memorySources.getRangeForAddress(address);
        if (match == null) {
            return false;
        }
        return match.isShared();
    }

    @Override
    public boolean isExecutable(long address) {
        IMemorySource match = this.memorySources.getRangeForAddress(address);
        if (match == null) {
            return false;
        }
        return match.isExecutable();
    }

    @Override
    public boolean isReadOnly(long address) {
        IMemorySource match = this.memorySources.getRangeForAddress(address);
        if (match == null) {
            return false;
        }
        return match.isReadOnly();
    }

    @Override
    public Properties getProperties(long address) {
        IMemorySource match = this.memorySources.getRangeForAddress(address);
        if (match != null && match instanceof IDetailedMemoryRange) {
            return ((IDetailedMemoryRange)((Object)match)).getProperties();
        }
        return new Properties();
    }

    static {
        long size;
        logger = Logger.getLogger("j9ddr.core_readers");
        cacheHits = 0L;
        cacheMisses = 0L;
        bytesReadFromDisk = 0L;
        bytesReadFromBlockCache = 0L;
        purgedBlocks = 0L;
        purgedBytes = 0L;
        cacheByteHighWaterMark = 0L;
        keepAliveList = new ArrayList<CacheBlock>();
        cacheSize = 0L;
        String maxCoreFileCacheSize = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(AbstractMemory.MAX_CORE_FILE_CACHE_SIZE_SYSTEM_PROPERTY);
            }
        });
        logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "System property value from {0} was {1}", new Object[]{MAX_CORE_FILE_CACHE_SIZE_SYSTEM_PROPERTY, maxCoreFileCacheSize});
        if (maxCoreFileCacheSize != null) {
            size = Long.parseLong(maxCoreFileCacheSize);
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Max core memory cache size parsed as {0}", size);
        } else {
            size = 0xA00000L;
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Max core memory cache set to default: {0}", size);
        }
        MAXIMUM_CORE_FILE_CACHE_BYTES = size;
        if (size <= 0L) {
            GLOBAL_CACHE_ENABLED = false;
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Disabled core memory caching");
        } else {
            GLOBAL_CACHE_ENABLED = true;
        }
        String enableCacheStats = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(AbstractMemory.ENABLE_CACHE_STATS_SYSTEM_PROPERTY);
            }
        });
        if (enableCacheStats != null && enableCacheStats.toLowerCase().equals("true")) {
            Runtime.getRuntime().addShutdownHook(new Thread(new CacheStatsReporter()));
            RECORDING_CACHE_STATS = true;
            logger.logp(Level.FINE, "AbstractMemory", "<clinit>", "Cache stats enabled");
        } else {
            RECORDING_CACHE_STATS = false;
        }
    }

    static class CacheBlock {
        public final byte[] buffer;

        public CacheBlock(byte[] buffer) {
            this.buffer = buffer;
        }
    }

    private static class CacheStatsReporter
    implements Runnable {
        private CacheStatsReporter() {
        }

        public void run() {
            System.err.println("**DDR Core Reader Cache Stats**");
            System.err.println("Global cache enabled: " + GLOBAL_CACHE_ENABLED);
            System.err.println("Cache hits: " + cacheHits);
            System.err.println("Cache misses: " + cacheMisses);
            double cacheHitRate = (double)cacheHits / (double)(cacheHits + cacheMisses) * 100.0;
            System.err.println("Cache hit rate: " + cacheHitRate);
            System.err.println("Bytes read from disk: " + bytesReadFromDisk);
            System.err.println("Bytes read from cache: " + bytesReadFromBlockCache);
            System.err.println("Purged blocks: " + purgedBlocks);
            System.err.println("Purged bytes: " + purgedBytes);
            System.err.println("Cache bytes high water mark: " + cacheByteHighWaterMark);
            System.err.println("TLB Cache hits: " + MemorySourceTable.tlbCacheHits);
            System.err.println("TLB Cache misses: " + MemorySourceTable.tlbCacheMisses);
            double tlbHitRate = (double)MemorySourceTable.tlbCacheHits / (double)(MemorySourceTable.tlbCacheHits + MemorySourceTable.tlbCacheMisses) * 100.0;
            System.err.println("TLB Cache hit rate: " + tlbHitRate);
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "DDR Core Reader Cache Stats");
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Global cache enabled: {0}", GLOBAL_CACHE_ENABLED);
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Cache hits: {0}, cache misses: {1}, cache hit rate: {2}", new Object[]{cacheHits, cacheMisses, cacheHitRate});
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Bytes read from disk: {0}, from cache: {1}, purged blocks: {2}, purged bytes: {3}", new Object[]{bytesReadFromDisk, bytesReadFromBlockCache, purgedBlocks, purgedBytes});
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "Cache bytes high water mark {0}", new Object[]{cacheByteHighWaterMark});
            logger.logp(Level.FINE, "AbstractMemory", "CacheStatsReporter", "TLB Cache hits: {0}, misses: {1}, hit rate:{2}", new Object[]{MemorySourceTable.tlbCacheHits, MemorySourceTable.tlbCacheMisses, tlbHitRate});
        }
    }

    private static final class CachingMemorySource
    extends DelegatingMemorySource {
        private final boolean singleBlockRange;
        private final WeakValueMap<Integer, CacheBlock> blockMap;
        private Reference<CacheBlock> singleBlockRef;

        public CachingMemorySource(IMemorySource source) {
            super(source);
            if (this.delegate.getSize() <= 1024L) {
                this.singleBlockRange = true;
                this.blockMap = null;
            } else {
                this.singleBlockRange = false;
                this.blockMap = new WeakValueMap();
            }
        }

        public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
            int toRead;
            if (this.singleBlockRange) {
                CacheBlock block;
                boolean cacheHit = false;
                if (this.singleBlockRef == null || (block = this.singleBlockRef.get()) == null) {
                    if (RECORDING_CACHE_STATS) {
                        cacheHit = true;
                    }
                    block = this.loadBlock(this.getBaseAddress(), address, (int)this.getSize());
                    this.singleBlockRef = new WeakReference<CacheBlock>(block);
                } else if (RECORDING_CACHE_STATS) {
                    cacheHit = false;
                }
                System.arraycopy(block.buffer, (int)(address - this.delegate.getBaseAddress()), buffer, offset, length);
                if (RECORDING_CACHE_STATS) {
                    if (cacheHit) {
                        cacheHits++;
                        bytesReadFromBlockCache += length;
                    } else {
                        cacheMisses++;
                    }
                }
                return length;
            }
            int read = 0;
            int destIndex = offset;
            while ((toRead = length - read) > 0) {
                long offsetInBlock;
                long remainingInBlock;
                long rangeOffset = address - this.getBaseAddress();
                int blockIndex = (int)(rangeOffset / 1024L);
                long blockBase = this.delegate.getBaseAddress() + 1024L * (long)blockIndex;
                long sizeToEndOfRange = this.delegate.getTopAddress() - blockBase + 1L;
                int blockSize = (int)(sizeToEndOfRange > 1024L ? 1024L : sizeToEndOfRange);
                boolean cacheHit = false;
                CacheBlock block = this.blockMap.get(blockIndex);
                if (RECORDING_CACHE_STATS) {
                    boolean bl = cacheHit = block != null;
                }
                if (block == null) {
                    block = this.loadBlock(blockBase, address, blockSize);
                    this.blockMap.put(blockIndex, block);
                }
                long amountToReadInBlock = (remainingInBlock = (long)blockSize - (offsetInBlock = address - blockBase)) > (long)toRead ? (long)toRead : remainingInBlock;
                System.arraycopy(block.buffer, (int)offsetInBlock, buffer, destIndex, (int)amountToReadInBlock);
                if (RECORDING_CACHE_STATS) {
                    if (cacheHit) {
                        cacheHits++;
                        bytesReadFromBlockCache += amountToReadInBlock;
                    } else {
                        cacheMisses++;
                    }
                }
                address += amountToReadInBlock;
                read = (int)((long)read + amountToReadInBlock);
                destIndex = (int)((long)destIndex + amountToReadInBlock);
            }
            return read;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CacheBlock loadBlock(long blockBaseAddress, long actualAddress, int blockSize) throws MemoryFault {
            byte[] buffer = new byte[blockSize];
            if (this.delegate.isBacked()) {
                try {
                    this.delegate.getBytes(blockBaseAddress, buffer, 0, blockSize);
                }
                catch (MemoryFault e) {
                    throw new MemoryFault(actualAddress, "MemoryFault loading cache block", e);
                }
            } else {
                throw new MemoryFault(actualAddress, "MemoryFault loading cache block, unbacked memory");
            }
            if (RECORDING_CACHE_STATS) {
                bytesReadFromDisk += blockSize;
            }
            CacheBlock block = new CacheBlock(buffer);
            List list = keepAliveList;
            synchronized (list) {
                cacheSize += blockSize;
                if (cacheSize > MAXIMUM_CORE_FILE_CACHE_BYTES) {
                    CachingMemorySource.trimCache();
                }
                if (RECORDING_CACHE_STATS && cacheSize > cacheByteHighWaterMark) {
                    cacheByteHighWaterMark = cacheSize;
                }
                keepAliveList.add(block);
            }
            return block;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void trimCache() {
            List list = keepAliveList;
            synchronized (list) {
                while (cacheSize > MAXIMUM_CORE_FILE_CACHE_BYTES && keepAliveList.size() > 0) {
                    CacheBlock block = (CacheBlock)keepAliveList.remove(0);
                    cacheSize -= block.buffer.length;
                    if (!RECORDING_CACHE_STATS) continue;
                    purgedBlocks++;
                    purgedBytes += block.buffer.length;
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.blockMap == null ? 0 : this.blockMap.hashCode());
            result = 31 * result + (this.singleBlockRange ? 1231 : 1237);
            result = 31 * result + (this.singleBlockRef == null ? 0 : this.singleBlockRef.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof CachingMemorySource)) {
                return false;
            }
            CachingMemorySource other = (CachingMemorySource)obj;
            if (this.blockMap == null ? other.blockMap != null : !this.blockMap.equals(other.blockMap)) {
                return false;
            }
            if (this.singleBlockRange != other.singleBlockRange) {
                return false;
            }
            return !(this.singleBlockRef == null ? other.singleBlockRef != null : !this.singleBlockRef.equals(other.singleBlockRef));
        }
    }

    private static class CountingMemorySource
    extends DelegatingMemorySource {
        public CountingMemorySource(IMemorySource source) {
            super(source);
        }

        public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
            int read = super.getBytes(address, buffer, offset, length);
            cacheMisses++;
            bytesReadFromDisk += read;
            return read;
        }
    }
}

