/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureTypeManager {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_VOID = 0;
    public static final int TYPE_U8 = 1;
    public static final int TYPE_U16 = 2;
    public static final int TYPE_U32 = 3;
    public static final int TYPE_U64 = 4;
    public static final int TYPE_UDATA = 5;
    public static final int TYPE_I8 = 6;
    public static final int TYPE_I16 = 7;
    public static final int TYPE_I32 = 8;
    public static final int TYPE_I64 = 9;
    public static final int TYPE_IDATA = 10;
    public static final int TYPE_SIMPLE_MIN = 1;
    public static final int TYPE_SIMPLE_MAX = 99;
    public static final int TYPE_BOOL = 100;
    public static final int TYPE_ENUM = 101;
    public static final int TYPE_DOUBLE = 102;
    public static final int TYPE_FLOAT = 103;
    public static final int TYPE_BITFIELD = 104;
    public static final int TYPE_ENUM_POINTER = 105;
    public static final int TYPE_POINTER = 110;
    public static final int TYPE_J9SRP = 111;
    public static final int TYPE_J9WSRP = 112;
    public static final int TYPE_ARRAY = 113;
    public static final int TYPE_J9SRP_POINTER = 114;
    public static final int TYPE_J9WSRP_POINTER = 115;
    public static final int TYPE_STRUCTURE = 120;
    public static final int TYPE_STRUCTURE_POINTER = 121;
    public static final int TYPE_FJ9OBJECT = 130;
    public static final int TYPE_FJ9OBJECT_POINTER = 131;
    public static final int TYPE_J9OBJECTCLASS = 132;
    public static final int TYPE_J9OBJECTCLASS_POINTER = 133;
    public static final int TYPE_J9OBJECTMONITOR = 134;
    public static final int TYPE_J9OBJECTMONITOR_POINTER = 135;
    public static final int TYPE_ADDRESS = 136;
    public static final int TYPE_ADDRESS_POINTER = 137;
    public static final Map<String, Integer> simpleTypeCodeMap;
    public static final Map<Integer, String> simpleTypeAccessorMap;
    private final Set<String> structureNames = new HashSet<String>();
    private final Set<String> enumNames = new HashSet<String>();

    public StructureTypeManager(Collection<StructureReader.StructureDescriptor> structures) {
        for (StructureReader.StructureDescriptor structure : structures) {
            if (structure.getFields().size() == 0 && structure.getConstants().size() > 0) {
                this.enumNames.add(structure.getName());
                continue;
            }
            this.structureNames.add(structure.getName());
        }
    }

    public int getType(String type) {
        CTypeParser parser = CTypeParser.fromNative(type);
        if (type.startsWith("const ")) {
            return this.getType(type.substring("const ".length()).trim());
        }
        if (type.startsWith("volatile ")) {
            return this.getType(type.substring("volatile ".length()).trim());
        }
        if (simpleTypeCodeMap.containsKey(type)) {
            return simpleTypeCodeMap.get(type);
        }
        if (type.equals("bool")) {
            return 100;
        }
        if (type.equals("double")) {
            return 102;
        }
        if (type.equals("float")) {
            return 103;
        }
        if (type.equals("fj9object_t")) {
            return 130;
        }
        if (type.equals("j9objectclass_t")) {
            return 132;
        }
        if (type.equals("j9objectmonitor_t")) {
            return 134;
        }
        if (type.equals("iconv_t")) {
            return 10;
        }
        if (parser.getSuffix().endsWith("]")) {
            return 113;
        }
        if (parser.getSuffix().contains(":")) {
            return 104;
        }
        if (type.indexOf(42) != type.lastIndexOf(42)) {
            return 110;
        }
        if (type.endsWith("*")) {
            int pointerType = this.getType(parser.getBlobType());
            if (-1 == pointerType) {
                return -1;
            }
            switch (pointerType) {
                case 120: {
                    return 121;
                }
                case 130: {
                    return 131;
                }
                case 132: {
                    return 133;
                }
                case 134: {
                    return 135;
                }
                case 111: {
                    return 114;
                }
                case 112: {
                    return 115;
                }
                case 101: {
                    return 105;
                }
                case 136: {
                    return 110;
                }
            }
            return 110;
        }
        if (type.startsWith("J9SRP")) {
            return 111;
        }
        if (type.startsWith("J9WSRP")) {
            return 112;
        }
        if (type.startsWith("struct ") || type.startsWith("class ")) {
            return 120;
        }
        if (this.structureNames.contains(parser.getBlobType().trim())) {
            return 120;
        }
        if (type.startsWith("enum")) {
            return 101;
        }
        if (this.enumNames.contains(parser.getBlobType())) {
            return 101;
        }
        if (type.equals("Address")) {
            return 136;
        }
        return -1;
    }

    static {
        HashMap<String, Integer> localSimpleTypeCodeMap = new HashMap<String, Integer>();
        localSimpleTypeCodeMap.put("void", 0);
        localSimpleTypeCodeMap.put("U8", 1);
        localSimpleTypeCodeMap.put("Address", 136);
        localSimpleTypeCodeMap.put("U16", 2);
        localSimpleTypeCodeMap.put("U32", 3);
        localSimpleTypeCodeMap.put("U64", 4);
        localSimpleTypeCodeMap.put("UDATA", 5);
        localSimpleTypeCodeMap.put("I8", 6);
        localSimpleTypeCodeMap.put("I16", 7);
        localSimpleTypeCodeMap.put("I32", 8);
        localSimpleTypeCodeMap.put("I64", 9);
        localSimpleTypeCodeMap.put("IDATA", 10);
        localSimpleTypeCodeMap.put("int", 10);
        localSimpleTypeCodeMap.put("char", 1);
        simpleTypeCodeMap = Collections.unmodifiableMap(localSimpleTypeCodeMap);
        HashMap<Integer, String> localSimpleTypeAccessorMap = new HashMap<Integer, String>();
        localSimpleTypeAccessorMap.put(1, "getByteAtOffset");
        localSimpleTypeAccessorMap.put(2, "getShortAtOffset");
        localSimpleTypeAccessorMap.put(3, "getIntAtOffset");
        localSimpleTypeAccessorMap.put(4, "getLongAtOffset");
        localSimpleTypeAccessorMap.put(5, "getUDATAAtOffset");
        localSimpleTypeAccessorMap.put(6, "getByteAtOffset");
        localSimpleTypeAccessorMap.put(7, "getShortAtOffset");
        localSimpleTypeAccessorMap.put(8, "getIntAtOffset");
        localSimpleTypeAccessorMap.put(9, "getLongAtOffset");
        localSimpleTypeAccessorMap.put(10, "getIDATAAtOffset");
        localSimpleTypeAccessorMap.put(136, "getPointerAtOffset");
        simpleTypeAccessorMap = Collections.unmodifiableMap(localSimpleTypeAccessorMap);
    }
}

