/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl.util;

import com.ibm.misc.HexDumpEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;

public abstract class AbstractSaslImpl {
    protected static Logger logger;
    protected boolean completed = false;
    protected boolean privacy = false;
    protected boolean integrity = false;
    protected byte[] qop;
    protected byte allQop;
    protected byte[] strength;
    protected int sendMaxBufSize = 0;
    protected int recvMaxBufSize = 65536;
    protected int rawSendSize;
    protected String myClassName;
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    protected static final String MAX_SEND_BUF = "javax.security.sasl.sendmaxbuffer";
    protected static final byte NO_PROTECTION = 1;
    protected static final byte INTEGRITY_ONLY_PROTECTION = 2;
    protected static final byte PRIVACY_PROTECTION = 4;
    protected static final byte LOW_STRENGTH = 1;
    protected static final byte MEDIUM_STRENGTH = 2;
    protected static final byte HIGH_STRENGTH = 4;
    private static final byte[] DEFAULT_QOP;
    private static final String[] QOP_TOKENS;
    private static final byte[] QOP_MASKS;
    private static final byte[] DEFAULT_STRENGTH;
    private static final String[] STRENGTH_TOKENS;
    private static final byte[] STRENGTH_MASKS;

    protected AbstractSaslImpl(Map props, String className) throws SaslException {
        AbstractSaslImpl.initLogger();
        this.myClassName = className;
        if (props != null) {
            int i;
            String prop = (String)props.get("javax.security.sasl.qop");
            this.qop = AbstractSaslImpl.parseQop(prop);
            logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL01:Preferred qop property: {0}", prop);
            this.allQop = AbstractSaslImpl.combineMasks(this.qop);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL02:Preferred qop mask: {0}", new Byte(this.allQop));
                if (this.qop.length > 0) {
                    StringBuffer qopbuf = new StringBuffer();
                    for (i = 0; i < this.qop.length; ++i) {
                        qopbuf.append(Byte.toString(this.qop[i]));
                        qopbuf.append(' ');
                    }
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL03:Preferred qops : {0}", qopbuf.toString());
                }
            }
            prop = (String)props.get("javax.security.sasl.strength");
            this.strength = AbstractSaslImpl.parseStrength(prop);
            logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL04:Preferred strength property: {0}", prop);
            if (logger.isLoggable(Level.FINE) && this.strength.length > 0) {
                StringBuffer strbuf = new StringBuffer();
                for (i = 0; i < this.strength.length; ++i) {
                    strbuf.append(Byte.toString(this.strength[i]));
                    strbuf.append(' ');
                }
                logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL05:Cipher strengths: {0}", strbuf.toString());
            }
            if ((prop = (String)props.get("javax.security.sasl.maxbuffer")) != null) {
                try {
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL06:Max receive buffer size: {0}", prop);
                    this.recvMaxBufSize = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.maxbuffer");
                }
            }
            if ((prop = (String)props.get(MAX_SEND_BUF)) != null) {
                try {
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL07:Max send buffer size: {0}", prop);
                    this.sendMaxBufSize = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.sendmaxbuffer");
                }
            }
        } else {
            this.qop = DEFAULT_QOP;
            this.allQop = 1;
            this.strength = STRENGTH_MASKS;
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public Object getNegotiatedProperty(String propName) {
        if (!this.completed) {
            throw new IllegalStateException("SASL authentication not completed");
        }
        if (propName.equals("javax.security.sasl.qop")) {
            if (this.privacy) {
                return "auth-conf";
            }
            if (this.integrity) {
                return "auth-int";
            }
            return "auth";
        }
        if (propName.equals("javax.security.sasl.maxbuffer")) {
            return Integer.toString(this.recvMaxBufSize);
        }
        if (propName.equals("javax.security.sasl.rawsendsize")) {
            return Integer.toString(this.rawSendSize);
        }
        if (propName.equals(MAX_SEND_BUF)) {
            return Integer.toString(this.sendMaxBufSize);
        }
        return null;
    }

    protected static final byte combineMasks(byte[] in) {
        byte answer = 0;
        for (int i = 0; i < in.length; ++i) {
            answer = (byte)(answer | in[i]);
        }
        return answer;
    }

    protected static final byte findPreferredMask(byte pref, byte[] in) {
        for (int i = 0; i < in.length; ++i) {
            if ((in[i] & pref) == 0) continue;
            return in[i];
        }
        return 0;
    }

    private static final byte[] parseQop(String qop) throws SaslException {
        return AbstractSaslImpl.parseQop(qop, null, false);
    }

    protected static final byte[] parseQop(String qop, String[] saveTokens, boolean ignore) throws SaslException {
        if (qop == null) {
            return DEFAULT_QOP;
        }
        return AbstractSaslImpl.parseProp("javax.security.sasl.qop", qop, QOP_TOKENS, QOP_MASKS, saveTokens, ignore);
    }

    private static final byte[] parseStrength(String strength) throws SaslException {
        if (strength == null) {
            return DEFAULT_STRENGTH;
        }
        return AbstractSaslImpl.parseProp("javax.security.sasl.strength", strength, STRENGTH_TOKENS, STRENGTH_MASKS, null, false);
    }

    private static final byte[] parseProp(String propName, String propVal, String[] vals, byte[] masks, String[] tokens, boolean ignore) throws SaslException {
        int j;
        StringTokenizer parser = new StringTokenizer(propVal, ", \t\n");
        byte[] answer = new byte[vals.length];
        int i = 0;
        while (parser.hasMoreTokens() && i < answer.length) {
            String token = parser.nextToken();
            boolean found = false;
            for (j = 0; !found && j < vals.length; ++j) {
                if (!token.equalsIgnoreCase(vals[j])) continue;
                found = true;
                answer[i++] = masks[j];
                if (tokens == null) continue;
                tokens[j] = token;
            }
            if (found || ignore) continue;
            throw new SaslException("Invalid token in " + propName + ": " + propVal);
        }
        for (j = i; j < answer.length; ++j) {
            answer[j] = 0;
        }
        return answer;
    }

    protected static final void traceOutput(String srcClass, String srcMethod, String traceTag, byte[] output) {
        if (output == null) {
            logger.logp(Level.WARNING, srcClass, srcMethod, "SASLIMPL09:Error generating trace output: null");
        } else {
            AbstractSaslImpl.traceOutput(srcClass, srcMethod, traceTag, output, 0, output.length);
        }
    }

    protected static final void traceOutput(String srcClass, String srcMethod, String traceTag, byte[] output, int offset, int len) {
        try {
            Level lev;
            int origlen = len;
            if (!logger.isLoggable(Level.FINEST)) {
                len = Math.min(16, len);
                lev = Level.FINER;
            } else {
                lev = Level.FINEST;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(len);
            new HexDumpEncoder().encodeBuffer((InputStream)new ByteArrayInputStream(output, offset, len), (OutputStream)out);
            logger.logp(lev, srcClass, srcMethod, "{0} ( {1} ): {2}", new Object[]{traceTag, new Integer(origlen), out.toString()});
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, srcClass, srcMethod, "SASLIMPL09:Error generating trace output: {0}", e);
        }
    }

    protected static final int networkByteOrderToInt(byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int answer = 0;
        for (int i = 0; i < count; ++i) {
            answer <<= 8;
            answer |= buf[start + i] & 0xFF;
        }
        return answer;
    }

    protected static final void intToNetworkByteOrder(int num, byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = count - 1; i >= 0; --i) {
            buf[start + i] = (byte)(num & 0xFF);
            num >>>= 8;
        }
    }

    private static synchronized void initLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SASL_LOGGER_NAME);
        }
    }

    static {
        DEFAULT_QOP = new byte[]{1};
        QOP_TOKENS = new String[]{"auth-conf", "auth-int", "auth"};
        QOP_MASKS = new byte[]{4, 2, 1};
        DEFAULT_STRENGTH = new byte[]{4, 2, 1};
        STRENGTH_TOKENS = new String[]{"low", "medium", "high"};
        STRENGTH_MASKS = new byte[]{1, 2, 4};
    }
}

