/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.file;

import java.io.File;

class UnixNativeFile {
    private static boolean isImplemented = false;
    private static Integer mutex = new Integer(0);
    private static boolean emitSearch = false;

    UnixNativeFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean initializeLibrary(File file) {
        Integer n = mutex;
        synchronized (n) {
            if (!isImplemented && file != null) {
                try {
                    System.load(file.getAbsolutePath());
                    isImplemented = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (emitSearch) {
                        System.out.println("LOGGING: UnixNativeFile load attempt through initializeLibrary(File) to load file: [" + file.getAbsolutePath() + "] failed.tandard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                    }
                    isImplemented = false;
                }
            }
        }
        return isImplemented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initializeLibrary(File file, String string, boolean bl) {
        Integer n = mutex;
        synchronized (n) {
            if (!isImplemented && file != null) {
                if (emitSearch) {
                    System.out.println("LOGGING: UnixNativeFile load attempt through initializeLibrary(File,String,boolean) in directory: " + file.getAbsolutePath() + "].");
                }
                if (string == null) {
                    string = System.mapLibraryName("NativeFile");
                    if (emitSearch) {
                        System.out.println("LOGGING: UnixNativeFile mapped generic expected library name to: [" + string + "].");
                    }
                    if (!(isImplemented = UnixNativeFile.loadLibrarySearch(file, string, bl))) {
                        string = System.mapLibraryName("NativeFile64");
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile mapped for a possible 64 bit library name to: [" + string + "] if 64 and 32 bit libraries were stored in the same directory and required renames to co-exist.");
                        }
                        isImplemented = UnixNativeFile.loadLibrarySearch(file, string, bl);
                    }
                } else {
                    isImplemented = UnixNativeFile.loadLibrarySearch(file, string, bl);
                }
            }
        }
        if (emitSearch && isImplemented) {
            System.out.println("LOGGING: UnixNativeFile successfully loaded a shared library.");
        }
        return isImplemented;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean loadLibrarySearch(File file, String string, boolean bl) {
        boolean bl2 = false;
        if (!file.exists()) return bl2;
        if (!file.isDirectory()) return bl2;
        File file2 = new File(file, string);
        if (file2.exists()) {
            try {
                System.load(file2.getAbsolutePath());
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (emitSearch) {
                    System.out.println("LOGGING: UnixNativeFile load attempt through loadLibrarySearch(File,String,boolean) to load file: [" + file2.getAbsolutePath() + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                }
                if (bl2 = UnixNativeFile.loadAIXAlternate(file, string)) return bl2;
                if (!bl) return false;
                File[] fileArray = file.listFiles();
                if (fileArray == null) return bl2;
                if (fileArray.length <= 0) return bl2;
                int n = 0;
                while (n < fileArray.length) {
                    File file3 = fileArray[n];
                    if (file3.isDirectory()) {
                        bl2 = UnixNativeFile.initializeLibrary(file3, string, bl);
                    }
                    if (bl2) return bl2;
                    ++n;
                }
                return bl2;
            }
        }
        if (!bl) return UnixNativeFile.loadAIXAlternate(file, string);
        bl2 = UnixNativeFile.loadAIXAlternate(file, string);
        if (bl2) return bl2;
        File[] fileArray = file.listFiles();
        if (fileArray == null) return bl2;
        if (fileArray.length <= 0) return bl2;
        int n = 0;
        while (n < fileArray.length) {
            File file4 = fileArray[n];
            if (file4.isDirectory()) {
                bl2 = UnixNativeFile.initializeLibrary(file4, string, bl);
            }
            if (isImplemented) return bl2;
            ++n;
        }
        return bl2;
    }

    private static boolean loadAIXAlternate(File file, String string) {
        boolean bl;
        block8: {
            bl = false;
            String string2 = System.getProperty("os.name");
            if (string2.toLowerCase().startsWith("aix")) {
                File file2;
                String string3 = null;
                if (string.endsWith(".a")) {
                    string3 = string.substring(0, string.indexOf(".a"));
                    string3 = string3 + ".so";
                } else if (string.endsWith(".so")) {
                    string3 = string.substring(0, string.indexOf(".so"));
                    string3 = string3 + ".a";
                }
                if (emitSearch) {
                    System.out.println("LOGGING: UnixNativeFile mapped alternate library name to: [" + string3 + "].");
                }
                if ((file2 = new File(file, string3)).exists()) {
                    try {
                        System.load(file2.getAbsolutePath());
                        bl = true;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (!emitSearch) break block8;
                        System.out.println("LOGGING: UnixNativeFile load attempt through initializeLibrary(File,String,boolean) to load file: [" + file2.getAbsolutePath() + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                    }
                }
            }
        }
        return bl;
    }

    protected static native int getUserPermissions(String var0);

    protected static native int getGroupPermissions(String var0);

    protected static native int getWorldPermissions(String var0);

    protected static native void setUserPermissions(String var0, int var1);

    protected static native void setGroupPermissions(String var0, int var1);

    protected static native void setWorldPermissions(String var0, int var1);

    protected static native void setPermissions(String var0, int var1, int var2, int var3);

    protected static native String getFileOwner(String var0);

    protected static native void setFileOwner(String var0, String var1);

    protected static native String getFileGroup(String var0);

    protected static native void setFileGroup(String var0, String var1);

    protected static native int isSymLink(String var0);

    protected static native void createSymLink(String var0, String var1);

    protected static native String getSymLinkValue(String var0);

    protected static native int isSetUIDBit(String var0);

    protected static native int isSetGIDBit(String var0);

    protected static native int isSetStickyBit(String var0);

    protected static native void setUIDBit(String var0, int var1);

    protected static native void setGIDBit(String var0, int var1);

    protected static native void setStickyBit(String var0, int var1);

    protected static native int symlinkDelete(String var0);

    protected static native String[] getMountedFileSystems();

    protected static native long getFreeSpace(String var0);

    protected static native long getFileSystemSize(String var0);

    protected static boolean isImplemented() {
        return isImplemented;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Integer n = mutex;
        synchronized (n) {
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("com.ibm.io.file.nativefile.emitlibrarysearch");
            if (string2 != null && "true".equalsIgnoreCase(string2)) {
                emitSearch = true;
            }
            if (!string.toLowerCase().startsWith("window")) {
                File file;
                String string3 = System.mapLibraryName("NativeFile");
                String string4 = System.mapLibraryName("NativeFile64");
                String string5 = System.getProperty("com.ibm.io.file.nativefile.libdir");
                String string6 = System.getProperty("com.ibm.io.file.nativefile.library");
                if (string6 != null) {
                    try {
                        file = new File(string6);
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt using full library name: [" + file.getAbsolutePath() + "]");
                        }
                        System.load(file.getAbsolutePath());
                        isImplemented = true;
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt successful.");
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt using full library name failed.  Exception reported was: " + unsatisfiedLinkError.toString());
                        }
                        isImplemented = false;
                    }
                }
                if (!isImplemented && string5 != null) {
                    file = new File(string5);
                    try {
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt using search directory: [" + file.getAbsolutePath() + "] and library name: [" + string3 + "]");
                        }
                        System.load(file.getAbsolutePath() + File.separator + string3);
                        isImplemented = true;
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt successful.");
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt using search directory failed.  Exception was: " + unsatisfiedLinkError.toString());
                        }
                        isImplemented = false;
                    }
                    if (!isImplemented) {
                        try {
                            if (emitSearch) {
                                System.out.println("LOGGING: UnixNativeFile load attempt using search directory: [" + file.getAbsolutePath() + "] and library name: [" + string3 + "]");
                            }
                            System.load(file.getAbsolutePath() + File.separator + string3);
                            isImplemented = true;
                            if (emitSearch) {
                                System.out.println("LOGGING: UnixNativeFile load attempt successful.");
                            }
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            if (emitSearch) {
                                System.out.println("LOGGING: UnixNativeFile load attempt using search directory failed.  Exception was: " + unsatisfiedLinkError.toString());
                            }
                            isImplemented = false;
                        }
                    }
                }
                if (!isImplemented) {
                    try {
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "]");
                        }
                        System.loadLibrary("NativeFile");
                        isImplemented = true;
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt successful.");
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        if (emitSearch) {
                            System.out.println("LOGGING: UnixNativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                        }
                        isImplemented = false;
                    }
                    if (!isImplemented) {
                        try {
                            if (emitSearch) {
                                System.out.println("LOGGING: UnixNativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "]");
                            }
                            System.loadLibrary("NativeFile64");
                            isImplemented = true;
                            if (emitSearch) {
                                System.out.println("LOGGING: UnixNativeFile load attempt successful.");
                            }
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            if (emitSearch) {
                                System.out.println("LOGGING: UnixNativeFile load attempt standard VM search path 'java.library.path': [" + System.getProperty("java.library.path") + "] failed.  Exception was: " + unsatisfiedLinkError.toString());
                            }
                            isImplemented = false;
                        }
                    }
                }
            }
        }
    }
}

