/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.OpenTypeMappingIHandler;
import com.ibm.lang.management.PlatformMbeanListProvider;
import java.io.IOException;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

public class ManagementFactory {
    private static MBeanServer platformServer;
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    private static final String BUFFERPOOL_MXBEAN_DOMAIN_TYPE = "java.nio:type=BufferPool";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    private static Map<String, String[]> interfaceNameLookupTable;
    private static Set<String> multiInstanceBeanNames;

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementUtils.getClassLoadingBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementUtils.getCompliationBean();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementUtils.getGarbageCollectorMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementUtils.getMemoryManagerMXBeans();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementUtils.getMemoryBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementUtils.getMemoryPoolMXBeans();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementUtils.getOperatingSystemBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer getPlatformMBeanServer() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new MBeanServerPermission("createMBeanServer"));
        }
        Class<ManagementFactory> clazz = ManagementFactory.class;
        synchronized (ManagementFactory.class) {
            if (platformServer == null) {
                platformServer = MBeanServerFactory.createMBeanServer();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ManagementFactory.registerPlatformBeans(platformServer);
                        return null;
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return platformServer;
        }
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementUtils.getRuntimeBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementUtils.getThreadBean();
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        ManagementFactory.verifyNamedMXBean(string, clazz);
        Object object = null;
        Class[] classArray = null;
        classArray = ManagementUtils.isANotificationEmitter(clazz) ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        object = Proxy.newProxyInstance(classArray[0].getClassLoader(), classArray, (InvocationHandler)new OpenTypeMappingIHandler(mBeanServerConnection, clazz.getName(), string));
        return (T)object;
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> clazz) {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a valid MXBean interface.");
        }
        if (multiInstanceBeanNames.contains(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " can have zero or more than one instances");
        }
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getAllAvailableMXBeans()) {
            if (!clazz.isAssignableFrom(platformManagedObject.getClass())) continue;
            return (T)platformManagedObject;
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> clazz) throws IllegalArgumentException {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a valid MXBean interface.");
        }
        LinkedList<PlatformManagedObject> linkedList = new LinkedList<PlatformManagedObject>();
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getAllAvailableMXBeans()) {
            if (!clazz.isAssignableFrom(platformManagedObject.getClass())) continue;
            linkedList.add(platformManagedObject);
        }
        return linkedList;
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a valid MXBean interface.");
        }
        if (multiInstanceBeanNames.contains(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " can have zero or more than one instances");
        }
        Set<ObjectName> set = mBeanServerConnection.queryNames(null, null);
        for (ObjectName objectName : set) {
            boolean bl;
            block5: {
                bl = false;
                try {
                    bl = mBeanServerConnection.isInstanceOf(objectName, clazz.getName());
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block5;
                    instanceNotFoundException.printStackTrace(System.err);
                }
            }
            if (!bl) continue;
            return (T)((PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName.toString(), clazz));
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IllegalArgumentException, IOException {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not a valid MXBean interface.");
        }
        LinkedList<PlatformManagedObject> linkedList = new LinkedList<PlatformManagedObject>();
        Set<ObjectName> set = mBeanServerConnection.queryNames(null, null);
        for (ObjectName objectName : set) {
            boolean bl;
            block4: {
                bl = false;
                try {
                    bl = mBeanServerConnection.isInstanceOf(objectName, clazz.getName());
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block4;
                    instanceNotFoundException.printStackTrace(System.err);
                }
            }
            if (!bl) continue;
            PlatformManagedObject platformManagedObject = (PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName.toString(), clazz);
            linkedList.add(platformManagedObject);
        }
        return linkedList;
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        List<Class> list;
        HashSet<Class<? extends PlatformManagedObject>> hashSet;
        block7: {
            hashSet = new HashSet<Class<? extends PlatformManagedObject>>();
            hashSet.add(ClassLoadingMXBean.class);
            hashSet.add(CompilationMXBean.class);
            hashSet.add(GarbageCollectorMXBean.class);
            hashSet.add(MemoryMXBean.class);
            hashSet.add(MemoryManagerMXBean.class);
            hashSet.add(MemoryPoolMXBean.class);
            hashSet.add(OperatingSystemMXBean.class);
            hashSet.add(RuntimeMXBean.class);
            hashSet.add(ThreadMXBean.class);
            hashSet.add(BufferPoolMXBean.class);
            hashSet.add(PlatformLoggingMXBean.class);
            hashSet.add(com.ibm.lang.management.GarbageCollectorMXBean.class);
            hashSet.add(com.ibm.lang.management.MemoryMXBean.class);
            hashSet.add(com.ibm.lang.management.MemoryPoolMXBean.class);
            hashSet.add(com.ibm.lang.management.OperatingSystemMXBean.class);
            list = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.lang.management.VmManagementUtils");
                PlatformMbeanListProvider platformMbeanListProvider = (PlatformMbeanListProvider)clazz.newInstance();
                list = platformMbeanListProvider.getAllAvailableMBeanInterfaces();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    illegalAccessException.printStackTrace(System.err);
                }
            }
            catch (InstantiationException instantiationException) {
                if (!ManagementUtils.VERBOSE_MODE) break block7;
                instantiationException.printStackTrace(System.err);
            }
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                hashSet.add(list.get(i));
            }
        }
        return hashSet;
    }

    private static void verifyNamedMXBean(String string, Class<?> clazz) {
        String string2;
        block11: {
            ObjectName objectName;
            if (string == null) {
                throw new NullPointerException("name cannot be null");
            }
            try {
                objectName = new ObjectName(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException(string + " is not a valid ObjectName format.", malformedObjectNameException);
            }
            string2 = clazz.getName();
            String[] stringArray = interfaceNameLookupTable.get(string2);
            if (stringArray == null) break block11;
            if (multiInstanceBeanNames.contains(string2)) {
                for (String string3 : stringArray) {
                    if (!string.startsWith(string3)) continue;
                    return;
                }
                for (String string3 : stringArray) {
                    try {
                        boolean bl;
                        ObjectName objectName2 = new ObjectName(string3);
                        String string4 = objectName2.getKeyProperty("type");
                        String string5 = objectName.getKeyProperty("type");
                        boolean bl2 = null == string4 ? null == string5 : (bl = string4.equals(string5));
                        if (!objectName2.getDomain().equals(objectName.getDomain()) || !bl) continue;
                        return;
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            } else {
                for (String string6 : stringArray) {
                    if (!string6.equals(string)) continue;
                    return;
                }
            }
        }
        throw new IllegalArgumentException(string + " is not an instance of interface " + string2);
    }

    private static void registerPlatformBeans(MBeanServer mBeanServer) {
        block16: {
            Object object;
            Object object2;
            List<PlatformManagedObject> list;
            block15: {
                list = null;
                try {
                    object2 = Class.forName("com.ibm.lang.management.VmManagementUtils");
                    object = (PlatformMbeanListProvider)((Class)object2).newInstance();
                    list = object.getAllAvailableMBeans();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (ManagementUtils.VERBOSE_MODE) {
                        illegalAccessException.printStackTrace(System.err);
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block15;
                    instantiationException.printStackTrace(System.err);
                }
            }
            try {
                object2 = ManagementUtils.getAllAvailableMXBeans();
                if (list != null) {
                    object2.addAll(list);
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    PlatformManagedObject platformManagedObject = (PlatformManagedObject)object.next();
                    ObjectName objectName = platformManagedObject.getObjectName();
                    if (mBeanServer.isRegistered(objectName)) continue;
                    mBeanServer.registerMBean(platformManagedObject, objectName);
                }
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    instanceAlreadyExistsException.printStackTrace(System.err);
                }
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    mBeanRegistrationException.printStackTrace(System.err);
                }
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                notCompliantMBeanException.printStackTrace();
                if (ManagementUtils.VERBOSE_MODE) {
                    notCompliantMBeanException.printStackTrace(System.err);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!ManagementUtils.VERBOSE_MODE) break block16;
                nullPointerException.printStackTrace(System.err);
            }
        }
    }

    static {
        Object object;
        Object object2;
        Object object3;
        List<Class> list;
        block13: {
            block12: {
                interfaceNameLookupTable = new HashMap<String, String[]>();
                interfaceNameLookupTable.put("java.lang.management.ClassLoadingMXBean", new String[]{CLASS_LOADING_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.MemoryMXBean", new String[]{MEMORY_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.ThreadMXBean", new String[]{THREAD_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.RuntimeMXBean", new String[]{RUNTIME_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.OperatingSystemMXBean", new String[]{OPERATING_SYSTEM_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.CompilationMXBean", new String[]{COMPILATION_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.GarbageCollectorMXBean", new String[]{GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("java.lang.management.MemoryManagerMXBean", new String[]{MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE, GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("java.lang.management.MemoryPoolMXBean", new String[]{MEMORY_POOL_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("java.lang.management.PlatformLoggingMXBean", new String[]{"java.util.logging:type=Logging"});
                interfaceNameLookupTable.put("java.util.logging.LoggingMXBean", new String[]{"java.util.logging:type=Logging"});
                interfaceNameLookupTable.put("com.ibm.lang.management.GarbageCollectorMXBean", new String[]{GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("com.ibm.lang.management.MemoryMXBean", new String[]{MEMORY_MXBEAN_NAME});
                interfaceNameLookupTable.put("com.ibm.lang.management.MemoryPoolMXBean", new String[]{MEMORY_POOL_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("com.ibm.lang.management.OperatingSystemMXBean", new String[]{OPERATING_SYSTEM_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.BufferPoolMXBean", new String[]{BUFFERPOOL_MXBEAN_DOMAIN_TYPE});
                list = null;
                try {
                    object3 = Class.forName("com.ibm.lang.management.VmManagementUtils");
                    object2 = (PlatformMbeanListProvider)((Class)object3).newInstance();
                    list = object2.getAllAvailableMBeanInterfaces();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (ManagementUtils.VERBOSE_MODE) {
                        illegalAccessException.printStackTrace(System.err);
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block12;
                    instantiationException.printStackTrace(System.err);
                }
            }
            object3 = null;
            try {
                object2 = Class.forName("com.ibm.lang.management.VmManagementUtils");
                object = (PlatformMbeanListProvider)((Class)object2).newInstance();
                object3 = object.getAllAvailableMBeans();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    illegalAccessException.printStackTrace(System.err);
                }
            }
            catch (InstantiationException instantiationException) {
                if (!ManagementUtils.VERBOSE_MODE) break block13;
                instantiationException.printStackTrace(System.err);
            }
        }
        object2 = null;
        object = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                object2 = list.get(i).getName();
                object = ((PlatformManagedObject)object3.get(i)).getObjectName().toString();
                interfaceNameLookupTable.put((String)object2, new String[]{object});
            }
        }
        multiInstanceBeanNames = new HashSet<String>();
        multiInstanceBeanNames.add("java.lang.management.GarbageCollectorMXBean");
        multiInstanceBeanNames.add("com.ibm.lang.management.GarbageCollectorMXBean");
        multiInstanceBeanNames.add("java.lang.management.MemoryManagerMXBean");
        multiInstanceBeanNames.add("java.lang.management.MemoryPoolMXBean");
        multiInstanceBeanNames.add("com.ibm.lang.management.MemoryPoolMXBean");
    }
}

