/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.AvailableProcessorsNotificationInfo;
import com.ibm.lang.management.BufferPoolMXBeanImpl;
import com.ibm.lang.management.ClassLoadingMXBeanImpl;
import com.ibm.lang.management.CompilationMXBeanImpl;
import com.ibm.lang.management.ExtendedOperatingSystem;
import com.ibm.lang.management.GarbageCollectorMXBean;
import com.ibm.lang.management.GarbageCollectorMXBeanImpl;
import com.ibm.lang.management.LoggingMXBeanImpl;
import com.ibm.lang.management.MemoryMXBean;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryManagerMXBeanImpl;
import com.ibm.lang.management.MemoryPoolMXBean;
import com.ibm.lang.management.MemoryPoolMXBeanImpl;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.lang.management.PlatformMbeanListProvider;
import com.ibm.lang.management.ProcessingCapacityNotificationInfo;
import com.ibm.lang.management.RuntimeMXBean;
import com.ibm.lang.management.RuntimeMXBeanImpl;
import com.ibm.lang.management.ThreadMXBeanImpl;
import com.ibm.lang.management.TotalPhysicalMemoryNotificationInfo;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.LockInfo;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.LoggingMXBean;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcaster;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ManagementUtils {
    private static Map<String, MBeanInfo> infoMap = ManagementUtils.buildInfoMap();
    private static CompositeType MEMORYUSAGE_COMPOSITETYPE;
    private static CompositeType MEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType THREADINFO_COMPOSITETYPE;
    private static CompositeType MONITORINFO_COMPOSITETYPE;
    private static CompositeType LOCKINFO_COMPOSITETYPE;
    private static CompositeType STACKTRACEELEMENT_COMPOSITETYPE;
    public static final boolean VERBOSE_MODE;

    public static ClassLoadingMXBeanImpl getClassLoadingBean() {
        return ClassLoadingMXBeanImpl.getInstance();
    }

    private static boolean checkVerboseProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return System.getProperty("com.ibm.lang.management.verbose") != null;
            }
        });
    }

    static MBeanInfo getMBeanInfo(String string) {
        Class clazz = null;
        Class clazz2 = null;
        Class clazz3 = null;
        boolean bl = false;
        StandardMBean standardMBean = null;
        MBeanInfo mBeanInfo = null;
        try {
            if (!infoMap.containsKey(string)) {
                HashMap<String, Class> hashMap = ManagementUtils.getLocalAvailableInterfaces();
                HashMap<String, Class> hashMap2 = ManagementUtils.getLocalIBMAvailableInterfaces();
                HashMap<String, Object> hashMap3 = ManagementUtils.getLocalAvailableImpls();
                if (hashMap.containsKey(string) || hashMap2.containsKey(string)) {
                    clazz2 = hashMap.get(string);
                    clazz3 = hashMap2.get(string);
                    if (clazz3 != null) {
                        bl = true;
                        clazz = clazz3;
                    } else {
                        clazz = clazz2;
                    }
                    standardMBean = new StandardMBean(hashMap3.get(string), clazz, true);
                    if (NotificationBroadcaster.class.isInstance(hashMap3.get(string))) {
                        MBeanInfo mBeanInfo2 = standardMBean.getMBeanInfo();
                        mBeanInfo = new MBeanInfo(mBeanInfo2.getClassName(), mBeanInfo2.getDescription(), mBeanInfo2.getAttributes(), mBeanInfo2.getConstructors(), mBeanInfo2.getOperations(), ((NotificationBroadcaster)hashMap3.get(string)).getNotificationInfo(), mBeanInfo2.getDescriptor());
                    } else {
                        mBeanInfo = standardMBean.getMBeanInfo();
                    }
                    infoMap.put(clazz.getName(), mBeanInfo);
                    if (bl) {
                        infoMap.put(clazz2.getName(), mBeanInfo);
                    }
                } else {
                    List<Class> list = ManagementUtils.getInterfacesFromVMUtils();
                    if (list != null) {
                        int n = -1;
                        for (int i = 0; i < list.size(); ++i) {
                            if (!string.equalsIgnoreCase(list.get(i).getName())) continue;
                            n = i;
                        }
                        if (n != -1) {
                            List<PlatformManagedObject> list2 = ManagementUtils.getBeansFromVMUtils();
                            clazz = list.get(n);
                            standardMBean = new StandardMBean(list2.get(n), clazz, true);
                            if (NotificationBroadcaster.class.isInstance(list2.get(n))) {
                                MBeanInfo mBeanInfo3 = standardMBean.getMBeanInfo();
                                mBeanInfo = new MBeanInfo(mBeanInfo3.getClassName(), mBeanInfo3.getDescription(), mBeanInfo3.getAttributes(), mBeanInfo3.getConstructors(), mBeanInfo3.getOperations(), ((NotificationBroadcaster)((Object)list2.get(n))).getNotificationInfo(), mBeanInfo3.getDescriptor());
                            } else {
                                mBeanInfo = standardMBean.getMBeanInfo();
                            }
                            infoMap.put(clazz.getName(), mBeanInfo);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return infoMap.get(string);
    }

    private static List<Class> getInterfacesFromVMUtils() {
        List<Class> list;
        block5: {
            list = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.lang.management.VmManagementUtils");
                PlatformMbeanListProvider platformMbeanListProvider = (PlatformMbeanListProvider)clazz.newInstance();
                list = platformMbeanListProvider.getAllAvailableMBeanInterfaces();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                if (VERBOSE_MODE) {
                    illegalAccessException.printStackTrace(System.err);
                }
            }
            catch (InstantiationException instantiationException) {
                if (!VERBOSE_MODE) break block5;
                instantiationException.printStackTrace(System.err);
            }
        }
        return list;
    }

    private static List<PlatformManagedObject> getBeansFromVMUtils() {
        List<PlatformManagedObject> list;
        block5: {
            list = null;
            try {
                Class<?> clazz = Class.forName("com.ibm.lang.management.VmManagementUtils");
                PlatformMbeanListProvider platformMbeanListProvider = (PlatformMbeanListProvider)clazz.newInstance();
                list = platformMbeanListProvider.getAllAvailableMBeans();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                if (VERBOSE_MODE) {
                    illegalAccessException.printStackTrace(System.err);
                }
            }
            catch (InstantiationException instantiationException) {
                if (!VERBOSE_MODE) break block5;
                instantiationException.printStackTrace(System.err);
            }
        }
        return list;
    }

    private static Map<String, MBeanInfo> buildInfoMap() {
        HashMap<String, MBeanInfo> hashMap = new HashMap<String, MBeanInfo>();
        return hashMap;
    }

    private static HashMap<String, Class> getLocalAvailableInterfaces() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put("java.lang.management.ClassLoadingMXBean", ClassLoadingMXBean.class);
        hashMap.put("java.lang.management.CompilationMXBean", CompilationMXBean.class);
        hashMap.put("java.util.logging.LoggingMXBean", LoggingMXBean.class);
        hashMap.put("java.lang.management.MemoryManagerMXBean", MemoryManagerMXBean.class);
        hashMap.put("java.lang.management.GarbageCollectorMXBean", java.lang.management.GarbageCollectorMXBean.class);
        hashMap.put("java.lang.management.MemoryMXBean", java.lang.management.MemoryMXBean.class);
        hashMap.put("java.lang.management.MemoryPoolMXBean", java.lang.management.MemoryPoolMXBean.class);
        hashMap.put("java.lang.management.OperatingSystemMXBean", java.lang.management.OperatingSystemMXBean.class);
        hashMap.put("java.lang.management.RuntimeMXBean", java.lang.management.RuntimeMXBean.class);
        hashMap.put("java.lang.management.ThreadMXBean", ThreadMXBean.class);
        hashMap.put("com.ibm.lang.management.GarbageCollectorMXBean", java.lang.management.GarbageCollectorMXBean.class);
        hashMap.put("com.ibm.lang.management.MemoryMXBean", java.lang.management.MemoryMXBean.class);
        hashMap.put("com.ibm.lang.management.MemoryPoolMXBean", java.lang.management.MemoryPoolMXBean.class);
        hashMap.put("com.ibm.lang.management.OperatingSystemMXBean", java.lang.management.OperatingSystemMXBean.class);
        hashMap.put("com.ibm.lang.management.RuntimeMXBean", java.lang.management.RuntimeMXBean.class);
        return hashMap;
    }

    private static HashMap<String, Class> getLocalIBMAvailableInterfaces() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put("java.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBean.class);
        hashMap.put("java.lang.management.MemoryMXBean", MemoryMXBean.class);
        hashMap.put("java.lang.management.MemoryPoolMXBean", MemoryPoolMXBean.class);
        hashMap.put("java.lang.management.OperatingSystemMXBean", OperatingSystemMXBean.class);
        hashMap.put("java.lang.management.RuntimeMXBean", RuntimeMXBean.class);
        hashMap.put("com.ibm.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBean.class);
        hashMap.put("com.ibm.lang.management.MemoryMXBean", MemoryMXBean.class);
        hashMap.put("com.ibm.lang.management.MemoryPoolMXBean", MemoryPoolMXBean.class);
        hashMap.put("com.ibm.lang.management.OperatingSystemMXBean", OperatingSystemMXBean.class);
        hashMap.put("com.ibm.lang.management.RuntimeMXBean", RuntimeMXBean.class);
        return hashMap;
    }

    private static HashMap<String, Object> getLocalAvailableImpls() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("java.lang.management.ClassLoadingMXBean", ClassLoadingMXBeanImpl.getInstance());
        hashMap.put("java.lang.management.CompilationMXBean", CompilationMXBeanImpl.getInstance());
        hashMap.put("java.util.logging.LoggingMXBean", LoggingMXBeanImpl.getInstance());
        hashMap.put("java.lang.management.MemoryManagerMXBean", MemoryManagerMXBeanImpl.getInstanceFromMgmtUtils());
        hashMap.put("java.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBeanImpl.getInstanceFromMgmtUtils());
        hashMap.put("java.lang.management.MemoryMXBean", MemoryMXBeanImpl.getInstance());
        hashMap.put("java.lang.management.MemoryPoolMXBean", MemoryPoolMXBeanImpl.getInstanceFromMgmtUtils());
        hashMap.put("java.lang.management.OperatingSystemMXBean", ExtendedOperatingSystem.getInstance());
        hashMap.put("java.lang.management.RuntimeMXBean", RuntimeMXBeanImpl.getInstance());
        hashMap.put("java.lang.management.ThreadMXBean", ThreadMXBeanImpl.getInstance());
        hashMap.put("com.ibm.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBeanImpl.getInstanceFromMgmtUtils());
        hashMap.put("com.ibm.lang.management.MemoryMXBean", MemoryMXBeanImpl.getInstance());
        hashMap.put("com.ibm.lang.management.MemoryPoolMXBean", MemoryPoolMXBeanImpl.getInstanceFromMgmtUtils());
        hashMap.put("com.ibm.lang.management.OperatingSystemMXBean", ExtendedOperatingSystem.getInstance());
        hashMap.put("com.ibm.lang.management.RuntimeMXBean", RuntimeMXBeanImpl.getInstance());
        return hashMap;
    }

    public static MemoryMXBeanImpl getMemoryBean() {
        return MemoryMXBeanImpl.getInstance();
    }

    public static ThreadMXBeanImpl getThreadBean() {
        return ThreadMXBeanImpl.getInstance();
    }

    public static RuntimeMXBeanImpl getRuntimeBean() {
        return RuntimeMXBeanImpl.getInstance();
    }

    public static ExtendedOperatingSystem getOperatingSystemBean() {
        return ExtendedOperatingSystem.getInstance();
    }

    public static CompilationMXBeanImpl getCompliationBean() {
        return CompilationMXBeanImpl.getInstance();
    }

    public static LoggingMXBeanImpl getLoggingBean() {
        return LoggingMXBeanImpl.getInstance();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return new LinkedList<MemoryManagerMXBean>(ManagementUtils.getMemoryBean().getMemoryManagerMXBeans());
    }

    public static List<java.lang.management.MemoryPoolMXBean> getMemoryPoolMXBeans() {
        HashSet<java.lang.management.MemoryPoolMXBean> hashSet = new HashSet<java.lang.management.MemoryPoolMXBean>();
        LinkedList<java.lang.management.MemoryPoolMXBean> linkedList = new LinkedList<java.lang.management.MemoryPoolMXBean>();
        for (MemoryManagerMXBean memoryManagerMXBean : ManagementUtils.getMemoryManagerMXBeans()) {
            MemoryManagerMXBeanImpl memoryManagerMXBeanImpl = (MemoryManagerMXBeanImpl)memoryManagerMXBean;
            for (java.lang.management.MemoryPoolMXBean memoryPoolMXBean : memoryManagerMXBeanImpl.getMemoryPoolMXBeans()) {
                if (hashSet.contains(memoryPoolMXBean)) continue;
                linkedList.add(memoryPoolMXBean);
                hashSet.add(memoryPoolMXBean);
            }
        }
        return linkedList;
    }

    public static List<java.lang.management.GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        LinkedList<java.lang.management.GarbageCollectorMXBean> linkedList = new LinkedList<java.lang.management.GarbageCollectorMXBean>();
        for (MemoryManagerMXBean memoryManagerMXBean : ManagementUtils.getMemoryBean().getMemoryManagerMXBeans()) {
            if (!(memoryManagerMXBean instanceof java.lang.management.GarbageCollectorMXBean)) continue;
            linkedList.add((java.lang.management.GarbageCollectorMXBean)memoryManagerMXBean);
        }
        return linkedList;
    }

    public static List<BufferPoolMXBean> getBufferPoolMXBeans() {
        return new LinkedList<BufferPoolMXBean>(BufferPoolMXBeanImpl.getBufferPoolMXBeans());
    }

    public static List<PlatformManagedObject> getAllAvailableMXBeans() {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(ManagementUtils.getClassLoadingBean());
        hashSet.add(ManagementUtils.getCompliationBean());
        hashSet.add(ManagementUtils.getLoggingBean());
        hashSet.add(ManagementUtils.getMemoryBean());
        hashSet.add(ManagementUtils.getThreadBean());
        hashSet.add(ManagementUtils.getRuntimeBean());
        hashSet.add(ManagementUtils.getOperatingSystemBean());
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getBufferPoolMXBeans()) {
            hashSet.add(platformManagedObject);
        }
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getMemoryPoolMXBeans()) {
            hashSet.add(platformManagedObject);
        }
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getGarbageCollectorMXBeans()) {
            hashSet.add(platformManagedObject);
        }
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getMemoryManagerMXBeans()) {
            hashSet.add(platformManagedObject);
        }
        hashSet.remove(null);
        return new ArrayList<PlatformManagedObject>(hashSet);
    }

    public static void verifyFieldTypes(CompositeData compositeData, String[] stringArray, String[] stringArray2) {
        Object[] objectArray = compositeData.getAll(stringArray);
        if (objectArray.length != stringArray2.length) {
            throw new IllegalArgumentException("CompositeData does not contain the expected number of attributes.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            String string2 = stringArray2[i];
            Object object = objectArray[i];
            if (object == null || (string = object.getClass().getName()).equals(string2)) continue;
            if (string2.equals(CompositeData.class.getName())) {
                if (!(object instanceof CompositeData)) continue;
                continue;
            }
            throw new IllegalArgumentException("CompositeData contains an attribute not of expected type. Expected " + string2 + ", found " + string);
        }
    }

    public static void verifyFieldNames(CompositeData compositeData, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (compositeData.containsKey(stringArray[i])) continue;
            throw new IllegalArgumentException("CompositeData object does not contain expected key : " + stringArray[i]);
        }
    }

    public static void verifyFieldNumber(CompositeData compositeData, int n) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (compositeData.values().size() != n) {
            throw new IllegalArgumentException("CompositeData object does not have the expected number of attributes");
        }
    }

    public static CompositeData toMemoryUsageCompositeData(MemoryUsage memoryUsage) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (memoryUsage == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"init", "used", "committed", "max"};
            Object[] objectArray = new Object[]{new Long(memoryUsage.getInit()), new Long(memoryUsage.getUsed()), new Long(memoryUsage.getCommitted()), new Long(memoryUsage.getMax())};
            CompositeType compositeType = ManagementUtils.getMemoryUsageCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static CompositeType getMemoryUsageCompositeType() {
        block3: {
            if (MEMORYUSAGE_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"init", "used", "committed", "max"};
                String[] stringArray2 = new String[]{"init", "used", "committed", "max"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                try {
                    MEMORYUSAGE_COMPOSITETYPE = new CompositeType(MemoryUsage.class.getName(), MemoryUsage.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return MEMORYUSAGE_COMPOSITETYPE;
    }

    public static CompositeData toMemoryNotificationInfoCompositeData(MemoryNotificationInfo memoryNotificationInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (memoryNotificationInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"poolName", "usage", "count"};
            Object[] objectArray = new Object[]{new String(memoryNotificationInfo.getPoolName()), ManagementUtils.toMemoryUsageCompositeData(memoryNotificationInfo.getUsage()), new Long(memoryNotificationInfo.getCount())};
            CompositeType compositeType = ManagementUtils.getMemoryNotificationInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    private static CompositeType getMemoryNotificationInfoCompositeType() {
        block3: {
            if (MEMORYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"poolName", "usage", "count"};
                String[] stringArray2 = new String[]{"poolName", "usage", "count"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, ManagementUtils.getMemoryUsageCompositeType(), SimpleType.LONG};
                try {
                    MEMORYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(MemoryNotificationInfo.class.getName(), MemoryNotificationInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return MEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getProcessingCapacityNotificationInfoCompositeType() {
        block3: {
            if (PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"newProcessingCapacity"};
                String[] stringArray2 = new String[]{"newProcessingCapacity"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.INTEGER};
                try {
                    PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(ProcessingCapacityNotificationInfo.class.getName(), ProcessingCapacityNotificationInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getTotalPhysicalMemoryNotificationInfoCompositeType() {
        block3: {
            if (TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"newTotalPhysicalMemory"};
                String[] stringArray2 = new String[]{"newTotalPhysicalMemory"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.LONG};
                try {
                    TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(TotalPhysicalMemoryNotificationInfo.class.getName(), TotalPhysicalMemoryNotificationInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getAvailableProcessorsNotificationInfoCompositeType() {
        block3: {
            if (AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"newAvailableProcessors"};
                String[] stringArray2 = new String[]{"newAvailableProcessors"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.INTEGER};
                try {
                    AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(AvailableProcessorsNotificationInfo.class.getName(), AvailableProcessorsNotificationInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE;
    }

    public static CompositeData toProcessingCapacityNotificationInfoCompositeData(ProcessingCapacityNotificationInfo processingCapacityNotificationInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (processingCapacityNotificationInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"newProcessingCapacity"};
            Object[] objectArray = new Object[]{new Integer(processingCapacityNotificationInfo.getNewProcessingCapacity())};
            CompositeType compositeType = ManagementUtils.getProcessingCapacityNotificationInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static CompositeData toTotalPhysicalMemoryNotificationInfoCompositeData(TotalPhysicalMemoryNotificationInfo totalPhysicalMemoryNotificationInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (totalPhysicalMemoryNotificationInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"newTotalPhysicalMemory"};
            Object[] objectArray = new Object[]{new Long(totalPhysicalMemoryNotificationInfo.getNewTotalPhysicalMemory())};
            CompositeType compositeType = ManagementUtils.getTotalPhysicalMemoryNotificationInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static CompositeData toAvailableProcessorsNotificationInfoCompositeData(AvailableProcessorsNotificationInfo availableProcessorsNotificationInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (availableProcessorsNotificationInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"newAvailableProcessors"};
            Object[] objectArray = new Object[]{new Integer(availableProcessorsNotificationInfo.getNewAvailableProcessors())};
            CompositeType compositeType = ManagementUtils.getAvailableProcessorsNotificationInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static CompositeData toThreadInfoCompositeData(ThreadInfo threadInfo) {
        CompositeDataSupport compositeDataSupport;
        block6: {
            if (threadInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
            CompositeData[] compositeDataArray = new CompositeData[stackTraceElementArray.length];
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                compositeDataArray[i] = ManagementUtils.toStackTraceElementCompositeData(stackTraceElementArray[i]);
            }
            MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
            CompositeData[] compositeDataArray2 = new CompositeData[monitorInfoArray.length];
            for (int i = 0; i < compositeDataArray2.length; ++i) {
                compositeDataArray2[i] = ManagementUtils.toMonitorInfoCompositeData(monitorInfoArray[i]);
            }
            LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
            CompositeData[] compositeDataArray3 = new CompositeData[lockInfoArray.length];
            for (int i = 0; i < compositeDataArray3.length; ++i) {
                compositeDataArray3[i] = ManagementUtils.toLockInfoCompositeData(lockInfoArray[i]);
            }
            String[] stringArray = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
            Object[] objectArray = new Object[]{new Long(threadInfo.getThreadId()), new String(threadInfo.getThreadName()), new String(threadInfo.getThreadState().name()), new Boolean(threadInfo.isSuspended()), new Boolean(threadInfo.isInNative()), new Long(threadInfo.getBlockedCount()), new Long(threadInfo.getBlockedTime()), new Long(threadInfo.getWaitedCount()), new Long(threadInfo.getWaitedTime()), threadInfo.getLockInfo() != null ? ManagementUtils.toLockInfoCompositeData(threadInfo.getLockInfo()) : null, threadInfo.getLockName() != null ? new String(threadInfo.getLockName()) : null, new Long(threadInfo.getLockOwnerId()), threadInfo.getLockOwnerName() != null ? new String(threadInfo.getLockOwnerName()) : null, compositeDataArray, compositeDataArray2, compositeDataArray3};
            CompositeType compositeType = ManagementUtils.getThreadInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block6;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static CompositeData toMonitorInfoCompositeData(MonitorInfo monitorInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (monitorInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            StackTraceElement stackTraceElement = monitorInfo.getLockedStackFrame();
            CompositeData compositeData = ManagementUtils.toStackTraceElementCompositeData(stackTraceElement);
            Object[] objectArray = new Object[]{new String(monitorInfo.getClassName()), new Integer(monitorInfo.getIdentityHashCode()), compositeData, new Integer(monitorInfo.getLockedStackDepth())};
            CompositeType compositeType = ManagementUtils.getMonitorInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static CompositeData toLockInfoCompositeData(LockInfo lockInfo) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (lockInfo == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"className", "identityHashCode"};
            Object[] objectArray = new Object[]{new String(lockInfo.getClassName()), new Integer(lockInfo.getIdentityHashCode())};
            CompositeType compositeType = ManagementUtils.getLockInfoCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    public static CompositeData toStackTraceElementCompositeData(StackTraceElement stackTraceElement) {
        CompositeDataSupport compositeDataSupport;
        block3: {
            if (stackTraceElement == null) {
                return null;
            }
            compositeDataSupport = null;
            String[] stringArray = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
            String string = stackTraceElement.getFileName();
            String string2 = string == null ? null : new String(string);
            Object[] objectArray = new Object[]{new String(stackTraceElement.getClassName()), new String(stackTraceElement.getMethodName()), string2, new Integer(stackTraceElement.getLineNumber()), new Boolean(stackTraceElement.isNativeMethod())};
            CompositeType compositeType = ManagementUtils.getStackTraceElementCompositeType();
            try {
                compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            }
            catch (OpenDataException openDataException) {
                if (!VERBOSE_MODE) break block3;
                openDataException.printStackTrace(System.err);
            }
        }
        return compositeDataSupport;
    }

    private static CompositeType getMonitorInfoCompositeType() {
        block3: {
            if (MONITORINFO_COMPOSITETYPE == null) {
                try {
                    String[] stringArray = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    String[] stringArray2 = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, ManagementUtils.getStackTraceElementCompositeType(), SimpleType.INTEGER};
                    MONITORINFO_COMPOSITETYPE = new CompositeType(MonitorInfo.class.getName(), MonitorInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return MONITORINFO_COMPOSITETYPE;
    }

    public static CompositeType getLockInfoCompositeType() {
        block3: {
            if (LOCKINFO_COMPOSITETYPE == null) {
                try {
                    String[] stringArray = new String[]{"className", "identityHashCode"};
                    String[] stringArray2 = new String[]{"className", "identityHashCode"};
                    OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
                    LOCKINFO_COMPOSITETYPE = new CompositeType(LockInfo.class.getName(), LockInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return LOCKINFO_COMPOSITETYPE;
    }

    public static CompositeType getThreadInfoCompositeType() {
        block3: {
            if (THREADINFO_COMPOSITETYPE == null) {
                try {
                    String[] stringArray = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    String[] stringArray2 = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    OpenType[] openTypeArray = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, ManagementUtils.getLockInfoCompositeType(), SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, ManagementUtils.getStackTraceElementCompositeType()), new ArrayType(1, ManagementUtils.getMonitorInfoCompositeType()), new ArrayType(1, ManagementUtils.getLockInfoCompositeType())};
                    THREADINFO_COMPOSITETYPE = new CompositeType(ThreadInfo.class.getName(), ThreadInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return THREADINFO_COMPOSITETYPE;
    }

    private static CompositeType getStackTraceElementCompositeType() {
        block3: {
            if (STACKTRACEELEMENT_COMPOSITETYPE == null) {
                String[] stringArray = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                String[] stringArray2 = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
                try {
                    STACKTRACEELEMENT_COMPOSITETYPE = new CompositeType(StackTraceElement.class.getName(), StackTraceElement.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return STACKTRACEELEMENT_COMPOSITETYPE;
    }

    public static List<String> convertStringArrayToList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static Object convertTabularDataToMap(TabularData tabularData) {
        if (tabularData == null) {
            return null;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Set<String> set = tabularData.getTabularType().getRowType().keySet();
        if (set.size() != 2) {
            throw new IllegalArgumentException("TabularData's row type is not a CompositeType with two items.");
        }
        String[] stringArray = new String[2];
        int n = 0;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        Collection<?> collection = tabularData.values();
        for (CompositeData compositeData : collection) {
            hashMap.put(compositeData.get(stringArray[0]), compositeData.get(stringArray[1]));
        }
        return hashMap;
    }

    public static <T> T convertFromCompositeData(CompositeData compositeData, Class<T> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (compositeData == null) {
            return null;
        }
        Method method = clazz.getMethod("from", CompositeData.class);
        return (T)method.invoke(null, compositeData);
    }

    public static <T> T convertFromOpenType(Object object, Class<?> clazz, Class<T> clazz2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (clazz.isArray() && clazz2.isArray()) {
            Class<?> clazz3 = clazz.getComponentType();
            Class<?> clazz4 = clazz2.getComponentType();
            Object[] objectArray = (Object[])object;
            object2 = Array.newInstance(clazz4, objectArray.length);
            for (int i = 0; i < Array.getLength(object2); ++i) {
                Array.set(object2, i, ManagementUtils.convertFromOpenType(objectArray[i], clazz3, clazz4));
            }
        } else if (clazz.equals(CompositeData.class)) {
            object2 = ManagementUtils.convertFromCompositeData((CompositeData)object, clazz2);
        } else if (clazz.equals(TabularData.class)) {
            if (clazz2.equals(Map.class)) {
                object2 = ManagementUtils.convertTabularDataToMap((TabularData)object);
            }
        } else if (clazz.equals(String[].class)) {
            if (clazz2.equals(List.class)) {
                object2 = ManagementUtils.convertStringArrayToList((String[])object);
            }
        } else if (clazz.equals(String.class) && clazz2.equals(MemoryType.class)) {
            object2 = ManagementUtils.convertStringToMemoryType((String)object);
        }
        return (T)object2;
    }

    private static MemoryType convertStringToMemoryType(String string) {
        MemoryType memoryType;
        block2: {
            memoryType = null;
            try {
                memoryType = MemoryType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!VERBOSE_MODE) break block2;
                illegalArgumentException.printStackTrace(System.err);
            }
        }
        return memoryType;
    }

    public static <T> T convertToOpenType(Object object, Class<T> clazz, Class<?> clazz2) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (clazz.isArray() && clazz2.isArray()) {
            Class<?> clazz3 = clazz.getComponentType();
            Class<?> clazz4 = clazz2.getComponentType();
            Object[] objectArray = (Object[])object;
            object2 = Array.newInstance(clazz3, objectArray.length);
            for (int i = 0; i < Array.getLength(object2); ++i) {
                Array.set(object2, i, ManagementUtils.convertToOpenType(objectArray[i], clazz3, clazz4));
            }
        } else if (clazz.equals(CompositeData.class)) {
            if (clazz2.equals(ThreadInfo.class)) {
                object2 = ManagementUtils.toThreadInfoCompositeData((ThreadInfo)object);
            } else if (clazz2.equals(MemoryUsage.class)) {
                object2 = ManagementUtils.toMemoryUsageCompositeData((MemoryUsage)object);
            } else if (clazz2.equals(MonitorInfo.class)) {
                object2 = ManagementUtils.toMonitorInfoCompositeData((MonitorInfo)object);
            } else if (clazz2.equals(LockInfo.class)) {
                object2 = ManagementUtils.toLockInfoCompositeData((LockInfo)object);
            }
        } else if (clazz.equals(TabularData.class)) {
            if (clazz2.equals(Map.class)) {
                object2 = ManagementUtils.toSystemPropertiesTabularData((Map)object);
            }
        } else if (clazz.equals(String[].class)) {
            if (clazz2.equals(List.class)) {
                object2 = ManagementUtils.convertListToArray((List)object, clazz, clazz.getComponentType());
            }
        } else if (clazz.equals(String.class) && clazz2.isEnum()) {
            object2 = ((Enum)object).name();
        }
        return (T)object2;
    }

    private static <T, E> T convertListToArray(List<E> list, Class<T> clazz, Class<E> clazz2) {
        Object object = Array.newInstance(clazz2, list.size());
        Iterator<E> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            E e = iterator.next();
            Array.set(object, n++, e);
        }
        return (T)object;
    }

    public static TabularData toSystemPropertiesTabularData(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        TabularDataSupport tabularDataSupport = null;
        try {
            String[] stringArray = new String[]{"key", "value"};
            String[] stringArray2 = new String[]{"key", "value"};
            OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            CompositeType compositeType = new CompositeType(map.getClass().getName(), map.getClass().getName(), stringArray, stringArray2, openTypeArray);
            TabularType tabularType = new TabularType(map.getClass().getName(), map.getClass().getName(), compositeType, new String[]{"key"});
            tabularDataSupport = new TabularDataSupport(tabularType);
            Set<String> set = map.keySet();
            for (String string : set) {
                String string2 = map.get(string);
                tabularDataSupport.put(new CompositeDataSupport(compositeType, stringArray, new String[]{string, string2}));
            }
        }
        catch (OpenDataException openDataException) {
            if (VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            tabularDataSupport = null;
        }
        return tabularDataSupport;
    }

    public static Class getClassMaybePrimitive(String string) throws ClassNotFoundException {
        Class<Object> clazz;
        int n = string.lastIndexOf(46);
        if (n != -1 && (clazz = System.getSecurityManager()) != null) {
            ((SecurityManager)((Object)clazz)).checkPackageAccess(string.substring(0, n));
        }
        clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals(Boolean.TYPE.getName())) {
                clazz = Boolean.TYPE;
            }
            if (string.equals(Character.TYPE.getName())) {
                clazz = Character.TYPE;
            }
            if (string.equals(Byte.TYPE.getName())) {
                clazz = Byte.TYPE;
            }
            if (string.equals(Short.TYPE.getName())) {
                clazz = Short.TYPE;
            }
            if (string.equals(Integer.TYPE.getName())) {
                clazz = Integer.TYPE;
            }
            if (string.equals(Long.TYPE.getName())) {
                clazz = Long.TYPE;
            }
            if (string.equals(Float.TYPE.getName())) {
                clazz = Float.TYPE;
            }
            if (string.equals(Double.TYPE.getName())) {
                clazz = Double.TYPE;
            }
            if (string.equals(Void.TYPE.getName())) {
                clazz = Void.TYPE;
            }
            if (VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw classNotFoundException;
        }
        return clazz;
    }

    public static boolean isWrapperClass(Class<? extends Object> clazz, Class clazz2) {
        boolean bl = true;
        if (clazz2.equals(Boolean.TYPE) && !clazz.equals(Boolean.class)) {
            bl = false;
        } else if (clazz2.equals(Character.TYPE) && !clazz.equals(Character.class)) {
            bl = false;
        } else if (clazz2.equals(Byte.TYPE) && !clazz.equals(Byte.class)) {
            bl = false;
        } else if (clazz2.equals(Short.TYPE) && !clazz.equals(Short.class)) {
            bl = false;
        } else if (clazz2.equals(Integer.TYPE) && !clazz.equals(Integer.class)) {
            bl = false;
        } else if (clazz2.equals(Long.TYPE) && !clazz.equals(Long.class)) {
            bl = false;
        } else if (clazz2.equals(Float.TYPE) && !clazz.equals(Float.class)) {
            bl = false;
        } else if (clazz2.equals(Double.TYPE) && !clazz.equals(Double.class)) {
            bl = false;
        }
        return bl;
    }

    public static <T> boolean isANotificationEmitter(Class<T> clazz) {
        MBeanNotificationInfo[] mBeanNotificationInfoArray;
        boolean bl = false;
        MBeanInfo mBeanInfo = ManagementUtils.getMBeanInfo(clazz.getName());
        if (mBeanInfo != null && (mBeanNotificationInfoArray = mBeanInfo.getNotifications()) != null && mBeanNotificationInfoArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    public static StackTraceElement[] getStackTracesFromCompositeDataArray(CompositeData[] compositeDataArray) {
        if (compositeDataArray == null) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[compositeDataArray.length];
        for (int i = 0; i < compositeDataArray.length; ++i) {
            CompositeData compositeData = compositeDataArray[i];
            if (compositeData != null) {
                StackTraceElement stackTraceElement;
                ManagementUtils.verifyFieldNumber(compositeData, 5);
                String[] stringArray = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                ManagementUtils.verifyFieldNames(compositeData, stringArray);
                String[] stringArray2 = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean"};
                ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
                Object[] objectArray = compositeData.getAll(stringArray);
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                int n = (Integer)objectArray[3];
                boolean bl = (Boolean)objectArray[4];
                stackTraceElementArray[i] = stackTraceElement = new StackTraceElement(string, string2, string3, n);
                continue;
            }
            stackTraceElementArray[i] = null;
        }
        return stackTraceElementArray;
    }

    public static LockInfo[] getLockInfosFromCompositeDataArray(CompositeData[] compositeDataArray) {
        if (compositeDataArray == null) {
            return null;
        }
        LockInfo[] lockInfoArray = new LockInfo[compositeDataArray.length];
        for (int i = 0; i < compositeDataArray.length; ++i) {
            LockInfo lockInfo;
            CompositeData compositeData = compositeDataArray[i];
            ManagementUtils.verifyFieldNumber(compositeData, 2);
            String[] stringArray = new String[]{"className", "identityHashCode"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.String", "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            String string = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            lockInfoArray[i] = lockInfo = new LockInfo(string, n);
        }
        return lockInfoArray;
    }

    public static MonitorInfo[] getMonitorInfosFromCompositeDataArray(CompositeData[] compositeDataArray) {
        if (compositeDataArray == null) {
            return null;
        }
        MonitorInfo[] monitorInfoArray = new MonitorInfo[compositeDataArray.length];
        for (int i = 0; i < compositeDataArray.length; ++i) {
            CompositeData compositeData = compositeDataArray[i];
            ManagementUtils.verifyFieldNumber(compositeData, 4);
            String[] stringArray = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.String", "java.lang.Integer", CompositeData.class.getName(), "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            monitorInfoArray[i] = MonitorInfo.from(compositeData);
        }
        return monitorInfoArray;
    }

    public static StackTraceElement getStackTraceFromCompositeData(CompositeData compositeData) {
        return ManagementUtils.getStackTracesFromCompositeDataArray(new CompositeData[]{compositeData})[0];
    }

    public static ObjectName createObjectName(String string) {
        try {
            return new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (VERBOSE_MODE) {
                malformedObjectNameException.printStackTrace();
            }
            return null;
        }
    }

    public static ObjectName createObjectName(String string, String string2) {
        try {
            return new ObjectName(string + ",name=" + string2);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (VERBOSE_MODE) {
                malformedObjectNameException.printStackTrace();
            }
            return null;
        }
    }

    static {
        VERBOSE_MODE = ManagementUtils.checkVerboseProperty();
    }
}

