/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.ManagementUtils;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class DynamicMXBeanImpl
implements DynamicMBean {
    protected ObjectName objectName;
    protected MBeanInfo info;

    protected DynamicMXBeanImpl(ObjectName objectName) {
        this.objectName = objectName;
    }

    protected void initMBeanInfo(String string, String string2, MBeanAttributeInfo[] mBeanAttributeInfoArray, MBeanConstructorInfo[] mBeanConstructorInfoArray, MBeanOperationInfo[] mBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        this.info = new MBeanInfo(string, string2, mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray);
    }

    protected void setMBeanInfo(MBeanInfo mBeanInfo) {
        this.info = mBeanInfo;
    }

    @Override
    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                if (!ManagementUtils.VERBOSE_MODE) continue;
                exception.printStackTrace(System.err);
            }
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            String string = null;
            Object object = null;
            try {
                this.setAttribute(attribute);
                string = attribute.getName();
                object = this.getAttribute(string);
                attributeList2.add(new Attribute(string, object));
                continue;
            }
            catch (Exception exception) {
                if (!ManagementUtils.VERBOSE_MODE) continue;
                exception.printStackTrace(System.err);
            }
        }
        return attributeList2;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    protected MBeanAttributeInfo getPresentAttribute(String string, AttributeAccessType attributeAccessType) {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.info.getAttributes();
        MBeanAttributeInfo mBeanAttributeInfo = null;
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            MBeanAttributeInfo mBeanAttributeInfo2 = mBeanAttributeInfoArray[i];
            if (!mBeanAttributeInfo2.getName().equals(string)) continue;
            if (attributeAccessType.equals((Object)AttributeAccessType.READING)) {
                if (!mBeanAttributeInfo2.isReadable()) continue;
                mBeanAttributeInfo = mBeanAttributeInfo2;
                break;
            }
            if (!mBeanAttributeInfo2.isWritable()) continue;
            mBeanAttributeInfo = mBeanAttributeInfo2;
            break;
        }
        return mBeanAttributeInfo;
    }

    @Override
    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String string2;
        Object object = null;
        Method method = null;
        MBeanAttributeInfo mBeanAttributeInfo = this.getPresentAttribute(string, AttributeAccessType.READING);
        if (mBeanAttributeInfo == null) {
            throw new AttributeNotFoundException("No such attribute : " + string);
        }
        try {
            string2 = mBeanAttributeInfo.isIs() ? "is" : "get";
            method = this.getClass().getMethod(string2 + string, null);
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            throw new ReflectionException(exception);
        }
        string2 = method.getReturnType().getName();
        String string3 = mBeanAttributeInfo.getType();
        object = this.invokeMethod(method, null);
        try {
            if (!string2.equals(string3)) {
                object = ManagementUtils.convertToOpenType(object, Class.forName(string3), Class.forName(string2));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ManagementUtils.VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw new MBeanException(classNotFoundException);
        }
        return object;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Class clazz = null;
        MBeanAttributeInfo mBeanAttributeInfo = this.getPresentAttribute(attribute.getName(), AttributeAccessType.WRITING);
        if (mBeanAttributeInfo == null) {
            throw new AttributeNotFoundException("No such attribute : " + attribute);
        }
        try {
            clazz = ManagementUtils.getClassMaybePrimitive(mBeanAttributeInfo.getType());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ManagementUtils.VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw new ReflectionException(classNotFoundException);
        }
        if (clazz.isPrimitive() ? !ManagementUtils.isWrapperClass(attribute.getValue().getClass(), clazz) : !clazz.equals(attribute.getValue().getClass())) {
            throw new InvalidAttributeValueException(mBeanAttributeInfo.getName() + " is a " + mBeanAttributeInfo.getType() + " attribute");
        }
        Method method = null;
        try {
            method = this.getClass().getMethod("set" + attribute.getName(), clazz);
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            throw new ReflectionException(exception);
        }
        this.invokeMethod(method, attribute.getValue());
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Object object;
        MBeanOperationInfo mBeanOperationInfo;
        Object object2 = null;
        String[] stringArray2 = stringArray;
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if ((mBeanOperationInfo = this.getPresentOperation(string, stringArray2)) == null) {
            throw new ReflectionException(new NoSuchMethodException(string), "No such operation : " + string);
        }
        Method method = null;
        try {
            object = new Class[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                object[i] = ManagementUtils.getClassMaybePrimitive(stringArray2[i]);
            }
            method = this.getClass().getMethod(string, (Class<?>)object);
        }
        catch (Exception exception) {
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            throw new ReflectionException(exception);
        }
        object = method.getReturnType().getName();
        String string2 = mBeanOperationInfo.getReturnType();
        object2 = this.invokeMethod(method, objectArray);
        try {
            if (!((String)object).equals(string2)) {
                object2 = ManagementUtils.convertToOpenType(object2, Class.forName(string2), Class.forName((String)object));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ManagementUtils.VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw new MBeanException(classNotFoundException);
        }
        return object2;
    }

    protected MBeanOperationInfo getPresentOperation(String string, String[] stringArray) {
        MBeanOperationInfo[] mBeanOperationInfoArray = this.info.getOperations();
        MBeanOperationInfo mBeanOperationInfo = null;
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            MBeanOperationInfo mBeanOperationInfo2 = mBeanOperationInfoArray[i];
            if (!mBeanOperationInfo2.getName().equals(string) || stringArray.length != mBeanOperationInfo2.getSignature().length) continue;
            boolean bl = true;
            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo2.getSignature();
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray[j];
                if (mBeanParameterInfo.getType().equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            mBeanOperationInfo = mBeanOperationInfo2;
            break;
        }
        return mBeanOperationInfo;
    }

    private Object invokeMethod(Method method, Object ... objectArray) throws MBeanException {
        Object object = null;
        try {
            object = method.invoke((Object)this, objectArray);
        }
        catch (Exception exception) {
            Throwable throwable;
            if (ManagementUtils.VERBOSE_MODE) {
                exception.printStackTrace(System.err);
            }
            if ((throwable = exception.getCause()) instanceof Error) {
                throw new MBeanException(null, throwable.toString());
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new MBeanException((Exception)throwable);
        }
        return object;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    static enum AttributeAccessType {
        READING,
        WRITING;

    }
}

