/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.swt;

import com.ibm.cic.common.ui.internal.licensePanel.BaseEclipseStyleLicensePage;
import com.ibm.cic.common.ui.internal.licensePanel.LicensePart;
import com.ibm.cic.common.ui.internal.wizardry.IWizardBreadCrumbs;
import com.ibm.cic.common.ui.services.IAboutDialogService;
import com.ibm.cic.common.ui.services.IClipboard;
import com.ibm.cic.common.ui.services.IDirectoryDialogService;
import com.ibm.cic.common.ui.services.IFileDialogService;
import com.ibm.cic.common.ui.services.IStyledText;
import com.ibm.cic.common.ui.services.IUiServices;
import com.ibm.cic.common.ui.swt.SwtAboutDialogService;
import com.ibm.cic.common.ui.swt.SwtDirectoryDialogService;
import com.ibm.cic.common.ui.swt.SwtFileDialogService;
import com.ibm.cic.common.ui.swt.controls.SwtClipboard;
import com.ibm.cic.common.ui.swt.controls.SwtLicensePart;
import com.ibm.cic.common.ui.swt.controls.SwtStyledText;
import com.ibm.cic.common.ui.swt.controls.SwtWizardBreadcrumbs;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SwtUiServices
implements IUiServices {
    public Image createBackgroundImage(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        Image transparent = descriptor.createImage();
        Image image = new Image(transparent.getDevice(), data.width, data.height);
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(image.getDevice().getSystemColor(1));
            gc.fillRectangle(image.getBounds());
            gc.drawImage(transparent, 0, 0);
            Image image2 = image;
            return image2;
        }
        finally {
            gc.dispose();
            transparent.dispose();
        }
    }

    public boolean launchProgram(String command) {
        return Program.launch((String)command);
    }

    public boolean findAndExecuteProgram(String filename, String command) {
        Program p = Program.findProgram((String)filename);
        if (p != null) {
            return p.execute(command);
        }
        return false;
    }

    public int calculateCompositeHeight(Composite composite) {
        int numberOfLines = 10;
        GC gc = new GC((Drawable)composite);
        gc.setFont(composite.getFont());
        FontMetrics fm = gc.getFontMetrics();
        int height = (fm.getHeight() + fm.getLeading()) * numberOfLines;
        gc.dispose();
        return height;
    }

    public LicensePart createLicensePart(BaseEclipseStyleLicensePage parentPage) {
        return new SwtLicensePart(parentPage);
    }

    public IStyledText createStyledText(Composite parent, int style) {
        return new SwtStyledText(parent, style);
    }

    public void paintBordersFor(FormToolkit toolkit, Composite composite) {
        toolkit.paintBordersFor(composite);
    }

    public IWizardBreadCrumbs createWizardBreadcrumbs(Composite parent) {
        return new SwtWizardBreadcrumbs(parent);
    }

    public void setStyleRange(IStyledText text, int style, int length) {
        if (text instanceof StyledText) {
            StyledText stext = (StyledText)text;
            StyleRange srange = new StyleRange();
            srange.fontStyle = style;
            srange.length = length;
            stext.setStyleRange(srange);
        }
    }

    public void restartWorkbench() {
        PlatformUI.getWorkbench().restart();
    }

    public IClipboard createClipboard(Display display) {
        return new SwtClipboard(display);
    }

    public boolean isWebPlatformActive() {
        return false;
    }

    public void openUrlInBrowser(URL url) throws PartInitException {
        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
    }

    public void configureSession() {
    }

    public Object getServerAttribute(String name) {
        return null;
    }

    public void setServerAttribute(String name, String value) {
    }

    public void sendServerError(int code, String error) {
    }

    public IDirectoryDialogService getDirectoryDialog(Shell shell) {
        return new SwtDirectoryDialogService(shell);
    }

    public IFileDialogService getFileDialog(Shell shell) {
        return new SwtFileDialogService(shell);
    }

    public IAboutDialogService getAboutDialog(Shell shell) {
        return new SwtAboutDialogService(shell);
    }

    public void killSession(Display display) {
    }

    public void setWorkbenchWindowTitle(Shell shell, String title) {
        shell.setText(title);
    }
}

