/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.Theme;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;

    Rectangle computeTrim(Theme theme, GC gc) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
    }

    void drawImage(Theme theme, Image image, GC gc, Rectangle bounds) {
        long drawable = gc.getGCData().drawable;
        Rectangle rect = image.getBounds();
        int state_type = this.getStateType(0);
        if (state_type == 0) {
            gc.drawImage(image, 0, 0, rect.width, rect.height, bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            long pixbuf = ImageList.createPixbuf(image);
            long source = OS.gtk_icon_source_new();
            if (source != 0L) {
                OS.gtk_icon_source_set_pixbuf(source, pixbuf);
                long buttonHandle = theme.buttonHandle;
                long gtkStyle = OS.gtk_widget_get_style(buttonHandle);
                theme.transferClipping(gc, gtkStyle);
                long rendered = OS.gtk_style_render_icon(gtkStyle, source, 0, state_type, -1, buttonHandle, null);
                OS.g_object_unref(pixbuf);
                if (rendered != 0L) {
                    OS.gdk_draw_pixbuf(drawable, gc.handle, rendered, 0, 0, bounds.x, bounds.y, bounds.width, bounds.height, 1, 0, 0);
                    OS.g_object_unref(rendered);
                }
                OS.gtk_icon_source_free(source);
            }
        }
    }

    void drawText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        long widget = this.getTextHandle(theme);
        long gtkStyle = OS.gtk_widget_get_style(widget);
        long drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        long layout = OS.gtk_widget_create_pango_layout(widget, buffer);
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size(layout, width, height);
        OS.pango_layout_set_width(layout, bounds.width * 1024);
        int x = bounds.x;
        int y = bounds.y;
        if ((flags & 0x10) != 0) {
            OS.pango_layout_set_alignment(layout, 0);
        }
        if ((flags & 0x100) != 0) {
            OS.pango_layout_set_alignment(layout, 1);
        }
        if ((flags & 0x40) != 0) {
            OS.pango_layout_set_alignment(layout, 2);
        }
        if ((flags & 0x200) != 0) {
            y += (bounds.height - OS.PANGO_PIXELS(height[0])) / 2;
        }
        if ((flags & 0x80) != 0) {
            y += bounds.height - OS.PANGO_PIXELS(height[0]);
        }
        int state_type = this.getStateType(0);
        byte[] detail = Converter.wcsToMbcs(null, "label", true);
        OS.gtk_paint_layout(gtkStyle, drawable, state_type, false, null, widget, detail, x, y, layout);
        OS.g_object_unref(layout);
    }

    Rectangle getBounds(int part, Rectangle bounds) {
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    int getStateType(int part) {
        int state = this.state[part];
        int state_type = 0;
        if ((state & 0x20) != 0) {
            state_type = 4;
        } else {
            if ((state & 2) != 0) {
                state_type = 1;
            }
            if ((state & 0x40) != 0) {
                state_type = (state & 8) != 0 ? 1 : 2;
            }
        }
        return state_type;
    }

    long getTextHandle(Theme theme) {
        return theme.labelHandle;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return -1;
    }

    Rectangle measureText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        long widget = this.getTextHandle(theme);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        long layout = OS.gtk_widget_create_pango_layout(widget, buffer);
        if (bounds != null) {
            OS.pango_layout_set_width(layout, bounds.width);
        }
        if ((flags & 0x10) != 0) {
            OS.pango_layout_set_alignment(layout, 0);
        }
        if ((flags & 0x100) != 0) {
            OS.pango_layout_set_alignment(layout, 1);
        }
        if ((flags & 0x40) != 0) {
            OS.pango_layout_set_alignment(layout, 2);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size(layout, width, height);
        OS.g_object_unref(layout);
        return new Rectangle(0, 0, OS.PANGO_PIXELS(width[0]), OS.PANGO_PIXELS(height[0]));
    }
}

