/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import sun.io.Converters;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.DelegatableDecoder;

public class DoubleByte {
    public static final char[] B2C_UNMAPPABLE = new char[256];

    static {
        Arrays.fill(B2C_UNMAPPABLE, '\ufffd');
    }

    public static class Encoder_EUC_SIM
    extends Encoder {
        Encoder_EUC_SIM(Charset charset, char[] cArray, char[] cArray2) {
            super(charset, cArray, cArray2);
        }
    }

    public static class Encoder_EBCDIC
    extends Encoder {
        static final int SBCS = 0;
        static final int DBCS = 1;
        static final byte SO = 14;
        static final byte SI = 15;
        protected static final int LINE_FEED_INDEX = 10;
        protected static final int LINE_FEED = 21;
        protected int currentState = 0;

        Encoder_EBCDIC(Charset charset, char[] cArray, char[] cArray2) {
            super(charset, 4.0f, 5.0f, new byte[]{111}, cArray, cArray2);
            if (Converters.isSwapLF()) {
                cArray[cArray2[0] + 10] = 21;
            }
        }

        @Override
        protected void implReset() {
            this.currentState = 0;
        }

        @Override
        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            if (this.currentState == 1) {
                if (byteBuffer.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)15);
            }
            this.implReset();
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                    char c = cArray[n];
                    int n5 = this.encodeChar(c);
                    if (n5 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, cArray, n, n2) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n5 > 255) {
                        if (this.currentState == 0) {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 1;
                            byArray[n3++] = 14;
                        }
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)n5;
                        continue;
                    }
                    if (this.currentState == 1) {
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        this.currentState = 0;
                        byArray[n3++] = 15;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n5;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    int n2 = this.encodeChar(c);
                    if (n2 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n2 > 255) {
                        if (this.currentState == 0) {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 1;
                            byteBuffer.put((byte)14);
                        }
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(n2 >> 8));
                        byteBuffer.put((byte)n2);
                    } else {
                        if (this.currentState == 1) {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 0;
                            byteBuffer.put((byte)15);
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)n2);
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }
    }

    public static class Encoder_EBCDIC_DBCSONLY
    extends Encoder {
        Encoder_EBCDIC_DBCSONLY(Charset charset, byte[] byArray, char[] cArray, char[] cArray2) {
            super(charset, 2.0f, 2.0f, byArray, cArray, cArray2);
        }

        @Override
        public int encodeChar(char c) {
            int n = super.encodeChar(c);
            if (n <= 255) {
                return 65533;
            }
            return n;
        }
    }

    public static class Encoder_DBCSONLY
    extends Encoder {
        Encoder_DBCSONLY(Charset charset, char[] cArray, char[] cArray2) {
            super(charset, 2.0f, 2.0f, new byte[]{-4, -4}, cArray, cArray2);
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            if (2 == byArray.length && -4 == byArray[0] && -4 == byArray[1]) {
                return true;
            }
            return super.isLegalReplacement(byArray);
        }
    }

    public static class Encoder
    extends CharsetEncoder {
        final int MAX_SINGLEBYTE = 255;
        private final char[] c2b;
        private final char[] c2bIndex;
        Surrogate.Parser sgp;

        protected Encoder(Charset charset, char[] cArray, char[] cArray2) {
            super(charset, 2.0f, 2.0f);
            this.c2b = cArray;
            this.c2bIndex = cArray2;
        }

        Encoder(Charset charset, float f, float f2, byte[] byArray, char[] cArray, char[] cArray2) {
            super(charset, f, f2, byArray);
            this.c2b = cArray;
            this.c2bIndex = cArray2;
        }

        @Override
        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        Surrogate.Parser sgp() {
            if (this.sgp == null) {
                this.sgp = new Surrogate.Parser();
            }
            return this.sgp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                    char c = cArray[n];
                    int n5 = this.encodeChar(c);
                    if (n5 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, cArray, n, n2) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n5 > 255) {
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)n5;
                        continue;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n5;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    int n2 = this.encodeChar(c);
                    if (n2 == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n2 > 255) {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(n2 >> 8));
                        byteBuffer.put((byte)n2);
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)n2);
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        public int encodeChar(char c) {
            return this.c2b[this.c2bIndex[c >> 8] + (c & 0xFF)];
        }

        static void initC2B(String[] stringArray, String string, String string2, String string3, int n, int n2, char[] cArray, char[] cArray2) {
            int n3;
            int n4;
            char c;
            int n5;
            Arrays.fill(cArray, '\ufffd');
            int n6 = 256;
            char[][] cArrayArray = new char[stringArray.length][];
            char[] cArray3 = null;
            if (string != null) {
                cArray3 = string.toCharArray();
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                if (stringArray[n5] == null) continue;
                cArrayArray[n5] = stringArray[n5].toCharArray();
            }
            if (string2 != null) {
                n5 = 0;
                while (n5 < string2.length()) {
                    c = string2.charAt(n5++);
                    n4 = string2.charAt(n5++);
                    if (c < '\u0100' && cArray3 != null) {
                        if (cArray3[c] != n4) continue;
                        cArray3[c] = 65533;
                        continue;
                    }
                    if (cArrayArray[c >> 8][(c & 0xFF) - n] != n4) continue;
                    cArrayArray[c >> 8][(c & 0xFF) - n] = 65533;
                }
            }
            if (cArray3 != null) {
                for (n5 = 0; n5 < cArray3.length; ++n5) {
                    c = cArray3[n5];
                    if (c == '\ufffd') continue;
                    n4 = cArray2[c >> 8];
                    if (n4 == 0) {
                        n4 = n6;
                        n6 += 256;
                        cArray2[c >> 8] = (char)n4;
                    }
                    cArray[n4 + (c & 0xFF)] = (char)n5;
                }
            }
            for (n5 = 0; n5 < stringArray.length; ++n5) {
                char[] cArray4 = cArrayArray[n5];
                if (cArray4 == null) continue;
                for (n4 = n; n4 <= n2; ++n4) {
                    n3 = cArray4[n4 - n];
                    if (n3 == 65533) continue;
                    int n7 = cArray2[n3 >> 8];
                    if (n7 == 0) {
                        n7 = n6;
                        n6 += 256;
                        cArray2[n3 >> 8] = (char)n7;
                    }
                    cArray[n7 + (n3 & 0xFF)] = (char)(n5 << 8 | n4);
                }
            }
            if (string3 != null) {
                for (n5 = 0; n5 < string3.length(); n5 += 2) {
                    char c2 = string3.charAt(n5);
                    n4 = string3.charAt(n5 + 1);
                    n3 = n4 >> 8;
                    if (cArray2[n3] == '\u0000') {
                        cArray2[n3] = (char)n6;
                        n6 += 256;
                    }
                    n3 = cArray2[n3] + (n4 & 0xFF);
                    cArray[n3] = c2;
                }
            }
        }
    }

    public static class Decoder_EUC_SIM
    extends Decoder {
        private final int SS2 = 142;
        private final int SS3 = 143;

        Decoder_EUC_SIM(Charset charset, char[][] cArray, char[] cArray2, int n, int n2) {
            super(charset, cArray, cArray2, n, n2);
        }

        @Override
        protected CoderResult crMalformedOrUnderFlow(int n) {
            if (n == 142 || n == 143) {
                return CoderResult.malformedForLength(1);
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected CoderResult crMalformedOrUnmappable(int n) {
            if (n == 142 || n == 143) {
                return CoderResult.malformedForLength(1);
            }
            return CoderResult.unmappableForLength(2);
        }
    }

    public static class Decoder_EBCDIC_DBCSONLY
    extends Decoder {
        static final char[] b2cSB = new char[256];

        Decoder_EBCDIC_DBCSONLY(Charset charset, char[][] cArray, int n, int n2) {
            super(charset, 0.5f, 1.0f, cArray, b2cSB, n, n2);
        }

        static {
            Arrays.fill(b2cSB, '\ufffd');
        }
    }

    public static class Decoder_DBCSONLY
    extends Decoder {
        Decoder_DBCSONLY(Charset charset, char[][] cArray, char[] cArray2, int n, int n2) {
            super(charset, cArray, cArray2, n, n2);
        }
    }

    public static class Decoder_EBCDIC
    extends Decoder {
        private static final int SBCS = 0;
        private static final int DBCS = 1;
        private static final int SO = 14;
        private static final int SI = 15;
        private int currentState;
        protected static final int LINE_FEED_INDEX = 21;
        protected static final int LINE_FEED = 10;

        Decoder_EBCDIC(Charset charset, char[][] cArray, char[] cArray2, int n, int n2) {
            super(charset, cArray, cArray2, n, n2);
            if (Converters.isSwapLF()) {
                cArray2[21] = 10;
            }
        }

        @Override
        public void implReset() {
            this.currentState = 0;
        }

        private static boolean isDoubleByte(int n, int n2) {
            return 65 <= n && n <= 254 && 65 <= n2 && n2 <= 254 || n == 64 && n2 == 64;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                int n5;
                for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += n5) {
                    int n6 = byArray[n] & 0xFF;
                    n5 = 1;
                    if (n6 == 14) {
                        if (this.currentState != 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 1;
                        continue;
                    }
                    if (n6 == 15) {
                        if (this.currentState != 1) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 0;
                        continue;
                    }
                    int n7 = 65533;
                    if (this.currentState == 0) {
                        n7 = this.b2cSB[n6];
                        if (n7 == 65533) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    } else {
                        if (n2 - n < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n8 = byArray[n + 1] & 0xFF;
                        if (n8 < this.b2Min || n8 > this.b2Max || (n7 = this.b2c[n6][n8 - this.b2Min]) == 65533) {
                            if (!Decoder_EBCDIC.isDoubleByte(n6, n8)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(2);
                            return coderResult;
                        }
                        ++n5;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = n7;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = 1;
                    if (n2 == 14) {
                        if (this.currentState != 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 1;
                    } else if (n2 == 15) {
                        if (this.currentState != 1) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 0;
                    } else {
                        char c = '\ufffd';
                        if (this.currentState == 0) {
                            c = this.b2cSB[n2];
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(1);
                                return coderResult;
                            }
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            int n4 = byteBuffer.get() & 0xFF;
                            if (n4 < this.b2Min || n4 > this.b2Max || (c = this.b2c[n2][n4 - this.b2Min]) == '\ufffd') {
                                if (!Decoder_EBCDIC.isDoubleByte(n2, n4)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            ++n3;
                        }
                        if (charBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put(c);
                    }
                    n += n3;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }
    }

    public static class Decoder
    extends CharsetDecoder
    implements DelegatableDecoder {
        final char[][] b2c;
        final char[] b2cSB;
        final int b2Min;
        final int b2Max;

        protected CoderResult crMalformedOrUnderFlow(int n) {
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult crMalformedOrUnmappable(int n) {
            return CoderResult.unmappableForLength(2);
        }

        Decoder(Charset charset, float f, float f2, char[][] cArray, char[] cArray2, int n, int n2) {
            super(charset, f, f2);
            this.b2c = cArray;
            this.b2cSB = cArray2;
            this.b2Min = n;
            this.b2Max = n2;
        }

        Decoder(Charset charset, char[][] cArray, char[] cArray2, int n, int n2) {
            this(charset, 0.5f, 1.0f, cArray, cArray2, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                int n5;
                for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2 && n3 < n4; n += n5) {
                    n5 = 1;
                    int n6 = byArray[n] & 0xFF;
                    char c = this.b2cSB[n6];
                    if (c == '\ufffd') {
                        if (n2 - n < 2) {
                            CoderResult coderResult = this.crMalformedOrUnderFlow(n6);
                            return coderResult;
                        }
                        int n7 = byArray[n + 1] & 0xFF;
                        if (n7 < this.b2Min || n7 > this.b2Max || (c = this.b2c[n6][n7 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(n6);
                            return coderResult;
                        }
                        ++n5;
                    }
                    cArray[n3++] = c;
                }
                CoderResult coderResult = n >= n2 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining() && charBuffer.hasRemaining()) {
                    int n2 = byteBuffer.get() & 0xFF;
                    char c = this.b2cSB[n2];
                    int n3 = 1;
                    if (c == '\ufffd') {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = this.crMalformedOrUnderFlow(n2);
                            return coderResult;
                        }
                        int n4 = byteBuffer.get() & 0xFF;
                        if (n4 < this.b2Min || n4 > this.b2Max || (c = this.b2c[n2][n4 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(n2);
                            return coderResult;
                        }
                        ++n3;
                    }
                    charBuffer.put(c);
                    n += n3;
                }
                CoderResult coderResult = byteBuffer.hasRemaining() ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }

        public char decodeSingle(int n) {
            return this.b2cSB[n];
        }

        public char decodeDouble(int n, int n2) {
            if (n2 < this.b2Min || n2 > this.b2Max) {
                return '\ufffd';
            }
            return this.b2c[n][n2 - this.b2Min];
        }
    }
}

