/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.template;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.xml.core.CicXMLCore;
import com.ibm.cic.common.xml.core.FileUtility;
import com.ibm.cic.common.xml.core.model.IXMLModel;
import com.ibm.cic.common.xml.core.template.ITemplate;
import com.ibm.cic.common.xml.core.template.ITemplateBinding;
import com.ibm.cic.common.xml.core.template.ITemplateEngine;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TemplateTools {
    public static final IXMLModel applyTemplateRaw(ITemplate template, Object rootBinding) throws CoreException {
        ITemplateEngine engine = CicXMLCore.getDefault().getTemplateEngine();
        ITemplateBinding binding = engine.createBinding(template, rootBinding);
        IXMLModel model = engine.expand(binding);
        return model;
    }

    public static final String expandTemplate(ITemplate template, Object rootBinding) throws CoreException {
        IXMLModel model = TemplateTools.applyTemplateRaw(template, rootBinding);
        String ser = CicXMLCore.getDefault().getSerializer(true, false).serialize(model);
        return ser;
    }

    public static final void applyTemplate(ITemplate template, Object rootBinding, File output) throws CoreException {
        IXMLModel model = TemplateTools.applyTemplateRaw(template, rootBinding);
        String ser = CicXMLCore.getDefault().getSerializer(true, false).serialize(model);
        FileOutputStream fout = null;
        ByteArrayInputStream bin = null;
        try {
            try {
                bin = new ByteArrayInputStream(ser.getBytes("UTF8"));
                fout = new FileOutputStream(output);
                FileUtility.copyStream(bin, fout);
            }
            catch (Exception e) {
                Status err = new Status(4, "com.ibm.cic.common.xml.core", "Error expanding template.", (Throwable)e);
                throw new CoreException((IStatus)err);
            }
        }
        catch (Throwable throwable) {
            if (fout != null) {
                FileUtil.close(fout);
                fout = null;
            }
            if (bin != null) {
                FileUtil.close((Closeable)bin);
                bin = null;
            }
            throw throwable;
        }
        if (fout != null) {
            FileUtil.close((Closeable)fout);
            fout = null;
        }
        if (bin != null) {
            FileUtil.close((Closeable)bin);
            bin = null;
        }
    }
}

