/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model;

import com.ibm.cic.common.xml.core.model.schema.IXMLPath;
import com.ibm.cic.common.xml.core.model.schema.XMLPathFactory;

public class XMLPath
implements IXMLPath {
    IXMLPath fParent;
    IXMLPath fChild;
    private final String fSegmentName;
    public static final String DELIM = "/";

    public XMLPath(IXMLPath parent, String name) {
        this.fSegmentName = name;
        this.fParent = parent;
        if (this.fParent != null) {
            this.fParent.setChild(this);
        }
    }

    public XMLPath(IXMLPath copy) {
        this.fSegmentName = copy.getSegmentName();
        this.fParent = copy.getDetachedParent();
        if (this.fParent != null) {
            this.fParent.setChild(this);
        }
    }

    @Override
    public boolean isRoot() {
        return this.fParent == null;
    }

    @Override
    public IXMLPath getChild() {
        return this.fChild;
    }

    @Override
    public IXMLPath getParent() {
        return this.fParent;
    }

    @Override
    public String getPath() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.fSegmentName);
        if (this.fParent != null) {
            IXMLPath parent = this.fParent;
            int recursionCheck = 0;
            buffer.insert(0, DELIM);
            buffer.insert(0, parent.getSegmentName());
            while (parent.getParent() != null) {
                parent = parent.getParent();
                buffer.insert(0, DELIM);
                buffer.insert(0, parent.getSegmentName());
                if (++recursionCheck <= 256) continue;
            }
        }
        return buffer.toString();
    }

    @Override
    public String getSegmentName() {
        return this.fSegmentName;
    }

    @Override
    public void setChild(IXMLPath segment) {
        this.fChild = segment;
    }

    @Override
    public void setParent(IXMLPath segment) {
        this.fParent = segment;
    }

    @Override
    public IXMLPath getDetachedParent() {
        if (this.fParent == null) {
            return null;
        }
        return new XMLPath(this.fParent.getParent(), this.fParent.getSegmentName());
    }

    @Override
    public boolean startsWith(IXMLPath otherPath) {
        return this.matchingFirstSegments(otherPath) == otherPath.segmentCount();
    }

    @Override
    public int matchingFirstSegments(IXMLPath otherPath) {
        IXMLPath thisRoot = this.toRoot(this);
        IXMLPath otherRoot = this.toRoot(otherPath);
        int matches = 0;
        if (!thisRoot.getSegmentName().equals(otherRoot.getSegmentName())) {
            return matches;
        }
        ++matches;
        while (thisRoot.getChild() != null) {
            thisRoot = thisRoot.getChild();
            if ((otherRoot = otherRoot.getChild()) == null || !otherRoot.getSegmentName().equals(thisRoot.getSegmentName())) {
                return matches;
            }
            ++matches;
        }
        return matches;
    }

    @Override
    public IXMLPath removeFirstSegments(int count) {
        XMLPath position = new XMLPath(this);
        int dif = this.segmentCount() - count;
        if (dif < 1) {
            return new XMLPath(null, "");
        }
        int i = 0;
        while (i < dif) {
            if (position.getParent() != null && i < dif - 1) {
                position = (XMLPath)position.getParent();
            }
            ++i;
        }
        position.setParent(null);
        return XMLPathFactory.makeRoot(position.toRoot(position));
    }

    @Override
    public int segmentCount() {
        int count = 1;
        IXMLPath p = this;
        while (p.getParent() != null) {
            ++count;
            p = p.getParent();
        }
        return count;
    }

    private IXMLPath toRoot(IXMLPath path) {
        while (path.getParent() != null) {
            path = path.getParent();
        }
        return path;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public int indexOf(String segmentName) {
        IXMLPath root = this.toRoot(this);
        int idx = 0;
        while ((root = root.getChild()) != null) {
            ++idx;
            if (!segmentName.equals(root.getSegmentName())) continue;
            return idx;
        }
        return -1;
    }
}

