/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.gen;

import com.ibm.cic.common.xml.core.XMLString;
import com.ibm.cic.common.xml.core.model.IProcessingInstruction;
import com.ibm.cic.common.xml.core.model.gen.IGeneratorValueProvider;
import com.ibm.cic.common.xml.core.model.schema.IAttributeDefinition;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;

public class GenUtils {
    private static final char CHAR_START = '<';
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_EQUALS = '=';
    private static final char CHAR_QUOTE = '\'';
    private static final char CHAR_END = '>';
    private static final char CHAR_SLASH = '/';
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_Q = '?';

    public static void startElement(IElementDefinition item, IGeneratorValueProvider provider, StringBuffer buffer, String delim) {
        IAttributeDefinition[] attrs;
        buffer.append('<');
        buffer.append(item.getName());
        IAttributeDefinition[] iAttributeDefinitionArray = attrs = item.getAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeDefinition attr = iAttributeDefinitionArray[n2];
            if (attr.isRequired() || provider.getAttributeValue(attr.getName()) != null) {
                GenUtils.appendAttribute(item, attr, provider, buffer);
            }
            ++n2;
        }
        if (provider.hasSimpleValue() || item.getChildElementCount() > 0) {
            GenUtils.closeStartTag(buffer, delim);
        }
        if (provider.hasSimpleValue()) {
            buffer.append(XMLString.encode(provider.getSimpleValue()));
        }
    }

    public static void endSingleLineElement(StringBuffer buffer, String delim) {
        buffer.append(' ');
        buffer.append('/');
        buffer.append('>');
        buffer.append(delim);
    }

    public static void appendAttribute(IElementDefinition parent, IAttributeDefinition attr, IGeneratorValueProvider provider, StringBuffer buffer) {
        buffer.append(' ');
        buffer.append(attr.getName());
        buffer.append('=');
        buffer.append('\'');
        if (provider != null) {
            String val = provider.getAttributeValue(attr.getName());
            if (val != null) {
                val = XMLString.encode(val);
                buffer.append(val);
            } else if (attr.getDefault() != null) {
                buffer.append(attr.getDefault());
            }
        } else if (attr.getDefault() != null) {
            buffer.append(attr.getDefault());
        }
        buffer.append('\'');
    }

    public static void closeStartTag(StringBuffer buffer, String delim) {
        buffer.append('>');
        buffer.append(delim);
    }

    public static void endElement(IElementDefinition item, StringBuffer buffer, String delim) {
        buffer.append('<');
        buffer.append('/');
        buffer.append(item.getName());
        buffer.append('>');
        buffer.append(delim);
    }

    public static void addProcessingInstruction(IProcessingInstruction instruction, StringBuffer buffer, String delim) {
        buffer.append('<');
        buffer.append('?');
        buffer.append(instruction.getTarget());
        buffer.append(' ');
        buffer.append(instruction.getData());
        buffer.append('?');
        buffer.append('>');
        buffer.append(delim);
    }

    public static void padToDepth(int depth, boolean tabs, StringBuffer buffer) {
        int i = 0;
        while (i < depth) {
            if (tabs) {
                buffer.append('\t');
            } else {
                buffer.append(' ');
                buffer.append(' ');
                buffer.append(' ');
                buffer.append(' ');
                buffer.append(' ');
            }
            ++i;
        }
    }
}

