/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core;

import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.xml.core.internal.Messages;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileUtility {
    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyStream(InputStream in, OutputStream out, int expected, IProgressMonitor monitor, String label) throws IOException {
        try {
            block7: {
                int read;
                int total;
                byte[] buffer;
                block6: {
                    monitor.beginTask(Messages.FileUtility_taskCopy, expected);
                    monitor.subTask(Messages.bind((String)Messages.FileUtility_copyMsg, (Object)label));
                    buffer = null;
                    buffer = expected < 102400 && expected > 0 ? new byte[expected] : new byte[102400];
                    total = 0;
                    read = in.read(buffer);
                    if (!true) break block6;
                    if (read <= -1) return;
                    if (monitor.isCanceled()) break block7;
                }
                do {
                    monitor.worked(read);
                    total += read;
                    if (expected > 0) {
                        float percent = (float)total / (float)expected;
                        int p = Math.round(percent *= 100.0f);
                        monitor.subTask(FileUtility.formatUpdateMsg(label, p, expected));
                    }
                    out.write(buffer, 0, read);
                    read = in.read(buffer);
                    if (read <= -1) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            monitor.done();
            FileUtil.close((Closeable)in);
            FileUtil.close((Closeable)out);
        }
    }

    private static String formatUpdateMsg(String label, int percent, int total) {
        total = (int)Math.round((double)total / 100.0);
        return Messages.bind((String)Messages.FileUtility_copyProgress, (Object[])new Object[]{label, percent, total});
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int read = in.read(buffer);
        while (read > -1) {
            out.write(buffer, 0, read);
            read = in.read(buffer);
        }
    }

    public static final String getExt(File f) {
        String name = f.getName();
        int idx = name.lastIndexOf(46);
        if (idx > 0) {
            return name.substring(idx);
        }
        return "";
    }

    public static byte[] getFileBytes(File f) throws Exception {
        byte[] byArray;
        FileInputStream fin = null;
        ByteArrayOutputStream bout = null;
        BufferedInputStream bin = null;
        try {
            fin = new FileInputStream(f);
            bin = new BufferedInputStream(fin);
            bout = new ByteArrayOutputStream();
            FileUtility.copyStream(bin, bout);
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            FileUtil.close(bin);
            FileUtil.close((Closeable)fin);
            FileUtil.close(bout);
            throw throwable;
        }
        FileUtil.close((Closeable)bin);
        FileUtil.close((Closeable)fin);
        FileUtil.close((Closeable)bout);
        return byArray;
    }
}

