/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model.internal;

import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.IP2ArtifactKey;
import com.ibm.cic.p2.model.IP2InstallUnit;
import com.ibm.cic.p2.model.IP2Provide;
import com.ibm.cic.p2.model.IP2Require;
import com.ibm.cic.p2.model.P2Consts;
import com.ibm.cic.p2.model.internal.P2ArtifactKey;
import com.ibm.cic.p2.model.internal.P2IUPatch;
import com.ibm.cic.p2.model.internal.P2Provide;
import com.ibm.cic.p2.model.internal.P2Require;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.osgi.framework.Version;

public class P2IU
implements IP2InstallUnit,
P2Consts,
Comparable {
    private final IInstallableUnit fIu;
    private boolean fSource;

    public static P2IU create(IInstallableUnit iu) {
        if (iu instanceof IInstallableUnitPatch) {
            IInstallableUnitPatch iuPatch = (IInstallableUnitPatch)iu;
            return new P2IUPatch(iuPatch);
        }
        return new P2IU(iu);
    }

    protected P2IU(IInstallableUnit iu) {
        this.fIu = iu;
    }

    public boolean isSource() {
        return this.fSource;
    }

    @Override
    public String getId() {
        return this.fIu.getId();
    }

    @Override
    public Version getVersion() {
        return CicP2Model.toOSGiVersion(this.fIu.getVersion());
    }

    @Override
    public IP2Provide[] getProvides(String namespace) {
        Collection provides = this.fIu.getProvidedCapabilities();
        ArrayList<P2Provide> vals = new ArrayList<P2Provide>();
        for (IProvidedCapability provide : provides) {
            if (!provide.getNamespace().equals(namespace)) continue;
            vals.add(new P2Provide(provide));
        }
        return vals.toArray(new IP2Provide[vals.size()]);
    }

    @Override
    public IP2Provide[] getProvides() {
        Collection provides = this.fIu.getProvidedCapabilities();
        IP2Provide[] ret = new IP2Provide[provides.size()];
        int i = 0;
        for (IProvidedCapability provide : provides) {
            ret[i++] = new P2Provide(provide);
        }
        return ret;
    }

    @Override
    public IP2Require[] getRequires(String namespace) {
        Collection reqs = this.fIu.getRequirements();
        ArrayList<P2Require> vals = new ArrayList<P2Require>();
        for (Object reqObj : reqs) {
            IRequiredCapability req;
            if (!(reqObj instanceof IRequiredCapability) || !(req = (IRequiredCapability)reqObj).getNamespace().equals(namespace)) continue;
            vals.add(new P2Require(req));
        }
        return vals.toArray(new IP2Require[vals.size()]);
    }

    @Override
    public IP2Require[] getRequires() {
        Collection reqs = this.fIu.getRequirements();
        ArrayList<P2Require> vals = new ArrayList<P2Require>(reqs.size());
        for (Object reqObj : reqs) {
            if (!(reqObj instanceof IRequiredCapability)) continue;
            IRequiredCapability req = (IRequiredCapability)reqObj;
            vals.add(new P2Require(req));
        }
        return vals.toArray(new IP2Require[vals.size()]);
    }

    @Override
    public IP2ArtifactKey[] getArtifacts() {
        Collection arts = this.fIu.getArtifacts();
        IP2ArtifactKey[] ret = new IP2ArtifactKey[arts.size()];
        int i = 0;
        for (IArtifactKey key : arts) {
            ret[i++] = new P2ArtifactKey(key);
        }
        return ret;
    }

    @Override
    public IP2Require[] getRequiredIUs() {
        return this.getRequires("org.eclipse.equinox.p2.iu");
    }

    @Override
    public boolean isSingleton() {
        return this.fIu.isSingleton();
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof P2IU) {
            return ((P2IU)arg0).fIu.compareTo((Object)this.fIu);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof P2IU) {
            P2IU other = (P2IU)o;
            return other.fIu.equals((Object)this.fIu);
        }
        return super.equals(o);
    }

    public Object getAdapter(Class adapter) {
        if (IInstallableUnit.class.equals((Object)adapter)) {
            return this.fIu;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public String getVersionStr() {
        return this.fIu.getVersion().toString();
    }

    @Override
    public String getFilter() {
        IMatchExpression filter = this.fIu.getFilter();
        if (filter != null) {
            return filter.getParameters()[0].toString();
        }
        return null;
    }

    @Override
    public boolean isZipped() {
        ITouchpointType type = this.fIu.getTouchpointType();
        if (type == null || type == ITouchpointType.NONE) {
            return false;
        }
        if (!type.getId().equals("org.eclipse.equinox.p2.osgi")) {
            return false;
        }
        Collection tpdColl = this.fIu.getTouchpointData();
        if (tpdColl == null) {
            return false;
        }
        for (ITouchpointData tpd : tpdColl) {
            if (tpd.getInstruction("zipped") == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean satisfies(IP2Require req) {
        IRequiredCapability cap = (IRequiredCapability)req.getAdapter(IRequiredCapability.class);
        return this.fIu.satisfies((IRequirement)cap);
    }

    public String toString() {
        return this.fIu.toString();
    }

    public int hashCode() {
        return this.fIu.hashCode();
    }
}

