/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model.internal;

import com.ibm.cic.common.commonNativeAdapterData.ZipArtifact;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.eclipseAdapterData.EclipseArtifact;
import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.IP2ArtifactKey;
import com.ibm.cic.p2.model.internal.P2ArtifactKeyUtil;
import org.eclipse.core.runtime.Platform;

public class P2ArtifactKey
implements IP2ArtifactKey {
    private final org.eclipse.equinox.p2.metadata.IArtifactKey fKey;

    public P2ArtifactKey(org.eclipse.equinox.p2.metadata.IArtifactKey key) {
        this.fKey = key;
    }

    @Override
    public String getClassifier() {
        return this.fKey.getClassifier();
    }

    public String toString() {
        return this.fKey.toExternalForm();
    }

    @Override
    public String getId() {
        return this.fKey.getId();
    }

    @Override
    public String getVersionStr() {
        return this.fKey.getVersion().toString();
    }

    @Override
    public IArtifact toArtifact() {
        String classifier = this.fKey.getClassifier();
        if ("osgi.bundle".equals(classifier)) {
            EclipseArtifact eaf = new EclipseArtifact(null, null, (IIdentity)new SimpleIdentity(this.fKey.getId()), CicP2Model.toOSGiVersion(this.fKey.getVersion()), 2, false);
            return eaf;
        }
        if ("org.eclipse.update.feature".equals(classifier)) {
            EclipseArtifact eaf = new EclipseArtifact(null, null, (IIdentity)new SimpleIdentity(this.fKey.getId()), CicP2Model.toOSGiVersion(this.fKey.getVersion()), 3, false);
            return eaf;
        }
        if ("binary".equals(classifier)) {
            ArtifactCommonAttributes atrAttrs = new ArtifactCommonAttributes();
            atrAttrs.setId(this.fKey.getId());
            atrAttrs.setVersion(CicP2Model.toOSGiVersion(this.fKey.getVersion()));
            return new ZipArtifact(atrAttrs);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (org.eclipse.equinox.p2.metadata.IArtifactKey.class.equals((Object)adapter)) {
            return this.fKey;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IArtifactKey toCicKey() {
        return P2ArtifactKeyUtil.toCicKey(this.fKey);
    }

    public boolean equals(Object o) {
        if (!super.equals(o) && o instanceof P2ArtifactKey) {
            return this.fKey.equals(((P2ArtifactKey)o).fKey);
        }
        return false;
    }

    public int hashCode() {
        return Util.hashCode((Object)this.fKey);
    }
}

