/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.AbstractNTLMMessageGenerator;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.AuthenticateMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMCrypto;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.SendMessage;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMUserCredentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.apache.commons.httpclient.auth.AuthenticationException;

public class NTLMv1MessageGenerator
extends AbstractNTLMMessageGenerator {
    public NTLMv1MessageGenerator(NTLMUserCredentials userCredentials, String clientWorkStation) {
        super(userCredentials, clientWorkStation);
    }

    @Override
    protected byte[] createNegotiateMessage() throws IOException {
        return NegotiateMessage.createMessage();
    }

    @Override
    protected byte[] computeAuthenticateMessage() throws GeneralSecurityException, IOException {
        this.computeResponse();
        int flags = 0x88607 & this.challenge.getNegotiateFlags();
        byte[] authenticate = AuthenticateMessage.createAuthenticateMessage(this.challenge, this.userCredentials, null, flags, this.lmChallengeResponse, this.ntChallengeResponse);
        return authenticate;
    }

    private void computeResponse() throws UnsupportedEncodingException, GeneralSecurityException, AuthenticationException {
        assert (this.challenge.getChallenge().length == 8);
        String password = this.userCredentials.getPassword();
        byte[] responseKeyNT = NTLMCrypto.NTOWFv1(password);
        if ((this.challenge.getNegotiateFlags() & 0x80000) != 0) {
            byte[] random = NTLMv1MessageGenerator.genRandom(this.challenge);
            if (log.isDebugLoggable()) {
                log.debug("NTLMv1 EXTENDED_SESSION_SECURITY computing using server challenge [{0}], client random [{1}]", new Object[]{BitUtil.bytesToHexString(this.challenge.getChallenge()), BitUtil.bytesToHexString(random)});
            }
            byte[] bytes = BitUtil.concat(new byte[][]{this.challenge.getChallenge(), random});
            bytes = NTLMCrypto.MD5(bytes);
            this.ntChallengeResponse = NTLMCrypto.DESL(responseKeyNT, BitUtil.subArray(bytes, 0, 8));
            this.lmChallengeResponse = BitUtil.concat(new byte[][]{random, new byte[16]});
        } else {
            if (log.isDebugLoggable()) {
                log.debug("NTLMv1 computing NEGOTIATE_NT_ONLY using server challenge [{0}]", new Object[]{BitUtil.bytesToHexString(this.challenge.getChallenge())});
            }
            this.ntChallengeResponse = NTLMCrypto.DESL(responseKeyNT, this.challenge.getChallenge());
            this.lmChallengeResponse = this.ntChallengeResponse;
        }
    }

    @Override
    public boolean isLoggingDetails() {
        return true;
    }

    private static class NegotiateMessage
    extends SendMessage {
        public static final int FLAGS = 558599;

        private NegotiateMessage() {
        }

        public static byte[] createMessage() throws IOException {
            int size = NTLMConstants.SIGNATURE_BYTES.length + 4 + 4 + 2 + 2 + 4 + 2 + 2 + 4;
            ByteArrayOutputStream bs = new ByteArrayOutputStream(size);
            bs.write(NTLMConstants.SIGNATURE_BYTES);
            NegotiateMessage.writeInt(bs, 1);
            NegotiateMessage.writeInt(bs, 558599);
            int offsetPtrUserDomain = NegotiateMessage.field(bs, 0);
            int offsetPtrWorkStation = NegotiateMessage.field(bs, 0);
            int pos = bs.size();
            byte[] buf = bs.toByteArray();
            pos = NegotiateMessage.writeData(buf, offsetPtrUserDomain, pos, EMPTY_BYTES);
            NegotiateMessage.writeData(buf, offsetPtrWorkStation, pos, EMPTY_BYTES);
            return buf;
        }
    }
}

