/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.ChallengeMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.LogNTLMMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMConstants;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.SendMessage;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMUserCredentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AuthenticateMessage
extends SendMessage {
    public static byte[] createAuthenticateMessage(ChallengeMessage challenge, NTLMUserCredentials userCredentials, String workStation, int flags, byte[] lmChallengeResponse, byte[] ntChallengeResponse) throws IOException {
        byte[] bWorkStation;
        byte[] bUserName;
        byte[] bUserDomain;
        if (workStation == null) {
            workStation = "";
        }
        String userDomain = userCredentials.getDomain();
        String userName = userCredentials.getUsername();
        int size = 100;
        ByteArrayOutputStream bs = new ByteArrayOutputStream(size);
        bs.write(NTLMConstants.SIGNATURE_BYTES);
        bs.write(3);
        AuthenticateMessage.fill(bs, 3);
        int offsetPtrLmChallengeResponse = AuthenticateMessage.field(bs, lmChallengeResponse.length);
        int offsetPtrNtChallengeResponse = AuthenticateMessage.field(bs, ntChallengeResponse.length);
        if ((challenge.getNegotiateFlags() & 1) != 0) {
            bUserDomain = userDomain.getBytes("UTF-16LE");
            bUserName = userName.getBytes("UTF-16LE");
            bWorkStation = workStation.getBytes("UTF-16LE");
        } else {
            String credentialCharset = userCredentials.getUsernameOemCharset();
            if (credentialCharset == null) {
                credentialCharset = NTLMUtil.getOEMEncoding();
            }
            bUserDomain = userDomain.getBytes(NTLMUtil.getOEMEncoding());
            bUserName = userName.getBytes(credentialCharset);
            bWorkStation = workStation.getBytes(NTLMUtil.getOEMEncoding());
        }
        if (log.isDebugLoggable()) {
            LogNTLMMessage.logFlags(log, 3, flags);
            LogNTLMMessage.logStringData(log, 3, "DomainName", bUserDomain, userDomain);
            LogNTLMMessage.logStringData(log, 3, "UserName", bUserName, userName);
            LogNTLMMessage.logStringData(log, 3, "Workstation", bWorkStation, workStation);
            LogNTLMMessage.logData(log, 3, "LmChallengeResponse", lmChallengeResponse);
            LogNTLMMessage.logData(log, 3, "NtChallengeResponse", ntChallengeResponse);
        }
        int offsetPtrUserDomain = AuthenticateMessage.field(bs, bUserDomain.length);
        int offsetPtrUserName = AuthenticateMessage.field(bs, bUserName.length);
        int offsetPtrWorkStation = AuthenticateMessage.field(bs, bWorkStation.length);
        int offsetPtrEncryptedRandomSessionKey = AuthenticateMessage.field(bs, 0);
        AuthenticateMessage.writeInt(bs, flags);
        int dataLen = lmChallengeResponse.length + ntChallengeResponse.length + bUserDomain.length + bUserName.length + bWorkStation.length;
        int pos = bs.size();
        AuthenticateMessage.fill(bs, dataLen);
        byte[] buf = bs.toByteArray();
        pos = AuthenticateMessage.writeData(buf, offsetPtrLmChallengeResponse, pos, lmChallengeResponse);
        pos = AuthenticateMessage.writeData(buf, offsetPtrNtChallengeResponse, pos, ntChallengeResponse);
        pos = AuthenticateMessage.writeData(buf, offsetPtrUserDomain, pos, bUserDomain);
        pos = AuthenticateMessage.writeData(buf, offsetPtrUserName, pos, bUserName);
        pos = AuthenticateMessage.writeData(buf, offsetPtrWorkStation, pos, bWorkStation);
        pos = AuthenticateMessage.writeData(buf, offsetPtrEncryptedRandomSessionKey, pos, EMPTY_BYTES);
        return buf;
    }
}

