/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util.buffer;

import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.rmi.util.list.LinkedList;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class SequentialByteBuffer
extends ByteBuffer {
    private static final int MIN_PIECE_SIZE = 1024;
    private static final int MAX_PIECE_SIZE = 0x100000;
    private int pieceSize = 1024;
    private int initialPieceSize;
    private final LinkedList pieces = new LinkedList();
    private int headPieceCursor = 0;
    private int tailPieceCursor = 0;
    private int dataPieceCursor = 0;
    private int headOffset = 0;
    private int tailOffset = 0;
    private int availableData = 0;
    private int availableSpace = 0;

    public SequentialByteBuffer(int n) {
        while (this.pieceSize < n) {
            this.pieceSize *= 2;
            if (this.pieceSize < 0x100000) continue;
            this.pieceSize = 0x100000;
            break;
        }
        this.pieceSize /= 2;
        this.initialPieceSize = this.pieceSize;
    }

    private Piece incrementHeadCursor(int n, Piece piece) {
        this.availableData -= n;
        this.headOffset += n;
        this.invalidatePositions(this.headOffset);
        this.headPieceCursor += n;
        while (this.headPieceCursor >= piece.data.length) {
            this.headPieceCursor -= piece.data.length;
            this.releaseByteArray(piece.data);
            if ((piece = (Piece)piece.getNext()) != null) continue;
        }
        if (this.availableData == 0) {
            this.invalidateAllPositions();
            this.pieces.clear();
            this.tailOffset = 0;
            this.headOffset = 0;
            this.dataPieceCursor = 0;
            this.tailPieceCursor = 0;
            this.headPieceCursor = 0;
            this.availableSpace = 0;
            piece = null;
        } else {
            this.pieces.clearBeforeItem(piece);
        }
        return piece;
    }

    private void incrementTailCursor(int n) {
        this.availableData += n;
        this.tailOffset += n;
        this.availableSpace -= n;
        this.tailPieceCursor += n;
    }

    private Piece incrementDataCursor(int n, Piece piece) {
        this.dataPieceCursor += n;
        while (this.dataPieceCursor >= piece.data.length) {
            this.dataPieceCursor -= piece.data.length;
            if ((piece = (Piece)piece.getNext()) != null) continue;
            break;
        }
        return piece;
    }

    private Piece setDataCursor(Position position, int n) {
        this.dataPieceCursor = position.getPieceOffset();
        Piece piece = this.incrementDataCursor(n, position.getPiece());
        return piece;
    }

    private Piece setDataCursorToHead() {
        this.dataPieceCursor = this.headPieceCursor;
        Piece piece = (Piece)this.pieces.getFirst();
        return piece;
    }

    private Piece addPiece(int n) {
        byte[] byArray = null;
        if (this.pieceSize < 0x100000) {
            do {
                this.pieceSize *= 2;
                if (this.pieceSize < 0x100000) continue;
                this.pieceSize = 0x100000;
                break;
            } while (this.pieceSize < n);
        }
        try {
            byArray = this.allocByteArray(this.pieceSize);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.pieceSize = 1024;
            byArray = this.allocByteArray(this.pieceSize);
        }
        Piece piece = new Piece(byArray);
        this.pieces.addLast(piece);
        this.availableSpace = piece.data.length;
        this.tailPieceCursor = 0;
        return piece;
    }

    private Piece getTailPiece() {
        Piece piece = (Piece)this.pieces.getLast();
        if (piece == null) {
            piece = this.addPiece(1);
        }
        return piece;
    }

    @Override
    public synchronized int getAvailableSpace() {
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized ByteBuffer.Position getWritePosition() {
        Position position = (Position)this.getLastPosition();
        if (position != null && !position.equals(this, this.tailOffset)) {
            position = null;
        }
        if (position == null) {
            Piece piece = this.getTailPiece();
            position = new Position(this, this.tailOffset, piece, this.tailPieceCursor);
        }
        return position;
    }

    @Override
    public synchronized int getWriteOffset() {
        return this.tailOffset;
    }

    @Override
    public synchronized int getSize() {
        return this.availableData;
    }

    @Override
    public synchronized void reset() {
        if (this.availableData > 0) {
            Piece piece = (Piece)this.pieces.getFirst();
            this.incrementHeadCursor(this.availableData, piece);
        }
        this.pieceSize = this.initialPieceSize;
    }

    @Override
    public synchronized int read() {
        int n = -1;
        if (this.availableData > 0) {
            Piece piece = (Piece)this.pieces.getFirst();
            n = piece.data[this.headPieceCursor];
            this.incrementHeadCursor(1, piece);
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) {
        int n3;
        ByteBuffer.checkParams(byArray, n, n2);
        n2 = n3 = Math.min(n2, this.availableData);
        if (n2 > 0) {
            int n4;
            Piece piece = (Piece)this.pieces.getFirst();
            do {
                n4 = Math.min(n2, piece.data.length - this.headPieceCursor);
                System.arraycopy(piece.data, this.headPieceCursor, byArray, n, n4);
                piece = this.incrementHeadCursor(n4, piece);
                n += n4;
            } while ((n2 -= n4) > 0);
        }
        return n3;
    }

    @Override
    public synchronized void write(byte by) {
        Piece piece = this.getTailPiece();
        if (this.availableSpace == 0) {
            piece = this.addPiece(1);
        }
        piece.data[this.tailPieceCursor] = by;
        this.incrementTailCursor(1);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        ByteBuffer.checkParams(byArray, n, n2);
        if (n2 > 0) {
            int n3;
            Piece piece = (Piece)this.pieces.getLast();
            do {
                if (this.availableSpace == 0) {
                    piece = this.addPiece(n2);
                }
                n3 = Math.min(n2, this.availableSpace);
                System.arraycopy(byArray, n, piece.data, this.tailPieceCursor, n3);
                this.incrementTailCursor(n3);
                n += n3;
            } while ((n2 -= n3) > 0);
        }
    }

    @Override
    public synchronized void write(byte by, ByteBuffer.Position position, int n) {
        if (position == null) {
            this.write(by);
            return;
        }
        ByteBuffer.checkUpdateByteParams(position.getOffset() + n, this.tailOffset);
        Piece piece = this.setDataCursor((Position)position, n);
        piece.data[this.dataPieceCursor] = by;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2, ByteBuffer.Position position, int n3) {
        if (position == null) {
            this.write(byArray, n, n2);
            return;
        }
        ByteBuffer.checkUpdateParams(byArray, n, n2, position.getOffset() + n3, this.tailOffset);
        if (n2 > 0) {
            int n4;
            Piece piece = this.setDataCursor((Position)position, n3);
            do {
                n4 = Math.min(n2, piece.data.length - this.dataPieceCursor);
                System.arraycopy(byArray, n, piece.data, this.dataPieceCursor, n4);
                piece = this.incrementDataCursor(n4, piece);
                n += n4;
            } while ((n2 -= n4) > 0);
        }
    }

    private void flushDataTo(CDRWriter cDRWriter) {
        Piece piece = (Piece)this.pieces.getFirst();
        boolean bl = true;
        while (this.availableData > 0) {
            int n = Math.min(this.availableData, piece.data.length - this.headPieceCursor);
            cDRWriter.writeOctetArrayPiece(piece.data, this.headPieceCursor, n, bl, this.availableData);
            bl = false;
            piece = this.incrementHeadCursor(n, piece);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flushTo(OutputStream outputStream) throws IOException {
        if (outputStream != null && this.availableData > 0) {
            Piece piece = (Piece)this.pieces.getFirst();
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                do {
                    int n = Math.min(this.availableData, piece.data.length - this.headPieceCursor);
                    int n2 = 0;
                    while (true) {
                        try {
                            outputStream.write(piece.data, this.headPieceCursor + n2, n - n2);
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            n2 += interruptedIOException.bytesTransferred;
                            continue;
                        }
                        break;
                    }
                    piece = this.incrementHeadCursor(n, piece);
                } while (this.availableData > 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushTo(OutputStream outputStream, Connection connection) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            try {
                connection.stuckInWriteBlock = false;
                connection.inWriteBlock = true;
                this.flushTo(outputStream);
            }
            catch (IOException iOException) {
                if (connection.writeTimeoutOccured) {
                    IIOPOutputStream.SocketWriteTimeOutException socketWriteTimeOutException = new IIOPOutputStream.SocketWriteTimeOutException("Socket write timed out for connection to " + connection.getRemoteHost() + " at port " + connection.getRemotePort());
                    socketWriteTimeOutException.initCause(iOException);
                    throw socketWriteTimeOutException;
                }
                throw iOException;
            }
            finally {
                connection.inWriteBlock = false;
                connection.stuckInWriteBlock = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flushTo(org.omg.CORBA.portable.OutputStream outputStream) {
        if (outputStream != null) {
            org.omg.CORBA.portable.OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                outputStream.write_long(this.availableData);
                if (outputStream instanceof CDRWriter) {
                    this.flushDataTo((CDRWriter)outputStream);
                } else {
                    byte[] byArray = this.toByteArray();
                    this.reset();
                    outputStream.write_octet_array(byArray, 0, byArray.length);
                }
            }
        }
    }

    private void copyDataToByteArray(Piece piece, byte[] byArray) {
        int n;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = Math.min(i, piece.data.length - this.dataPieceCursor);
            System.arraycopy(piece.data, this.dataPieceCursor, byArray, n2, n);
            piece = this.incrementDataCursor(n, piece);
            n2 += n;
        }
    }

    @Override
    public synchronized byte[] toByteArray() {
        byte[] byArray;
        if (this.availableData == 0) {
            byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        } else {
            byArray = this.allocByteArray(this.availableData);
            Piece piece = this.setDataCursorToHead();
            this.copyDataToByteArray(piece, byArray);
        }
        return byArray;
    }

    @Override
    public synchronized byte[] toByteArrayFrom(ByteBuffer.Position position) {
        byte[] byArray;
        if (position == null || !position.isValid(this)) {
            byArray = ByteBuffer.ZERO_BYTE_ARRAY;
        } else {
            int n = position.getOffset();
            if (n == this.tailOffset) {
                byArray = ByteBuffer.ZERO_BYTE_ARRAY;
            } else {
                byArray = this.allocByteArray(this.tailOffset - n);
                Piece piece = this.setDataCursor((Position)position, 0);
                this.copyDataToByteArray(piece, byArray);
            }
        }
        return byArray;
    }

    @Override
    public synchronized String toString() {
        StringWriter stringWriter = new StringWriter(this.availableData * 2);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        int n2 = 0;
        Piece piece = this.setDataCursorToHead();
        for (int i = 0; i < this.availableData; i += n) {
            if (i + 16 > this.availableData) {
                n = Math.min(this.availableData - i, piece.data.length - this.dataPieceCursor);
                if (n == this.availableData - i) {
                    n2 = 16 - n;
                }
            } else {
                n = 16;
            }
            ByteBuffer.writeHexString(printWriter, piece.data, this.dataPieceCursor, n, n2);
            printWriter.println(new String(piece.data, this.dataPieceCursor, n));
            piece = this.incrementDataCursor(n, piece);
        }
        return stringWriter.toString();
    }

    private static final class Piece
    extends LinkedList.Item {
        final byte[] data;

        Piece(byte[] byArray) {
            this.data = byArray;
        }

        public final boolean equals(Object object) {
            return object == this;
        }

        public final int hashCode() {
            return System.identityHashCode(this);
        }
    }

    public static final class Position
    extends ByteBuffer.Position {
        private Piece piece;
        private final int pieceOffset;

        Position(ByteBuffer byteBuffer, int n, Piece piece, int n2) {
            super(byteBuffer, n, false);
            this.piece = piece;
            this.pieceOffset = n2;
            byteBuffer.addPosition(this);
        }

        Piece getPiece() {
            this.checkValidity();
            return this.piece;
        }

        int getPieceOffset() {
            this.checkValidity();
            return this.pieceOffset;
        }

        @Override
        void invalidate() {
            super.invalidate();
            this.piece = null;
        }
    }
}

