/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.io.GetNoArgConstructorAction;
import com.ibm.rmi.io.NoArgNewInstanceAction;
import com.ibm.rmi.io.ObjectStreamClass;
import java.io.InvalidClassException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class ExternalizableFactory {
    private static final String CLASS = ExternalizableFactory.class.getName();

    static Object allocateNewExternalizableObject(Class clazz, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = (PrivilegedExceptionAction)objectStreamClass.getSerializableFactoryData();
            if (null == privilegedExceptionAction) {
                privilegedExceptionAction = ExternalizableFactory.getNewExternalizableAction(clazz);
                privilegedExceptionAction = (PrivilegedExceptionAction)objectStreamClass.getSerializableFactoryData(privilegedExceptionAction);
            }
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            InvalidClassException invalidClassException = null;
            if (throwable instanceof InvalidClassException) {
                invalidClassException = (InvalidClassException)throwable;
            } else {
                invalidClassException = new InvalidClassException(clazz.getName(), throwable.getMessage());
                invalidClassException.initCause(throwable);
            }
            Trc.ffdc(invalidClassException, CLASS, "allocateNewExternalizableObject:73");
            throw invalidClassException;
        }
        catch (InvalidClassException invalidClassException) {
            Trc.ffdc(invalidClassException, CLASS, "allocateNewExternalizableObject:76");
            throw invalidClassException;
        }
    }

    private static PrivilegedExceptionAction getNewExternalizableAction(Class clazz) throws InvalidClassException {
        try {
            GetNoArgConstructorAction getNoArgConstructorAction = new GetNoArgConstructorAction(clazz);
            Constructor constructor = (Constructor)AccessController.doPrivileged(getNoArgConstructorAction);
            if ((constructor.getModifiers() & 1) == 0) {
                throw new InvalidClassException(clazz.getName(), "Default constructor of Externalizable should be public");
            }
            return new NoArgNewInstanceAction(constructor);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InvalidClassException)privilegedActionException.getCause();
        }
    }
}

