/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.Aligner;
import com.ibm.jtc.orb.nio.CDRInputHandler;
import com.ibm.rmi.IOR;
import com.ibm.rmi.ServiceContext;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CDRReader;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.iiop.GIOPReplyContext;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ServiceContextList;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class ReplyMessage
extends Message {
    private static final String CLASS = ReplyMessage.class.getName();
    private ServiceContextList serviceContexts = new ServiceContextList();
    protected int status;
    protected String exceptionId;
    protected String exClassName;
    protected int minorCode;
    protected CompletionStatus completionStatus;
    protected short addressingDisposition = (short)-1;
    protected IOR ior;
    protected boolean needsReAddressing;
    private SystemException sysEx = null;
    private Exception usrEx = null;
    public static final int NO_EXCEPTION = 0;
    public static final int USER_EXCEPTION = 1;
    public static final int SYSTEM_EXCEPTION = 2;
    public static final int LOCATION_FORWARD = 3;
    public static final int LOCATION_FORWARD_PERM = 4;
    public static final int NEEDS_ADDRESSING_MODE = 5;
    private static final Class[] stringParam = new Class[]{String.class};

    public ReplyMessage(byte by, byte by2) {
        super(by, by2);
    }

    public ReplyMessage(com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray, int n, int n2, byte by, byte by2) {
        super(by, by2);
        this.setType(1);
        this.requestId = n;
        this.status = n2;
        this.setServiceContextList(serviceContextArray);
    }

    public ReplyMessage(com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray, int n, int n2, SystemException systemException, byte by, byte by2) {
        this(serviceContextArray, n, n2, by, by2);
        this.exClassName = ((Object)((Object)systemException)).getClass().getName();
        this.minorCode = systemException.minor;
        this.completionStatus = systemException.completed;
    }

    public ReplyMessage() {
    }

    public com.ibm.CORBA.iiop.ServiceContext[] getServiceContextList() {
        return this.serviceContexts.get();
    }

    public void setServiceContextList(com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray) {
        this.serviceContexts.set(serviceContextArray);
    }

    public ServiceContextList getServiceContexts() {
        return this.serviceContexts;
    }

    public void setServiceContexts(ServiceContextList serviceContextList) {
        this.serviceContexts = serviceContextList;
    }

    public com.ibm.CORBA.iiop.ServiceContext getServiceContext(int n) {
        return this.serviceContexts.getServiceContext(n);
    }

    public boolean setServiceContext(com.ibm.CORBA.iiop.ServiceContext serviceContext, boolean bl) {
        return this.serviceContexts.add(serviceContext, bl);
    }

    public int getReplyStatus() {
        return this.status;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public int getMinorCode() {
        return this.minorCode;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public boolean needsReAddressing() {
        return this.needsReAddressing;
    }

    public short getAddressingDisposition() {
        return this.addressingDisposition;
    }

    public SystemException getSystemException() {
        if (this.sysEx == null) {
            this.sysEx = this._getSystemException();
        }
        return this.sysEx;
    }

    public Exception getUserException() {
        if (this.usrEx == null) {
            this.usrEx = this._getUserException();
        }
        return this.usrEx;
    }

    private Exception _getUserException() {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINEST, this.exClassName, CLASS, "_getUserException:233");
        }
        Exception exception = null;
        try {
            Class clazz;
            block12: {
                try {
                    if (this.exClassName == null) {
                        return Utility.getUnknownForUserException();
                    }
                    clazz = Util.loadClass((String)this.exClassName, null, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Trc.enabled()) {
                        Trc.warn(classNotFoundException.toString(), CLASS, "_getUserException:247");
                    }
                    return Utility.getUnknownForUserException();
                }
                try {
                    Object[] objectArray = new Object[]{""};
                    Constructor constructor = clazz.getConstructor(stringParam);
                    exception = (Exception)constructor.newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    Trc.ffdc(throwable.toString() + throwable, CLASS, "_getUserException:263");
                    if (!(throwable instanceof ThreadDeath)) break block12;
                    throw (ThreadDeath)throwable;
                }
            }
            if (exception == null) {
                exception = (Exception)clazz.newInstance();
            }
        }
        catch (Throwable throwable) {
            Trc.ffdc(throwable.toString() + throwable, CLASS, "_getUserException:277");
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new INTERNAL("BAD SystemException: " + this.exClassName, 1229125014, CompletionStatus.COMPLETED_MAYBE);
        }
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINEST, exception, CLASS, "_getUserException:288");
        }
        return exception;
    }

    private SystemException _getSystemException() {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINEST, this.exClassName, CLASS, "_getSystemException:297");
        }
        SystemException systemException = null;
        try {
            Class<UNKNOWN> clazz;
            block12: {
                try {
                    clazz = Util.loadClass((String)this.exClassName, null, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Trc.enabled()) {
                        Trc.warn(classNotFoundException.toString(), CLASS, "_getSystemException:308");
                    }
                    clazz = UNKNOWN.class;
                }
                com.ibm.CORBA.iiop.ServiceContext serviceContext = this.getServiceContext(14);
                if (serviceContext != null) {
                    try {
                        final byte[] byArray = serviceContext.getContextData();
                        CDRInputStream cDRInputStream = (CDRInputStream)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return new CDRInputStream((org.omg.CORBA.ORB)null, byArray, byArray.length);
                            }
                        });
                        cDRInputStream.consumeEndian();
                        String string = cDRInputStream.read_wstring();
                        Object[] objectArray = new Object[]{string};
                        Constructor constructor = clazz.getConstructor(stringParam);
                        systemException = (SystemException)((Object)constructor.newInstance(objectArray));
                    }
                    catch (Throwable throwable) {
                        Trc.ffdc(throwable.toString() + throwable, CLASS, "_getSystemException:344");
                        if (!(throwable instanceof ThreadDeath)) break block12;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
            if (systemException == null) {
                systemException = (SystemException)((Object)clazz.newInstance());
            }
        }
        catch (Throwable throwable) {
            Trc.ffdc(throwable.toString() + throwable, CLASS, "_getSystemException:357");
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new INTERNAL("BAD SystemException: " + this.exClassName, 1229125014, CompletionStatus.COMPLETED_MAYBE);
        }
        systemException.minor = this.minorCode;
        systemException.completed = this.completionStatus;
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINEST, systemException.toString(), CLASS, "_getSystemException:370");
        }
        return systemException;
    }

    @Override
    public GIOPMessageContext flushToMessageContext(ByteBuffer byteBuffer) throws Exception {
        this.msgContext = new GIOPReplyContext(this, byteBuffer);
        return this.msgContext;
    }

    @Override
    public GIOPMessageContext createMessageContext(WsByteBuffer[] wsByteBufferArray) throws Exception {
        this.msgContext = new GIOPReplyContext(this, wsByteBufferArray, this.getBodyOffset());
        return this.msgContext;
    }

    private boolean needAlignmentContext(int n) {
        int n2 = this.alignToWordBoundary(n);
        return n2 % 8 != 0;
    }

    @Override
    public void write(CDRWriter cDRWriter) throws SystemException {
        com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray = null;
        super.write(cDRWriter);
        if (this.preGIOP12()) {
            serviceContextArray = this.getServiceContextList();
            if (serviceContextArray != null) {
                Object object = cDRWriter.writePlaceHolderLong(serviceContextArray.length);
                for (int i = 0; i < serviceContextArray.length; ++i) {
                    ((ServiceContext)serviceContextArray[i]).write((OutputStream)cDRWriter);
                }
                if (this.needAlignmentContext(cDRWriter.get_offset())) {
                    this.addAlignmentContext(cDRWriter, serviceContextArray.length + 1, object);
                }
            } else {
                cDRWriter.write_long(0);
            }
            cDRWriter.write_long(this.requestId);
            cDRWriter.write_long(this.status);
        } else {
            cDRWriter.write_long(this.requestId);
            cDRWriter.write_long(this.status);
            serviceContextArray = this.getServiceContextList();
            if (serviceContextArray != null) {
                cDRWriter.write_long(serviceContextArray.length);
                for (int i = 0; i < serviceContextArray.length; ++i) {
                    ((ServiceContext)serviceContextArray[i]).write((OutputStream)cDRWriter);
                }
            } else {
                cDRWriter.write_long(0);
            }
            cDRWriter.setPaddingPending();
        }
        this.setHeaderWritten(true);
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINEST, "offset = " + this.getWriteOffset(), CLASS, "write:479");
        }
    }

    @Override
    public void read(InputStream inputStream) throws SystemException {
        int n;
        int n2;
        com.ibm.CORBA.iiop.ServiceContext[] serviceContextArray = null;
        CDRReader cDRReader = (CDRReader)inputStream;
        if (this.preGIOP12()) {
            n2 = inputStream.read_long();
            if (n2 > ((CDRReader)inputStream).getSize()) {
                throw new MARSHAL("Encountered malformed request while reading reply message (1)", 1229126026, CompletionStatus.COMPLETED_NO);
            }
            serviceContextArray = new ServiceContext[n2];
            for (n = 0; n < serviceContextArray.length; ++n) {
                serviceContextArray[n] = new ServiceContext();
                ((ServiceContext)serviceContextArray[n]).read(inputStream);
            }
            this.setServiceContextList(serviceContextArray);
            this.requestId = inputStream.read_long();
            this.status = inputStream.read_long();
        } else {
            if (inputStream instanceof CDRInputHandler) {
                this.requestId = inputStream.read_long();
            }
            this.status = inputStream.read_long();
            if (this.status == 4) {
                this.status = 3;
            }
            try {
                serviceContextArray = new ServiceContext[inputStream.read_long()];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("Encountered malformed request while reading reply message (2)", 1229126027, CompletionStatus.COMPLETED_NO);
            }
            for (n2 = 0; n2 < serviceContextArray.length; ++n2) {
                serviceContextArray[n2] = new ServiceContext();
                ((ServiceContext)serviceContextArray[n2]).read(inputStream);
            }
            this.setServiceContextList(serviceContextArray);
            if (!cDRReader.isAtEnd()) {
                cDRReader.alignAndCheck(Aligner.EIGHT, 8, 0);
            }
        }
        if (this.status == 2) {
            String string = inputStream.read_string();
            this.exClassName = Utility.classNameOf(string);
            this.minorCode = inputStream.read_long();
            n = inputStream.read_long();
            switch (n) {
                case 0: {
                    this.completionStatus = CompletionStatus.COMPLETED_YES;
                    break;
                }
                case 1: {
                    this.completionStatus = CompletionStatus.COMPLETED_NO;
                    break;
                }
                case 2: {
                    this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                    break;
                }
                default: {
                    throw new INTERNAL("BAD completion status: " + n, 1229125015, CompletionStatus.COMPLETED_MAYBE);
                }
            }
        } else if (this.status == 1) {
            this.exceptionId = cDRReader.peekUserExceptionId();
            try {
                Class clazz = RepositoryId.get(this.exceptionId).getClassFromType();
                this.exClassName = clazz.getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINEST, classNotFoundException, CLASS, "read:568");
                }
            }
        } else if (this.status == 3) {
            this.ior = (IOR)ORB.createIOR((ORB)cDRReader.getOrb());
            this.ior.read(inputStream);
        } else if (this.status == 5) {
            this.addressingDisposition = inputStream.read_short();
            this.needsReAddressing = true;
        }
        this.setBodyOffset(((CDRReader)inputStream).get_offset());
        if (Trc.enabled(1)) {
            Trc.info(Trc.FINEST, this + " bodyOffset =" + this.bodyOffset, CLASS, "read:589");
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.serviceContexts);
        objectOutput.writeInt(this.status);
        if (this.status == 2) {
            objectOutput.writeObject(this.exClassName);
            objectOutput.writeInt(this.minorCode);
            objectOutput.writeObject(this.completionStatus);
        } else if (this.status == 1) {
            objectOutput.writeObject(this.exceptionId);
        } else if (this.status == 3) {
            ReplyMessage.writeIOR(objectOutput, this.ior);
        } else if (this.status == 5) {
            objectOutput.writeShort(this.addressingDisposition);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.serviceContexts = (ServiceContextList)objectInput.readObject();
        this.status = objectInput.readInt();
        if (this.status == 2) {
            this.exClassName = (String)objectInput.readObject();
            this.minorCode = objectInput.readInt();
            this.completionStatus = (CompletionStatus)objectInput.readObject();
        } else if (this.status == 1) {
            this.exceptionId = (String)objectInput.readObject();
        } else if (this.status == 3) {
            this.ior = (IOR)ReplyMessage.readIOR(objectInput);
        } else if (this.status == 5) {
            this.addressingDisposition = objectInput.readShort();
            this.needsReAddressing = true;
        }
    }
}

